/*
 * Decompiled with CFR 0.152.
 */
package ome.util;

import java.util.Collection;
import java.util.Map;
import ome.conditions.InternalException;
import ome.model.IObject;
import ome.model.internal.Details;
import ome.util.Filter;
import ome.util.Filterable;
import ome.util.ShallowCopy;

class SetValues
implements Filter {
    private IObject target;

    public SetValues(IObject target) {
        this.target = target;
    }

    public Filterable filter(String fieldId, Filterable f) {
        if (f == null) {
            return null;
        }
        if (Details.class.isAssignableFrom(f.getClass())) {
            this.target.putAt(fieldId, ((Details)f).shallowCopy());
        } else if (IObject.class.isAssignableFrom(f.getClass())) {
            IObject old = (IObject)f;
            IObject iobj = ShallowCopy.reflectiveNewInstance(old);
            iobj.setId(old.getId());
            iobj.unload();
            this.target.putAt(fieldId, iobj);
        } else {
            throw new InternalException("Unknown filterable type:" + f.getClass());
        }
        return f;
    }

    public Collection filter(String fieldId, Collection c) {
        this.target.putAt(fieldId, null);
        return c;
    }

    public Map filter(String fieldId, Map m) {
        this.target.putAt(fieldId, null);
        return m;
    }

    public Object filter(String fieldId, Object o) {
        if (o == null) {
            this.target.putAt(fieldId, null);
        } else if (Object[].class.isAssignableFrom(o.getClass())) {
            this.target.putAt(fieldId, null);
        } else {
            this.target.putAt(fieldId, o);
        }
        return o;
    }
}

