/*
 * Decompiled with CFR 0.152.
 */
package ome.system;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import ome.api.ServiceInterface;
import ome.conditions.ApiUsageException;
import ome.system.PreferenceContext;
import ome.util.messages.InternalMessage;
import ome.util.messages.MessageException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OmeroContext
extends ClassPathXmlApplicationContext {
    public static final String CLIENT_CONTEXT = "ome.client";
    public static final String MANAGED_CONTEXT = "ome.server";
    private static OmeroContext _client;
    private static OmeroContext _managed;
    private ApplicationEventMulticaster multicaster;
    private static final Object mutex;

    public OmeroContext(String configLocation) throws BeansException {
        super(configLocation);
    }

    public OmeroContext(String[] configLocations) throws BeansException {
        super(configLocations);
    }

    public OmeroContext(String[] configLocations, boolean refresh) throws BeansException {
        super(configLocations, refresh);
    }

    public OmeroContext(String[] configLocations, ApplicationContext parent) throws BeansException {
        super(configLocations, parent);
    }

    public OmeroContext(String[] configLocations, boolean refresh, ApplicationContext parent) throws BeansException {
        super(configLocations, refresh, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OmeroContext getClientContext() {
        Object object = mutex;
        synchronized (object) {
            if (_client == null) {
                _client = OmeroContext.getInstance(CLIENT_CONTEXT);
            }
            return _client;
        }
    }

    public static OmeroContext getClientContext(Properties props) {
        return OmeroContext.getContext(props, CLIENT_CONTEXT);
    }

    public static OmeroContext getContext(Properties props, String context) {
        if (props == null || context == null) {
            throw new ApiUsageException("Arguments may not be null.");
        }
        Properties copy = new Properties(props);
        ConstructorArgumentValues ctorArg = new ConstructorArgumentValues();
        ctorArg.addGenericArgumentValue(copy);
        RootBeanDefinition definition = new RootBeanDefinition(Properties.class, ctorArg, null);
        StaticApplicationContext staticContext = new StaticApplicationContext();
        staticContext.registerBeanDefinition("properties", definition);
        staticContext.refresh();
        OmeroContext ctx = new Locator().lookup(context, staticContext);
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OmeroContext getManagedServerContext() {
        Object object = mutex;
        synchronized (object) {
            if (_managed == null) {
                _managed = OmeroContext.getInstance(MANAGED_CONTEXT);
            }
            return _managed;
        }
    }

    public static OmeroContext getInstance(String beanFactoryName) {
        OmeroContext ctx = (OmeroContext)ContextSingletonBeanFactoryLocator.getInstance().useBeanFactory(beanFactoryName).getFactory();
        try {
            ctx.getBeanFactory();
        }
        catch (IllegalStateException ise) {
            try {
                ctx.refresh();
            }
            catch (RuntimeException re) {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw re;
            }
        }
        return ctx;
    }

    public void applyBeanPropertyValues(Object target, String beanName) {
        this.getAutowireCapableBeanFactory().applyBeanPropertyValues(target, beanName);
    }

    public void applyBeanPropertyValues(Object target, Class<? extends ServiceInterface> beanInterface) {
        this.applyBeanPropertyValues(target, "internal-" + beanInterface.getName());
    }

    public void refreshAll() {
        ApplicationContext ac = this;
        LinkedList<ConfigurableApplicationContext> list = new LinkedList<ConfigurableApplicationContext>();
        while (ac instanceof ConfigurableApplicationContext) {
            list.add((ConfigurableApplicationContext)ac);
            ac = ac.getParent();
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            ((ConfigurableApplicationContext)list.get(i)).refresh();
        }
    }

    public void refreshAllIfNecessary() {
        try {
            this.isRunning();
        }
        catch (IllegalStateException ise) {
            this.refreshAll();
        }
    }

    public void closeAll() {
        ApplicationContext ac = this;
        LinkedList<ConfigurableApplicationContext> list = new LinkedList<ConfigurableApplicationContext>();
        while (ac instanceof ConfigurableApplicationContext) {
            list.add((ConfigurableApplicationContext)ac);
            ac = ac.getParent();
        }
        for (int i = 0; i < list.size(); ++i) {
            ((ConfigurableApplicationContext)list.get(i)).close();
        }
    }

    public String getProperty(String propertyName) {
        PreferenceContext pc = (PreferenceContext)this.getBean("preferenceContext");
        return pc.getProperty(propertyName);
    }

    @Override
    public void publishEvent(ApplicationEvent event) {
        this.multicaster.multicastEvent(event);
    }

    public void publishMessage(InternalMessage msg) throws Throwable {
        try {
            this.publishEvent(msg);
        }
        catch (MessageException me) {
            throw me.getException();
        }
    }

    @Override
    protected void onRefresh() throws BeansException {
        super.onRefresh();
        this.multicaster = (ApplicationEventMulticaster)this.getBean("applicationEventMulticaster");
    }

    static {
        mutex = new Object();
    }

    protected static class Locator
    extends ContextSingletonBeanFactoryLocator {
        private static final String BEANS_REFS_XML_NAME = "classpath*:beanRefContext.xml";

        public Locator() {
            super(null);
        }

        public OmeroContext lookup(String selector, ApplicationContext parent) {
            ConfigurableApplicationContext beanRefContext = (ConfigurableApplicationContext)this.createDefinition(BEANS_REFS_XML_NAME, "manual");
            this.initializeDefinition(beanRefContext);
            BeanDefinition definition = beanRefContext.getBeanFactory().getBeanDefinition(selector);
            ConstructorArgumentValues.ValueHolder holder = definition.getConstructorArgumentValues().getGenericArgumentValue(List.class);
            List files = (List)holder.getValue();
            ArrayList<String> fileStrings = new ArrayList<String>(files.size());
            for (TypedStringValue tsv : files) {
                fileStrings.add(tsv.getValue());
            }
            OmeroContext c = new OmeroContext(fileStrings.toArray(new String[0]), true, parent);
            return c;
        }
    }
}

