/*
 * Decompiled with CFR 0.152.
 */
package ome.model.roi;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.roi.Shape;
import ome.util.DetailsFieldBridge;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@DiscriminatorValue(value="point")
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class Point
extends Shape
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "point_owner_filter";
    public static final String GROUP_FILTER = "point_group_filter";
    public static final String EVENT_FILTER = "point_event_filter";
    public static final String PERMS_FILTER = "point_perms_filter";
    protected Double cx = null;
    protected Double cy = null;
    protected String textValue = null;
    public static final String CX = "ome.model.roi.Point_cx";
    public static final String CY = "ome.model.roi.Point_cy";
    public static final String TEXTVALUE = "ome.model.roi.Point_textValue";
    public static final Set<String> FIELDS;

    public Point() {
        this(null, true);
    }

    protected Point(Long id) {
        this(id, true);
    }

    public Point(Long id, boolean loaded) {
        super(id, loaded);
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="cx", updatable=true)
    public Double getCx() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.cx;
    }

    public void setCx(Double cx) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.cx = cx;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="cy", updatable=true)
    public Double getCy() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.cy;
    }

    public void setCy(Double cy) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.cy = cy;
    }

    @Type(type="org.hibernate.type.TextType")
    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="textValue", updatable=true)
    public String getTextValue() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.textValue;
    }

    public void setTextValue(String textValue) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.textValue = textValue;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public Point newInstance() {
        return new Point();
    }

    public Point proxy() {
        return new Point(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.cx = (Double)__filter.filter(CX, this.cx);
            this.cy = (Double)__filter.filter(CY, this.cy);
            this.textValue = (String)__filter.filter(TEXTVALUE, this.textValue);
            return super.acceptFilter(__filter);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(CX)) {
            return this.getCx();
        }
        if (field.equals(CY)) {
            return this.getCy();
        }
        if (field.equals(TEXTVALUE)) {
            return this.getTextValue();
        }
        return super.retrieve(field);
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(CX)) {
            this.setCx((Double)value);
        } else if (field.equals(CY)) {
            this.setCy((Double)value);
        } else if (field.equals(TEXTVALUE)) {
            this.setTextValue((String)value);
        } else {
            super.putAt(field, value);
        }
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.cx = null;
        this.cy = null;
        this.textValue = null;
        super.unload();
    }

    @Override
    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(CX);
        raw.addAll(Shape.FIELDS);
        raw.add(CY);
        raw.addAll(Shape.FIELDS);
        raw.add(TEXTVALUE);
        raw.addAll(Shape.FIELDS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

