/*
 * Decompiled with CFR 0.152.
 */
package ome.model.containers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IAnnotated;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.model.annotations.ProjectAnnotationLink;
import ome.model.containers.Dataset;
import ome.model.containers.ProjectDatasetLink;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.util.CBlock;
import ome.util.CountCollectionPersister;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FilterDefs(value={@FilterDef(name="project_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="project_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="project_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="project_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="project_owner_filter_DATASETLINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="project_group_filter_DATASETLINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="project_event_filter_DATASETLINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="project_perms_filter_DATASETLINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="project_owner_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="project_group_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="project_event_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="project_perms_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="project_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="project_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="project_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="project_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="securityFilter")})
@Entity
@Table(name="project", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_project", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_project"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class Project
implements Serializable,
IObject,
IMutable,
IAnnotated {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "project_owner_filter";
    public static final String GROUP_FILTER = "project_group_filter";
    public static final String EVENT_FILTER = "project_event_filter";
    public static final String PERMS_FILTER = "project_perms_filter";
    public static final String ID = "ome.model.containers.Project_id";
    protected Long id;
    public static final String VERSION = "ome.model.containers.Project_version";
    protected Integer version = 0;
    protected Set<ProjectDatasetLink> datasetLinks = new HashSet<ProjectDatasetLink>();
    public static final String OWNER_FILTER_DATASETLINKS = "project_owner_filter_DATASETLINKS";
    public static final String GROUP_FILTER_DATASETLINKS = "project_group_filter_DATASETLINKS";
    public static final String EVENT_FILTER_DATASETLINKS = "project_event_filter_DATASETLINKS";
    public static final String PERMS_FILTER_DATASETLINKS = "project_perms_filter_DATASETLINKS";
    private Map<Long, Long> datasetLinksCountPerOwner = null;
    protected Set<ProjectAnnotationLink> annotationLinks = new HashSet<ProjectAnnotationLink>();
    public static final String OWNER_FILTER_ANNOTATIONLINKS = "project_owner_filter_ANNOTATIONLINKS";
    public static final String GROUP_FILTER_ANNOTATIONLINKS = "project_group_filter_ANNOTATIONLINKS";
    public static final String EVENT_FILTER_ANNOTATIONLINKS = "project_event_filter_ANNOTATIONLINKS";
    public static final String PERMS_FILTER_ANNOTATIONLINKS = "project_perms_filter_ANNOTATIONLINKS";
    private Map<Long, Long> annotationLinksCountPerOwner = null;
    protected String name = null;
    protected String description = null;
    protected ome.model.internal.Details details = new Details();
    public static final String DATASETLINKSCOUNTPEROWNER = "ome.model.containers.Project_datasetLinksCountPerOwner";
    public static final String DATASETLINKS = "ome.model.containers.Project_datasetLinks";
    public static final String ANNOTATIONLINKSCOUNTPEROWNER = "ome.model.containers.Project_annotationLinksCountPerOwner";
    public static final String ANNOTATIONLINKS = "ome.model.containers.Project_annotationLinks";
    public static final String NAME = "ome.model.containers.Project_name";
    public static final String DESCRIPTION = "ome.model.containers.Project_description";
    public static final String DETAILS = "ome.model.containers.Project_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public Project() {
        this(null, true);
    }

    protected Project(Long id) {
        this(id, true);
    }

    public Project(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public Project(String _name) {
        this(null, true);
        this.setName(_name);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_project")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="project_owner_filter_DATASETLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="project_group_filter_DATASETLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="project_event_filter_DATASETLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="project_perms_filter_DATASETLINKS", condition=":permsStr = permissions")})
    protected Set<ProjectDatasetLink> getDatasetLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.datasetLinks;
    }

    protected void setDatasetLinks(Set<ProjectDatasetLink> datasetLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.datasetLinks = datasetLinks;
    }

    public int sizeOfDatasetLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.datasetLinks == null ? -1 : this.datasetLinks.size();
    }

    public Iterator<ProjectDatasetLink> iterateDatasetLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDatasetLinks() == null) {
            return new EmptyIterator<ProjectDatasetLink>();
        }
        return this.getDatasetLinks().iterator();
    }

    public Collection<ProjectDatasetLink> unmodifiableDatasetLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDatasetLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getDatasetLinks());
    }

    public <E> List<E> collectDatasetLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<ProjectDatasetLink> it = this.iterateDatasetLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addProjectDatasetLink(ProjectDatasetLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDatasetLinks() == null) {
            this.throwNullCollectionException("DatasetLinks");
        }
        this.getDatasetLinks().add(target);
        if (target != null) {
            target.setParent(this);
        }
    }

    public void addProjectDatasetLinkSet(Collection<ProjectDatasetLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDatasetLinks() == null) {
            this.throwNullCollectionException("DatasetLinks");
        }
        this.getDatasetLinks().addAll(targets);
        for (ProjectDatasetLink target : targets) {
            if (target == null) continue;
            target.setParent(this);
        }
    }

    public void removeProjectDatasetLink(ProjectDatasetLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDatasetLinks() == null) {
            this.throwNullCollectionException("DatasetLinks");
        }
        this.getDatasetLinks().remove(target);
        target.setParent(null);
    }

    public void removeProjectDatasetLinkSet(Collection<ProjectDatasetLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDatasetLinks() == null) {
            this.throwNullCollectionException("DatasetLinks");
        }
        this.getDatasetLinks().removeAll(targets);
        for (ProjectDatasetLink target : targets) {
            target.setParent(null);
        }
    }

    public ProjectDatasetLink linkDataset(Dataset addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ProjectDatasetLink link = new ProjectDatasetLink();
        link.link(this, addition);
        this.addProjectDatasetLink(link, true);
        return link;
    }

    public void addProjectDatasetLink(ProjectDatasetLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDatasetLinks() == null) {
            this.throwNullCollectionException("DatasetLinks");
        }
        this.getDatasetLinks().add(link);
        if (bothSides && link.child().isLoaded()) {
            link.child().addProjectDatasetLink(link, false);
        }
    }

    public Iterator<Dataset> linkedDatasetIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDatasetLinks() == null) {
            return new EmptyIterator<Dataset>();
        }
        final Iterator<ProjectDatasetLink> it = this.getDatasetLinks().iterator();
        return new Iterator<Dataset>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Dataset next() {
                if (it == null) {
                    throw new NoSuchElementException("datasetLinks is null; no elements.");
                }
                ProjectDatasetLink link = (ProjectDatasetLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<ProjectDatasetLink> findProjectDatasetLink(Dataset target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<ProjectDatasetLink> it = this.iterateDatasetLinks();
        HashSet<ProjectDatasetLink> result = new HashSet<ProjectDatasetLink>();
        while (it.hasNext()) {
            ProjectDatasetLink link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    public List<Dataset> linkedDatasetList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Dataset> it = this.linkedDatasetIterator();
        ArrayList<Dataset> list = new ArrayList<Dataset>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public <E> List<E> eachLinkedDataset(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Dataset> it = this.linkedDatasetIterator();
        while (it.hasNext()) {
            Dataset obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void unlinkDataset(Dataset removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<ProjectDatasetLink> toRemove = this.findProjectDatasetLink(removal);
        Iterator<ProjectDatasetLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeProjectDatasetLink(it.next(), true);
        }
    }

    public void removeProjectDatasetLink(ProjectDatasetLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDatasetLinks() == null) {
            this.throwNullCollectionException("DatasetLinks");
        }
        this.getDatasetLinks().remove(link);
        if (bothSides && link.child().isLoaded()) {
            link.child().removeProjectDatasetLink(link, false);
        }
    }

    public void clearDatasetLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<ProjectDatasetLink> list = new ArrayList<ProjectDatasetLink>(this.getDatasetLinks());
        for (ProjectDatasetLink link : list) {
            this.removeProjectDatasetLink(link, true);
        }
    }

    protected void setDatasetLinksCountPerOwner(Map<Long, Long> map) {
        this.datasetLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_Project_datasetLinks")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_Project_datasetLinks_by_owner", joinColumns={@JoinColumn(name="Project_id")})
    public Map<Long, Long> getDatasetLinksCountPerOwner() {
        return this.datasetLinksCountPerOwner;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="project_owner_filter_ANNOTATIONLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="project_group_filter_ANNOTATIONLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="project_event_filter_ANNOTATIONLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="project_perms_filter_ANNOTATIONLINKS", condition=":permsStr = permissions")})
    protected Set<ProjectAnnotationLink> getAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks;
    }

    protected void setAnnotationLinks(Set<ProjectAnnotationLink> annotationLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.annotationLinks = annotationLinks;
    }

    @Override
    public int sizeOfAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks == null ? -1 : this.annotationLinks.size();
    }

    public Iterator<ProjectAnnotationLink> iterateAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<ProjectAnnotationLink>();
        }
        return this.getAnnotationLinks().iterator();
    }

    public Collection<ProjectAnnotationLink> unmodifiableAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getAnnotationLinks());
    }

    @Override
    public <E> List<E> collectAnnotationLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<ProjectAnnotationLink> it = this.iterateAnnotationLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addProjectAnnotationLink(ProjectAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(target);
        if (target != null) {
            target.setParent(this);
        }
    }

    public void addProjectAnnotationLinkSet(Collection<ProjectAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().addAll(targets);
        for (ProjectAnnotationLink target : targets) {
            if (target == null) continue;
            target.setParent(this);
        }
    }

    public void removeProjectAnnotationLink(ProjectAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(target);
        target.setParent(null);
    }

    public void removeProjectAnnotationLinkSet(Collection<ProjectAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().removeAll(targets);
        for (ProjectAnnotationLink target : targets) {
            target.setParent(null);
        }
    }

    public ProjectAnnotationLink linkAnnotation(Annotation addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ProjectAnnotationLink link = new ProjectAnnotationLink();
        link.link(this, addition);
        this.addProjectAnnotationLink(link, true);
        return link;
    }

    public void addProjectAnnotationLink(ProjectAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(link);
    }

    @Override
    public Iterator<Annotation> linkedAnnotationIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<Annotation>();
        }
        final Iterator<ProjectAnnotationLink> it = this.getAnnotationLinks().iterator();
        return new Iterator<Annotation>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Annotation next() {
                if (it == null) {
                    throw new NoSuchElementException("annotationLinks is null; no elements.");
                }
                ProjectAnnotationLink link = (ProjectAnnotationLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<ProjectAnnotationLink> findProjectAnnotationLink(Annotation target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<ProjectAnnotationLink> it = this.iterateAnnotationLinks();
        HashSet<ProjectAnnotationLink> result = new HashSet<ProjectAnnotationLink>();
        while (it.hasNext()) {
            ProjectAnnotationLink link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public List<Annotation> linkedAnnotationList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Override
    public <E> List<E> eachLinkedAnnotation(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        while (it.hasNext()) {
            Annotation obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<ProjectAnnotationLink> toRemove = this.findProjectAnnotationLink(removal);
        Iterator<ProjectAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeProjectAnnotationLink(it.next(), true);
        }
    }

    public void removeProjectAnnotationLink(ProjectAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(link);
    }

    @Override
    public void clearAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<ProjectAnnotationLink> list = new ArrayList<ProjectAnnotationLink>(this.getAnnotationLinks());
        for (ProjectAnnotationLink link : list) {
            this.removeProjectAnnotationLink(link, true);
        }
    }

    protected void setAnnotationLinksCountPerOwner(Map<Long, Long> map) {
        this.annotationLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_Project_annotationLinks")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_Project_annotationLinks_by_owner", joinColumns={@JoinColumn(name="Project_id")})
    public Map<Long, Long> getAnnotationLinksCountPerOwner() {
        return this.annotationLinksCountPerOwner;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="name", updatable=true)
    public String getName() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.name;
    }

    public void setName(String name) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.name = name;
    }

    @Type(type="org.hibernate.type.TextType")
    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="description", updatable=true)
    public String getDescription() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.description;
    }

    public void setDescription(String description) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.description = description;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public Project newInstance() {
        return new Project();
    }

    public Project proxy() {
        return new Project(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.datasetLinksCountPerOwner = __filter.filter(DATASETLINKSCOUNTPEROWNER, this.datasetLinksCountPerOwner);
            this.datasetLinks = (Set)__filter.filter(DATASETLINKS, this.datasetLinks);
            this.annotationLinksCountPerOwner = __filter.filter(ANNOTATIONLINKSCOUNTPEROWNER, this.annotationLinksCountPerOwner);
            this.annotationLinks = (Set)__filter.filter(ANNOTATIONLINKS, this.annotationLinks);
            this.name = (String)__filter.filter(NAME, this.name);
            this.description = (String)__filter.filter(DESCRIPTION, this.description);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(DATASETLINKSCOUNTPEROWNER)) {
            return this.getDatasetLinksCountPerOwner();
        }
        if (field.equals(DATASETLINKS)) {
            return this.getDatasetLinks();
        }
        if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            return this.getAnnotationLinksCountPerOwner();
        }
        if (field.equals(ANNOTATIONLINKS)) {
            return this.getAnnotationLinks();
        }
        if (field.equals(NAME)) {
            return this.getName();
        }
        if (field.equals(DESCRIPTION)) {
            return this.getDescription();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(DATASETLINKSCOUNTPEROWNER)) {
            this.setDatasetLinksCountPerOwner((Map)value);
        } else if (field.equals(DATASETLINKS)) {
            this.setDatasetLinks((Set)value);
        } else if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            this.setAnnotationLinksCountPerOwner((Map)value);
        } else if (field.equals(ANNOTATIONLINKS)) {
            this.setAnnotationLinks((Set)value);
        } else if (field.equals(NAME)) {
            this.setName((String)value);
        } else if (field.equals(DESCRIPTION)) {
            this.setDescription((String)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.datasetLinksCountPerOwner = null;
        this.datasetLinks = null;
        this.annotationLinksCountPerOwner = null;
        this.annotationLinks = null;
        this.name = null;
        this.description = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(DATASETLINKSCOUNTPEROWNER);
        raw.add(DATASETLINKS);
        raw.add(ANNOTATIONLINKSCOUNTPEROWNER);
        raw.add(ANNOTATIONLINKS);
        raw.add(NAME);
        raw.add(DESCRIPTION);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public ome.model.internal.Details newInstance() {
            return new Details();
        }

        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=false)
        @ForeignKey(name="FKproject_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKproject_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKproject_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKproject_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKproject_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

