/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ome.formats.Index;
import ome.formats.model.IObjectContainerStore;
import ome.formats.model.ModelException;
import ome.formats.model.ModelProcessor;
import ome.util.LSID;
import omero.metadatastore.IObjectContainer;
import omero.model.DetectorSettings;
import omero.model.LightPath;
import omero.model.LightSettings;
import omero.model.ObjectiveSettings;
import omero.model.WellSample;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReferenceProcessor
implements ModelProcessor {
    private Log log = LogFactory.getLog(ReferenceProcessor.class);

    public void process(IObjectContainerStore store) throws ModelException {
        HashMap<String, String[]> referenceStringCache = new HashMap<String, String[]>();
        Map<LSID, List<LSID>> referenceCache = store.getReferenceCache();
        Map<LSID, IObjectContainer> containerCache = store.getContainerCache();
        try {
            for (LSID target : referenceCache.keySet()) {
                String lsid;
                IObjectContainer container = containerCache.get(target);
                Class targetClass = target.getJavaClass();
                ArrayList<String> references = new ArrayList<String>();
                for (LSID reference : referenceCache.get(target)) {
                    if (container == null) {
                        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
                        int[] indexArray = target.getIndexes();
                        if (targetClass == null) {
                            this.log.warn((Object)("Unknown target class for LSID: " + target));
                            references.add(reference.toString());
                            continue;
                        }
                        if (targetClass.equals(DetectorSettings.class)) {
                            indexes.put(Index.IMAGE_INDEX, indexArray[0]);
                            indexes.put(Index.CHANNEL_INDEX, indexArray[1]);
                        } else if (targetClass.equals(LightSettings.class)) {
                            indexes.put(Index.IMAGE_INDEX, indexArray[0]);
                            indexes.put(Index.CHANNEL_INDEX, indexArray[1]);
                        } else if (targetClass.equals(ObjectiveSettings.class)) {
                            indexes.put(Index.IMAGE_INDEX, indexArray[0]);
                        } else if (targetClass.equals(WellSample.class)) {
                            indexes.put(Index.PLATE_INDEX, indexArray[0]);
                            indexes.put(Index.WELL_INDEX, indexArray[1]);
                            indexes.put(Index.WELL_SAMPLE_INDEX, indexArray[2]);
                        } else if (targetClass.equals(LightPath.class)) {
                            indexes.put(Index.IMAGE_INDEX, indexArray[0]);
                            indexes.put(Index.CHANNEL_INDEX, indexArray[1]);
                        } else {
                            throw new RuntimeException(String.format("Unable to synchronize reference %s --> %s", reference, target));
                        }
                        container = store.getIObjectContainer(targetClass, indexes);
                    }
                    references.add(reference.toString());
                }
                String string = lsid = targetClass == null ? target.toString() : container.LSID;
                if (referenceStringCache.containsKey(lsid)) {
                    String[] existing = (String[])referenceStringCache.get(lsid);
                    references.addAll(Arrays.asList(existing));
                }
                String[] referencesAsString = references.toArray(new String[references.size()]);
                referenceStringCache.put(lsid, referencesAsString);
            }
            store.setReferenceStringCache(referenceStringCache);
        }
        catch (Exception e) {
            throw new ModelException("Error processing references.", null, e);
        }
    }
}

