/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import loci.formats.IFormatReader;
import ome.formats.model.ChannelData;
import ome.formats.model.ColorsFactory;
import ome.formats.model.IObjectContainerStore;
import ome.formats.model.ModelException;
import ome.formats.model.ModelProcessor;
import ome.util.LSID;
import omero.RInt;
import omero.RString;
import omero.model.Channel;
import omero.model.Filter;
import omero.model.Image;
import omero.model.Laser;
import omero.model.LightSource;
import omero.model.LogicalChannel;
import omero.model.Pixels;
import omero.model.TransmittanceRange;
import omero.rtypes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelProcessor
implements ModelProcessor {
    public static final String RED_TEXT = "Red";
    public static final String GREEN_TEXT = "Green";
    public static final String BLUE_TEXT = "Blue";
    public static final String ALPHA_TEXT = "Alpha";
    private Log log = LogFactory.getLog(ChannelProcessor.class);
    private IObjectContainerStore store;
    private IFormatReader reader;

    private void populateDefault(ChannelData channelData, boolean isGraphicsDomain) {
        LightSource ls;
        int channelIndex = channelData.getChannelIndex();
        Channel channel = channelData.getChannel();
        LogicalChannel lc = channelData.getLogicalChannel();
        if (isGraphicsDomain) {
            this.log.debug((Object)"Setting color channel to RGB.");
            this.setDefaultChannelColor(channel, channelIndex);
            switch (channelIndex) {
                case 0: {
                    if (lc.getName() != null) break;
                    lc.setName(rtypes.rstring(RED_TEXT));
                    break;
                }
                case 1: {
                    if (lc.getName() != null) break;
                    lc.setName(rtypes.rstring(GREEN_TEXT));
                    break;
                }
                case 2: {
                    if (lc.getName() != null) break;
                    lc.setName(rtypes.rstring(BLUE_TEXT));
                    break;
                }
                case 3: {
                    channel.setRed(rtypes.rint(0));
                    channel.setGreen(rtypes.rint(0));
                    channel.setBlue(rtypes.rint(0));
                    channel.setAlpha(rtypes.rint(0));
                    if (lc.getName() != null) break;
                    lc.setName(rtypes.rstring(ALPHA_TEXT));
                }
            }
            return;
        }
        Integer red = this.getValue(channel.getRed());
        Integer green = this.getValue(channel.getGreen());
        Integer blue = this.getValue(channel.getBlue());
        Integer alpha = this.getValue(channel.getAlpha());
        if (red != null && green != null && blue != null && alpha != null) {
            RString name;
            this.log.debug((Object)"Already set in BF.");
            if (lc.getName() == null && (name = this.getChannelName(channelData)) != null) {
                lc.setName(name);
            }
            return;
        }
        Integer value = this.getValue(lc.getEmissionWave());
        if (value != null) {
            this.setChannelColor(channel, channelIndex, ColorsFactory.determineColor(value));
            if (lc.getName() == null) {
                lc.setName(rtypes.rstring(value.toString()));
            }
            return;
        }
        Filter f = this.getValidFilter(channelData.getLightPathEmissionFilters(), true);
        if (f != null) {
            value = ColorsFactory.getValueFromFilter(f, true);
        }
        if (value != null) {
            RString name;
            this.setChannelColor(channel, channelIndex, ColorsFactory.determineColor(value));
            if (lc.getName() == null && (name = this.getNameFromFilter(f)) != null) {
                lc.setName(name);
            }
            return;
        }
        f = channelData.getFilterSetEmissionFilter();
        value = ColorsFactory.getValueFromFilter(f, true);
        if (value != null) {
            RString name;
            this.setChannelColor(channel, channelIndex, ColorsFactory.determineColor(value));
            if (lc.getName() == null && (name = this.getNameFromFilter(f)) != null) {
                lc.setName(name);
            }
            return;
        }
        if (channelData.getLightSource() != null && (ls = channelData.getLightSource()) instanceof Laser && (value = this.getValue(((Laser)ls).getWavelength())) != null) {
            this.setChannelColor(channel, channelIndex, ColorsFactory.determineColor(value));
            if (lc.getName() == null) {
                lc.setName(rtypes.rstring(value.toString()));
            }
            return;
        }
        value = this.getValue(lc.getExcitationWave());
        if (value != null) {
            this.setChannelColor(channel, channelIndex, ColorsFactory.determineColor(value));
            if (lc.getName() == null) {
                lc.setName(rtypes.rstring(value.toString()));
            }
            return;
        }
        f = this.getValidFilter(channelData.getLightPathExcitationFilters(), false);
        if (f != null) {
            value = ColorsFactory.getValueFromFilter(f, false);
        }
        if (value != null) {
            RString name;
            this.setChannelColor(channel, channelIndex, ColorsFactory.determineColor(value));
            if (lc.getName() == null && (name = this.getNameFromFilter(f)) != null) {
                lc.setName(name);
            }
            return;
        }
        f = channelData.getFilterSetExcitationFilter();
        value = ColorsFactory.getValueFromFilter(f, false);
        if (value != null) {
            RString name;
            this.setChannelColor(channel, channelIndex, ColorsFactory.determineColor(value));
            if (lc.getName() == null && (name = this.getNameFromFilter(f)) != null) {
                lc.setName(name);
            }
            return;
        }
        this.setDefaultChannelColor(channel, channelIndex);
    }

    private Filter getValidFilter(List<Filter> filters, boolean emission) {
        if (filters == null) {
            return null;
        }
        Iterator<Filter> i = filters.iterator();
        Integer value = null;
        while (i.hasNext()) {
            Filter f = i.next();
            value = ColorsFactory.getValueFromFilter(f, emission);
            if (value == null) continue;
            return f;
        }
        return null;
    }

    private void setDefaultChannelColor(Channel channel, int index) {
        int[] defaultColor;
        switch (index) {
            case 0: {
                defaultColor = ColorsFactory.newRedColor();
                break;
            }
            case 1: {
                defaultColor = ColorsFactory.newGreenColor();
                break;
            }
            default: {
                defaultColor = ColorsFactory.newBlueColor();
            }
        }
        channel.setRed(rtypes.rint(defaultColor[0]));
        channel.setGreen(rtypes.rint(defaultColor[1]));
        channel.setBlue(rtypes.rint(defaultColor[2]));
        channel.setAlpha(rtypes.rint(defaultColor[3]));
    }

    private void setChannelColor(Channel channel, int index, int[] rgba) {
        if (rgba == null) {
            this.setDefaultChannelColor(channel, index);
            return;
        }
        channel.setRed(rtypes.rint(rgba[0]));
        channel.setGreen(rtypes.rint(rgba[1]));
        channel.setBlue(rtypes.rint(rgba[2]));
        channel.setAlpha(rtypes.rint(rgba[3]));
    }

    private RString getNameFromFilter(Filter filter) {
        if (filter == null) {
            return null;
        }
        TransmittanceRange t = filter.getTransmittanceRange();
        return t == null ? null : rtypes.rstring(String.valueOf(t.getCutIn().getValue()));
    }

    private Integer getValue(RInt value) {
        return value == null ? null : Integer.valueOf(value.getValue());
    }

    private RString getChannelName(ChannelData channelData) {
        Laser laser;
        RString name;
        Iterator<Filter> i;
        LogicalChannel lc = channelData.getLogicalChannel();
        Integer value = this.getValue(lc.getEmissionWave());
        if (value != null) {
            return rtypes.rstring(value.toString());
        }
        List<Filter> filters = channelData.getLightPathEmissionFilters();
        if (filters != null) {
            i = filters.iterator();
            while (i.hasNext()) {
                name = this.getNameFromFilter(i.next());
                if (name == null) continue;
                return name;
            }
        }
        if ((name = this.getNameFromFilter(channelData.getFilterSetEmissionFilter())) != null) {
            return name;
        }
        LightSource ls = channelData.getLightSource();
        if (ls != null && ls instanceof Laser && (value = this.getValue((laser = (Laser)ls).getWavelength())) != null) {
            return rtypes.rstring(value.toString());
        }
        value = this.getValue(lc.getExcitationWave());
        if (value != null) {
            return rtypes.rstring(value.toString());
        }
        filters = channelData.getLightPathExcitationFilters();
        if (filters != null) {
            i = filters.iterator();
            while (i.hasNext()) {
                name = this.getNameFromFilter(i.next());
                if (name == null) continue;
                return name;
            }
        }
        name = this.getNameFromFilter(channelData.getFilterSetExcitationFilter());
        return name;
    }

    @Override
    public void process(IObjectContainerStore store) throws ModelException {
        this.store = store;
        this.reader = this.store.getReader();
        if (this.reader == null) {
            this.log.warn((Object)"Unexpected null reader.");
            return;
        }
        List<Image> images = store.getSourceObjects(Image.class);
        String[] domains = this.reader.getDomains();
        boolean isGraphicsDomain = false;
        for (String domain : domains) {
            if (!"Graphics".equals(domain)) continue;
            this.log.debug((Object)"Images are of the graphics domain.");
            isGraphicsDomain = true;
            break;
        }
        this.log.debug((Object)("isGraphicsDomain: " + isGraphicsDomain));
        for (int i = 0; i < images.size(); ++i) {
            Pixels pixels = (Pixels)store.getSourceObject(new LSID(Pixels.class, i));
            if (pixels == null) {
                throw new ModelException("Unable to locate Pixels:" + i);
            }
            int count = 0;
            HashMap<ChannelData, Boolean> m = new HashMap<ChannelData, Boolean>();
            int sizeC = pixels.getSizeC().getValue();
            for (int c = 0; c < sizeC; ++c) {
                ChannelData channelData = ChannelData.fromObjectContainerStore(store, i, c);
                this.populateDefault(channelData, isGraphicsDomain);
                if (isGraphicsDomain) continue;
                boolean v = ColorsFactory.hasEmissionData(channelData);
                if (!v) {
                    ++count;
                }
                m.put(channelData, v);
            }
            if (count <= 0 || count == m.size()) continue;
            for (ChannelData channelData : m.keySet()) {
                if (((Boolean)m.get(channelData)).booleanValue()) continue;
                int[] defaultColor = ColorsFactory.newWhiteColor();
                Channel channel = channelData.getChannel();
                channel.setRed(rtypes.rint(defaultColor[0]));
                channel.setGreen(rtypes.rint(defaultColor[1]));
                channel.setBlue(rtypes.rint(defaultColor[2]));
                channel.setAlpha(rtypes.rint(defaultColor[3]));
            }
        }
    }
}

