/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ome.formats.Index;
import ome.formats.model.ChannelProcessor;
import ome.formats.model.IObjectContainerStore;
import ome.formats.model.ModelException;
import ome.util.LSID;
import omero.metadatastore.IObjectContainer;
import omero.model.Arc;
import omero.model.Channel;
import omero.model.Filament;
import omero.model.Filter;
import omero.model.FilterSet;
import omero.model.IObject;
import omero.model.Laser;
import omero.model.LightEmittingDiode;
import omero.model.LightPath;
import omero.model.LightSettings;
import omero.model.LightSource;
import omero.model.LogicalChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelData {
    private static final Log log = LogFactory.getLog(ChannelProcessor.class);
    private Channel channel;
    private Integer channelIndex;
    private LogicalChannel logicalChannel;
    private FilterSet filterSet;
    private Filter filterSetEmFilter;
    private Filter filterSetExFilter;
    private LightPath lightPath;
    private List<Filter> lightPathEmFilters;
    private List<Filter> lightPathExFilters;
    private LightSettings lightSourceSettings;
    private LightSource lightSource;
    private static final Class<?>[] LIGHT_SOURCE_TYPES = new Class[]{Arc.class, Filament.class, LightEmittingDiode.class, Laser.class};

    public static ChannelData fromObjectContainerStore(IObjectContainerStore store, int imageIndex, int channelIndex) {
        String lsidString;
        Map<LSID, List<LSID>> referenceCache = store.getReferenceCache();
        Map<Class<? extends IObject>, Map<String, IObjectContainer>> containerCache = store.getAuthoritativeContainerCache();
        ChannelData data = new ChannelData();
        data.channel = (Channel)store.getSourceObject(new LSID(Channel.class, imageIndex, channelIndex));
        data.channelIndex = channelIndex;
        if (data.channel == null) {
            LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
            indexes.put(Index.IMAGE_INDEX, imageIndex);
            indexes.put(Index.CHANNEL_INDEX, channelIndex);
            IObjectContainer container = store.getIObjectContainer(Channel.class, indexes);
            data.channel = (Channel)container.sourceObject;
        }
        LSID logicalChannelLSID = new LSID(LogicalChannel.class, imageIndex, channelIndex);
        data.logicalChannel = (LogicalChannel)store.getSourceObject(logicalChannelLSID);
        if (data.logicalChannel == null) {
            LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
            indexes.put(Index.IMAGE_INDEX, imageIndex);
            indexes.put(Index.CHANNEL_INDEX, channelIndex);
            IObjectContainer container = store.getIObjectContainer(LogicalChannel.class, indexes);
            data.logicalChannel = (LogicalChannel)container.sourceObject;
        }
        ArrayList<Filter> lightPathEmFilters = new ArrayList<Filter>();
        ArrayList<Filter> lightPathExFilters = new ArrayList<Filter>();
        data.lightPathEmFilters = lightPathEmFilters;
        data.lightPathExFilters = lightPathExFilters;
        List<LSID> references = referenceCache.get(logicalChannelLSID);
        Map<String, IObjectContainer> filterSetContainers = containerCache.get(FilterSet.class);
        Map<String, IObjectContainer> lightPathContainers = containerCache.get(LightPath.class);
        Map<String, IObjectContainer> filterContainers = containerCache.get(Filter.class);
        if (references != null) {
            for (LSID reference : references) {
                lsidString = reference.toString();
                if (filterSetContainers == null || !filterSetContainers.containsKey(lsidString)) continue;
                IObjectContainer filterSetContainer = filterSetContainers.get(lsidString);
                LSID filterSetLSID = new LSID(FilterSet.class, filterSetContainer.indexes.get(Index.INSTRUMENT_INDEX.getValue()), filterSetContainer.indexes.get(Index.FILTER_SET_INDEX.getValue()));
                data.filterSet = (FilterSet)filterSetContainer.sourceObject;
                List<LSID> filterSetReferences = referenceCache.get(filterSetLSID);
                if (filterSetReferences == null) continue;
                for (LSID filterSetReference : filterSetReferences) {
                    lsidString = filterSetReference.toString();
                    String unsuffixed = lsidString.substring(0, lsidString.lastIndexOf(58));
                    if (lsidString.endsWith(":OMERO_EMISSION_FILTER")) {
                        data.filterSetEmFilter = (Filter)filterContainers.get((Object)unsuffixed).sourceObject;
                    }
                    if (!lsidString.endsWith(":OMERO_EXCITATION_FILTER")) continue;
                    data.filterSetExFilter = (Filter)filterContainers.get((Object)unsuffixed).sourceObject;
                }
            }
        }
        LSID lightPathLSID = new LSID(LightPath.class, imageIndex, channelIndex);
        data.lightPath = (LightPath)store.getSourceObject(lightPathLSID);
        List<LSID> lightPathReferences = referenceCache.get(lightPathLSID);
        if (lightPathReferences != null) {
            for (LSID lightPathReference : lightPathReferences) {
                IObjectContainer c;
                lsidString = lightPathReference.toString();
                String unsuffixed = lsidString.substring(0, lsidString.lastIndexOf(58));
                if (lsidString.endsWith(":OMERO_EMISSION_FILTER")) {
                    c = filterContainers.get(unsuffixed);
                    if (c == null) {
                        throw new ModelException("No filter with LSID: " + unsuffixed);
                    }
                    lightPathEmFilters.add((Filter)c.sourceObject);
                }
                if (!lsidString.endsWith(":OMERO_EXCITATION_FILTER")) continue;
                c = filterContainers.get(unsuffixed);
                if (c == null) {
                    throw new ModelException("No filter with LSID: " + unsuffixed);
                }
                lightPathExFilters.add((Filter)c.sourceObject);
            }
        }
        LSID lightSettingsLSID = new LSID(LightSettings.class, imageIndex, channelIndex);
        data.lightSourceSettings = (LightSettings)store.getSourceObject(lightSettingsLSID);
        HashMap<String, IObjectContainer> lightSourceContainers = new HashMap<String, IObjectContainer>();
        if (data.lightSourceSettings != null) {
            for (Class<?> klass : LIGHT_SOURCE_TYPES) {
                Map<String, IObjectContainer> v = containerCache.get(klass);
                if (v == null) continue;
                lightSourceContainers.putAll(v);
            }
            references = referenceCache.get(lightSettingsLSID);
            if (references != null) {
                for (LSID reference : references) {
                    lsidString = reference.toString();
                    if (!lightSourceContainers.containsKey(lsidString)) continue;
                    data.lightSource = (LightSource)((IObjectContainer)lightSourceContainers.get((Object)lsidString)).sourceObject;
                }
            }
        }
        return data;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public int getChannelIndex() {
        return this.channelIndex;
    }

    public LogicalChannel getLogicalChannel() {
        return this.logicalChannel;
    }

    public FilterSet getFilterSet() {
        return this.filterSet;
    }

    public Filter getFilterSetEmissionFilter() {
        return this.filterSetEmFilter;
    }

    public Filter getFilterSetExcitationFilter() {
        return this.filterSetExFilter;
    }

    public List<Filter> getLightPathEmissionFilters() {
        return this.lightPathEmFilters;
    }

    public List<Filter> getLightPathExcitationFilters() {
        return this.lightPathExFilters;
    }

    public LightSettings getLightSourceSettings() {
        return this.lightSourceSettings;
    }

    public LightSource getLightSource() {
        return this.lightSource;
    }
}

