/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.model;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import ome.formats.enums.EnumerationProvider;
import ome.formats.model.InstanceProvider;
import ome.formats.model.ModelException;
import ome.formats.model.handler.ModelObjectHandlerFactory;
import omero.model.IObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlitzInstanceProvider
implements InstanceProvider {
    private ModelObjectHandlerFactory modelObjectHandlerFactory;
    private Map<Class<? extends IObject>, Constructor<? extends IObject>> constructorCache = new HashMap<Class<? extends IObject>, Constructor<? extends IObject>>();

    public BlitzInstanceProvider(EnumerationProvider enumProvider) {
        this.modelObjectHandlerFactory = new ModelObjectHandlerFactory(enumProvider);
    }

    @Override
    public <T extends IObject> T getInstance(Class<T> klass) throws ModelException {
        try {
            Constructor<T> constructor = this.getConstructor(klass);
            IObject o = (IObject)constructor.newInstance(new Object[0]);
            return (T)this.modelObjectHandlerFactory.getHandler(klass).handle(o);
        }
        catch (Exception e) {
            String m = "Unable to instantiate object.";
            throw new ModelException(m, klass, e);
        }
    }

    private <T extends IObject> Constructor<T> getConstructor(Class<T> klass) throws ModelException {
        Constructor<IObject> constructor = this.constructorCache.get(klass);
        if (constructor == null) {
            try {
                Class<?> concreteClass = Class.forName(klass.getName() + "I");
                constructor = concreteClass.getDeclaredConstructor(new Class[0]);
                this.constructorCache.put(klass, constructor);
            }
            catch (Exception e) {
                String m = "Unable to retrieve constructor.";
                throw new ModelException(m, klass, e);
            }
        }
        return constructor;
    }
}

