/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.util;

import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import loci.formats.in.FlexReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ini4j.IniFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IniFileLoader {
    private static final Log log = LogFactory.getLog(IniFileLoader.class);
    private static final String LOGDIR = System.getProperty("user.home") + File.separator + "omero" + File.separator + "log";
    public static final String LOGFILE = LOGDIR + File.separator + "importer.log";
    private String userSettingsDirectory;
    private Preferences userPrefs;
    private String staticConfigDirectory = System.getProperty("user.dir") + File.separator + "config";
    private String staticConfigFile = this.staticConfigDirectory + File.separator + "importer.config";
    private Preferences staticPrefs = this.staticPrefsOrNull();

    public IniFileLoader(File userConfigFile) {
        this.userSettingsDirectory = System.getProperty("user.home") + File.separator + "omero";
        if (!new File(this.userSettingsDirectory).exists()) {
            new File(this.userSettingsDirectory).mkdir();
        }
        if (userConfigFile == null) {
            userConfigFile = new File(this.userSettingsDirectory + File.separator + "importer.ini");
        }
        try {
            this.userPrefs = new IniFile(userConfigFile, IniFile.Mode.RW);
        }
        catch (BackingStoreException e) {
            log.error((Object)e);
            throw new RuntimeException("Error accessing ini file", e);
        }
    }

    public void flushPreferences() {
        try {
            this.userPrefs.flush();
        }
        catch (BackingStoreException e) {
            log.error((Object)e);
        }
    }

    public int getDebugLevel() {
        return this.userPrefs.node("General").getInt("debug", -1);
    }

    public boolean getUseQuaqua() {
        return this.userPrefs.node("General").getBoolean("useQuaqua", true);
    }

    public String getLogFile() {
        return this.staticPref("General", "logfile", LOGFILE);
    }

    public String getHomeUrl() {
        return this.staticPref("General", "url", "https://www.openmicroscopy.org/site/support/omero4/products/feature-list");
    }

    public String getForumUrl() {
        return this.staticPref("General", "forumUrl", "https://www.openmicroscopy.org/community/");
    }

    public String getAppTitle() {
        return this.staticPref("General", "appTitle", "OMERO.importer");
    }

    public boolean getStaticDisableUpgradeCheck() {
        boolean toReturn = false;
        if (this.staticPrefs != null) {
            Preferences general = this.staticPrefs.node("General");
            toReturn = general.getBoolean("disableUpgradeCheck", false);
        }
        return toReturn;
    }

    public boolean getForceFileArchiveOn() {
        boolean toReturn = false;
        if (this.staticPrefs != null) {
            Preferences ui = this.staticPrefs.node("UI");
            toReturn = ui.getBoolean("forceFileArchiveOn", false);
        }
        return toReturn;
    }

    public boolean getStaticDisableHistory() {
        boolean toReturn = false;
        if (this.staticPrefs != null) {
            Preferences ui = this.staticPrefs.node("UI");
            toReturn = ui.getBoolean("disableImportHistory", false);
        }
        return toReturn;
    }

    public void setUserDisableHistory(boolean b) {
        this.userPrefs.node("UI").putBoolean("disableHistory", b);
        this.flushPreferences();
    }

    public Boolean getUserDisableHistory() {
        return this.userPrefs.node("UI").getBoolean("disableHistory", true);
    }

    public void setDebugLevel(int level) {
        this.userPrefs.node("General").putInt("debug", level);
        this.flushPreferences();
    }

    public void setUseQuaqua(boolean b) {
        this.userPrefs.node("General").putBoolean("useQuaqua", b);
        this.flushPreferences();
    }

    public String getVersionNote() {
        return this.staticPref("General", "appVersionNote", "");
    }

    public String getVersionNumber() {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("omero");
            return "Beta" + bundle.getString("omero.version");
        }
        catch (MissingResourceException e) {
            return "Dev Build";
        }
    }

    public Boolean isDebugConsole() {
        return this.staticBoolPref("General", "displayDebugConsole", true);
    }

    public String getServerPort() {
        return this.staticPref("General", "port", "4064");
    }

    public void updateFlexReaderServerMaps() {
        Preferences maps = this.userPrefs.node("FlexReaderServerMaps");
        Map<String, List<String>> values = this.parseFlexMaps(maps);
        for (Map.Entry<String, List<String>> entry : values.entrySet()) {
            if (entry.getValue() == null) continue;
            for (String mapValue : entry.getValue()) {
                this.mapFlexServer(entry.getKey(), mapValue);
            }
        }
    }

    public Map<String, List<String>> parseFlexMaps(Preferences maps) {
        HashMap<String, List<String>> rv = new HashMap<String, List<String>>();
        try {
            for (String key : maps.keys()) {
                String mapValues = maps.get(key, null);
                log.info((Object)("Raw Flex reader map values: " + mapValues));
                if (mapValues == null) continue;
                ArrayList<String> list = new ArrayList<String>();
                rv.put(key, list);
                for (String value : mapValues.split(";")) {
                    value = value.trim();
                    list.add(value);
                }
            }
        }
        catch (BackingStoreException e) {
            log.warn((Object)"Error updating Flex reader server maps.", (Throwable)e);
        }
        return rv;
    }

    protected void mapFlexServer(String key, String mapValue) {
        try {
            FlexReader.appendServerMap(key, mapValue);
            log.info((Object)String.format("Added Flex reader server map '%s' = '%s'.", key, mapValue));
        }
        catch (Exception e) {
            log.warn((Object)String.format("Unable to add Flex reader server map '%s' = '%s'", key, mapValue), (Throwable)e);
        }
    }

    public Boolean isDebugUI() {
        return this.staticBoolPref("UI", "displayRedBorders", false);
    }

    public Rectangle getUIBounds() {
        Rectangle rect = new Rectangle();
        rect.width = this.userPrefs.node("UI").getInt("width", 980);
        rect.height = this.userPrefs.node("UI").getInt("height", 580);
        rect.x = this.userPrefs.node("UI").getInt("xOffset", 10);
        rect.y = this.userPrefs.node("UI").getInt("yOffset", 10);
        return rect;
    }

    public void setUIBounds(Rectangle bounds) {
        if (bounds.x < 0) {
            bounds.x = 0;
        }
        if (bounds.y < 0) {
            bounds.y = 0;
        }
        if (bounds.width < 100) {
            bounds.width = 100;
        }
        if (bounds.height < 100) {
            bounds.height = 100;
        }
        this.userPrefs.node("UI").putInt("width", bounds.width);
        this.userPrefs.node("UI").putInt("height", bounds.height);
        this.userPrefs.node("UI").putInt("xOffset", bounds.x);
        this.userPrefs.node("UI").putInt("yOffset", bounds.y);
    }

    public boolean getUserFullPath() {
        return this.userPrefs.node("UI").getBoolean("userFullPath", true);
    }

    public void setUserFullPath(boolean b) {
        this.userPrefs.node("UI").putBoolean("userFullPath", b);
    }

    public boolean getCustomImageNaming() {
        return this.userPrefs.node("UI").getBoolean("customImageNaming", true);
    }

    public void setCustomImageNaming(boolean b) {
        this.userPrefs.node("UI").putBoolean("customImageNaming", b);
    }

    public int getNumOfDirectories() {
        return this.userPrefs.node("UI").getInt("numOfDirectories", 0);
    }

    public void setNumOfDirectories(int i) {
        this.userPrefs.node("UI").putInt("numOfDirectories", i);
    }

    public String getUploaderTokenURL() {
        return this.staticPref("Uploader", "TokenURL", "http://qa.openmicroscopy.org.uk/qa/initial/");
    }

    public String getUploaderURL() {
        return this.staticPref("Uploader", "URL", "http://qa.openmicroscopy.org.uk/qa/upload_processing/");
    }

    public String getBugTrackerURL() {
        return this.staticPref("Uploader", "BugTrackerURL", "http://qa.openmicroscopy.org.uk/qa/upload_processing/");
    }

    public String getUserSettingsDirectory() {
        return this.userSettingsDirectory;
    }

    private Preferences staticPrefsOrNull() {
        File staticFile = new File(this.staticConfigFile);
        if (!staticFile.exists() || !staticFile.canRead()) {
            return null;
        }
        try {
            IniFile prefs = new IniFile(staticFile, IniFile.Mode.RO);
            return prefs;
        }
        catch (BackingStoreException e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    private String staticPref(String node, String key, String def) {
        if (this.staticPrefs == null) {
            return def;
        }
        return this.staticPrefs.node(node).get(key, def);
    }

    private Boolean staticBoolPref(String node, String key, Boolean def) {
        if (this.staticPrefs == null) {
            return def;
        }
        return this.staticPrefs.node(node).getBoolean(key, def);
    }
}

