/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.util;

import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import ome.formats.importer.util.FileUploadCounter;
import ome.formats.importer.util.HtmlMessengerException;
import ome.util.Utils;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.params.HttpClientParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlMessenger {
    static final String PROXY_HOST = "http.proxyHost";
    static final String PROXY_PORT = "http.proxyPort";
    static final int CONN_TIMEOUT = 10000;
    HttpClient client = null;
    PostMethod method = null;

    public HtmlMessenger(String url, List<Part> postList) throws HtmlMessengerException {
        try {
            HostConfiguration cfg = new HostConfiguration();
            cfg.setHost(url);
            String proxyHost = System.getProperty(PROXY_HOST);
            String proxyPort = System.getProperty(PROXY_PORT);
            if (proxyHost != null && proxyPort != null) {
                int port = Integer.parseInt(proxyPort);
                cfg.setProxy(proxyHost, port);
            }
            this.client = new HttpClient();
            this.client.setHostConfiguration(cfg);
            HttpClientParams params = new HttpClientParams();
            params.setConnectionManagerTimeout(10000L);
            params.setSoTimeout(10000);
            this.client.setParams(params);
            this.method = new PostMethod(url);
            Part[] parts = new Part[postList.size()];
            int i = 0;
            Iterator<Part> i$ = postList.iterator();
            while (i$.hasNext()) {
                Part part;
                parts[i] = part = i$.next();
                ++i;
            }
            MultipartRequestEntity mpre = new MultipartRequestEntity(parts, this.method.getParams());
            FileUploadCounter.ProgressListener listener = new FileUploadCounter.ProgressListener(){

                public void update(long bytesRead) {
                }
            };
            FileUploadCounter hfre = new FileUploadCounter((RequestEntity)mpre, listener);
            this.method.setRequestEntity((RequestEntity)hfre);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HtmlMessengerException("Error creating post parameters", e);
        }
    }

    public String executePost() throws HtmlMessengerException {
        String serverReply = "";
        InputStreamReader reader = null;
        try {
            int statusCode = this.client.executeMethod((HttpMethod)this.method);
            if (statusCode != -1) {
                int n;
                reader = new InputStreamReader(this.method.getResponseBodyAsStream(), this.method.getRequestCharSet());
                char[] buf = new char[32678];
                StringBuilder str = new StringBuilder();
                while ((n = reader.read(buf)) != -1) {
                    str.append(buf, 0, n);
                }
                this.method.releaseConnection();
                serverReply = str.toString();
            }
            String string = serverReply;
            return string;
        }
        catch (Exception e) {
            throw new HtmlMessengerException("Cannot Connect", e);
        }
        finally {
            Utils.closeQuietly(reader);
        }
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public String login(String url, String username, String password) throws HtmlMessengerException {
        String serverReply = "";
        InputStreamReader reader = null;
        try {
            PostMethod loginMethod = new PostMethod(url);
            Part[] parts = new Part[]{new StringPart("username", username), new StringPart("password", password)};
            MultipartRequestEntity mpre = new MultipartRequestEntity(parts, loginMethod.getParams());
            FileUploadCounter.ProgressListener listener = new FileUploadCounter.ProgressListener(){

                public void update(long bytesRead) {
                }
            };
            FileUploadCounter hfre = new FileUploadCounter((RequestEntity)mpre, listener);
            loginMethod.setRequestEntity((RequestEntity)hfre);
            int statusCode = this.client.executeMethod((HttpMethod)loginMethod);
            if (statusCode != -1) {
                int n;
                reader = new InputStreamReader(loginMethod.getResponseBodyAsStream(), loginMethod.getRequestCharSet());
                char[] buf = new char[32678];
                StringBuilder str = new StringBuilder();
                while ((n = reader.read(buf)) != -1) {
                    str.append(buf, 0, n);
                }
                loginMethod.releaseConnection();
                serverReply = str.toString();
            }
            String string = serverReply;
            return string;
        }
        catch (Exception e) {
            throw new HtmlMessengerException("Cannot Connect", e);
        }
        finally {
            Utils.closeQuietly(reader);
        }
    }
}

