/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.httpclient.methods.RequestEntity;

public class FileUploadCounter
implements RequestEntity {
    private final RequestEntity entity;
    private final ProgressListener listener;

    public FileUploadCounter(RequestEntity entity, ProgressListener listener) {
        this.entity = entity;
        this.listener = listener;
    }

    public void writeRequest(OutputStream out) throws IOException {
        this.entity.writeRequest((OutputStream)new OutputStreamCounter(out, this.listener));
    }

    public long getContentLength() {
        return this.entity.getContentLength();
    }

    public String getContentType() {
        return this.entity.getContentType();
    }

    public boolean isRepeatable() {
        return this.entity.isRepeatable();
    }

    public static interface ProgressListener {
        public void update(long var1);
    }

    public static class OutputStreamCounter
    extends FilterOutputStream {
        private final ProgressListener listener;
        private long bytes_transferred;

        public OutputStreamCounter(OutputStream out, ProgressListener listener) {
            super(out);
            this.listener = listener;
            this.bytes_transferred = 0L;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            super.write(b, off, len);
            this.bytes_transferred += (long)len;
            this.listener.update(this.bytes_transferred);
        }

        public void write(int b) throws IOException {
            super.write(b);
            ++this.bytes_transferred;
            this.listener.update(this.bytes_transferred);
        }
    }
}

