/*
 * Decompiled with CFR 0.152.
 */
package IceSSL;

import Ice.Communicator;
import Ice.Logger;
import Ice.PluginInitializationException;
import Ice.Properties;
import Ice.SecurityException;
import Ice.Util;
import IceInternal.EndpointHostResolver;
import IceInternal.Network;
import IceInternal.ProtocolPluginFacade;
import IceSSL.CertificateVerifier;
import IceSSL.ConnectionInfo;
import IceSSL.EndpointFactoryI;
import IceSSL.PasswordCallback;
import IceSSL.TrustManager;
import IceSSL.X509KeyManagerI;
import IceSSL.X509TrustManagerI;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

class Instance {
    private Logger _logger;
    private ProtocolPluginFacade _facade;
    private int _securityTraceLevel;
    private String _securityTraceCategory;
    private boolean _initialized;
    private SSLContext _context;
    private String _defaultDir;
    private CipherExpression[] _ciphers;
    private boolean _allCiphers;
    private boolean _noCiphers;
    private String[] _protocols;
    private boolean _checkCertName;
    private int _verifyDepthMax;
    private CertificateVerifier _verifier;
    private PasswordCallback _passwordCallback;
    private TrustManager _trustManager;
    private InputStream _keystoreStream;
    private InputStream _truststoreStream;
    private List<InputStream> _seeds = new ArrayList<InputStream>();

    Instance(Communicator communicator) {
        this._logger = communicator.getLogger();
        this._facade = Util.getProtocolPluginFacade(communicator);
        this._securityTraceLevel = communicator.getProperties().getPropertyAsIntWithDefault("IceSSL.Trace.Security", 0);
        this._securityTraceCategory = "Security";
        this._trustManager = new TrustManager(communicator);
        this._facade.addEndpointFactory(new EndpointFactoryI(this));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void initialize() {
        String passwordCallbackClass;
        String[] protocols;
        if (this._initialized) {
            return;
        }
        String prefix = "IceSSL.";
        Properties properties = this.communicator().getProperties();
        String ciphers = properties.getProperty("IceSSL.Ciphers");
        if (ciphers.length() > 0) {
            this.parseCiphers(ciphers);
        }
        if ((protocols = properties.getPropertyAsList("IceSSL.Protocols")).length != 0) {
            ArrayList<String> l = new ArrayList<String>();
            for (int i = 0; i < protocols.length; ++i) {
                String s = protocols[i].toLowerCase();
                if (s.equals("ssl3") || s.equals("sslv3")) {
                    l.add("SSLv3");
                    continue;
                }
                if (!(s.equals("tls") || s.equals("tls1") || s.equals("tlsv1"))) {
                    PluginInitializationException e = new PluginInitializationException();
                    e.reason = "IceSSL: unrecognized protocol `" + protocols[i] + "'";
                    throw e;
                }
                l.add("TLSv1");
            }
            this._protocols = new String[l.size()];
            l.toArray(this._protocols);
        }
        this._checkCertName = properties.getPropertyAsIntWithDefault("IceSSL.CheckCertName", 0) > 0;
        this._verifyDepthMax = properties.getPropertyAsIntWithDefault("IceSSL.VerifyDepthMax", 2);
        String certVerifierClass = properties.getProperty("IceSSL.CertVerifier");
        if (certVerifierClass.length() > 0) {
            if (this._verifier != null) {
                PluginInitializationException e = new PluginInitializationException();
                e.reason = "IceSSL: certificate verifier already installed";
                throw e;
            }
            Class<?> cls = null;
            try {
                cls = Class.forName(certVerifierClass);
            }
            catch (Throwable ex) {
                PluginInitializationException e = new PluginInitializationException();
                e.reason = "IceSSL: unable to load certificate verifier class " + certVerifierClass;
                e.initCause(ex);
                throw e;
            }
            try {
                this._verifier = (CertificateVerifier)cls.newInstance();
            }
            catch (Throwable ex) {
                PluginInitializationException e = new PluginInitializationException();
                e.reason = "IceSSL: unable to instantiate certificate verifier class " + certVerifierClass;
                e.initCause(ex);
                throw e;
            }
        }
        if ((passwordCallbackClass = properties.getProperty("IceSSL.PasswordCallback")).length() > 0) {
            if (this._passwordCallback != null) {
                PluginInitializationException e = new PluginInitializationException();
                e.reason = "IceSSL: password callback already installed";
                throw e;
            }
            Class<?> cls = null;
            try {
                cls = Class.forName(passwordCallbackClass);
            }
            catch (Throwable ex) {
                PluginInitializationException e = new PluginInitializationException();
                e.reason = "IceSSL: unable to load password callback class " + passwordCallbackClass;
                e.initCause(ex);
                throw e;
            }
            try {
                this._passwordCallback = (PasswordCallback)cls.newInstance();
            }
            catch (Throwable ex) {
                PluginInitializationException e = new PluginInitializationException();
                e.reason = "IceSSL: unable to instantiate password callback class " + passwordCallbackClass;
                e.initCause(ex);
                throw e;
            }
        }
        if (this._context == null) {
            try {
                PluginInitializationException e;
                char[] passwordChars;
                this._defaultDir = properties.getProperty("IceSSL.DefaultDir");
                SecureRandom rand = new SecureRandom();
                String seedFiles = properties.getProperty("IceSSL.Random");
                if (seedFiles.length() > 0) {
                    String[] arr = seedFiles.split(File.pathSeparator);
                    for (int i = 0; i < arr.length; ++i) {
                        try {
                            InputStream seedStream = this.openResource(arr[i]);
                            if (seedStream == null) {
                                PluginInitializationException e2 = new PluginInitializationException();
                                e2.reason = "IceSSL: random seed file not found:\n" + arr[i];
                                throw e2;
                            }
                            this._seeds.add(seedStream);
                            continue;
                        }
                        catch (IOException ex) {
                            PluginInitializationException e3 = new PluginInitializationException();
                            e3.reason = "IceSSL: unable to access random seed file:\n" + arr[i];
                            e3.initCause(ex);
                            throw e3;
                        }
                    }
                }
                if (!this._seeds.isEmpty()) {
                    byte[] seed = null;
                    int start = 0;
                    for (InputStream in : this._seeds) {
                        try {
                            int num = in.available();
                            if (seed == null) {
                                seed = new byte[num];
                            } else {
                                byte[] tmp = new byte[seed.length + num];
                                System.arraycopy(seed, 0, tmp, 0, seed.length);
                                start = seed.length;
                                seed = tmp;
                            }
                            in.read(seed, start, num);
                        }
                        catch (IOException ex) {
                            PluginInitializationException e4 = new PluginInitializationException();
                            e4.reason = "IceSSL: error while reading random seed";
                            e4.initCause(ex);
                            throw e4;
                        }
                    }
                    rand.setSeed(seed);
                }
                this._seeds.clear();
                rand.nextInt();
                String keystorePath = properties.getProperty("IceSSL.Keystore");
                String password = properties.getProperty("IceSSL.Password");
                String keystorePassword = properties.getProperty("IceSSL.KeystorePassword");
                String defaultType = KeyStore.getDefaultType();
                String keystoreType = properties.getPropertyWithDefault("IceSSL.KeystoreType", defaultType);
                String alias = properties.getProperty("IceSSL.Alias");
                String truststorePath = properties.getProperty("IceSSL.Truststore");
                String truststorePassword = properties.getProperty("IceSSL.TruststorePassword");
                String truststoreType = properties.getPropertyWithDefault("IceSSL.TruststoreType", KeyStore.getDefaultType());
                KeyManager[] keyManagers = null;
                KeyStore keys = null;
                if (this._keystoreStream != null || keystorePath.length() > 0) {
                    block79: {
                        InputStream keystoreStream = null;
                        try {
                            try {
                                if (this._keystoreStream != null) {
                                    keystoreStream = this._keystoreStream;
                                } else {
                                    keystoreStream = this.openResource(keystorePath);
                                    if (keystoreStream == null) {
                                        PluginInitializationException e5 = new PluginInitializationException();
                                        e5.reason = "IceSSL: keystore not found:\n" + keystorePath;
                                        throw e5;
                                    }
                                }
                                keys = KeyStore.getInstance(keystoreType);
                                char[] passwordChars2 = null;
                                if (keystorePassword.length() > 0) {
                                    passwordChars2 = keystorePassword.toCharArray();
                                } else if (this._passwordCallback != null) {
                                    passwordChars2 = this._passwordCallback.getKeystorePassword();
                                } else if (keystoreType.equals("BKS")) {
                                    passwordChars2 = new char[]{};
                                }
                                keys.load(keystoreStream, passwordChars2);
                                if (passwordChars2 != null) {
                                    Arrays.fill(passwordChars2, '\u0000');
                                }
                                keystorePassword = null;
                            }
                            catch (IOException ex) {
                                PluginInitializationException e6 = new PluginInitializationException();
                                e6.reason = "IceSSL: unable to load keystore:\n" + keystorePath;
                                e6.initCause(ex);
                                throw e6;
                            }
                            Object var24_45 = null;
                            if (keystoreStream == null) break block79;
                        }
                        catch (Throwable throwable) {
                            Object var24_46 = null;
                            if (keystoreStream == null) throw throwable;
                            try {
                                keystoreStream.close();
                                throw throwable;
                            }
                            catch (IOException e7) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {}
                        catch (IOException e7) {}
                        keystoreStream.close();
                    }
                    String algorithm = KeyManagerFactory.getDefaultAlgorithm();
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
                    passwordChars = new char[]{};
                    if (password.length() > 0) {
                        passwordChars = password.toCharArray();
                    } else if (this._passwordCallback != null) {
                        passwordChars = this._passwordCallback.getPassword(alias);
                    }
                    kmf.init(keys, passwordChars);
                    if (passwordChars.length > 0) {
                        Arrays.fill(passwordChars, '\u0000');
                    }
                    password = null;
                    keyManagers = kmf.getKeyManagers();
                    if (alias.length() > 0) {
                        if (!keys.isKeyEntry(alias)) {
                            e = new PluginInitializationException();
                            e.reason = "IceSSL: keystore does not contain an entry with alias `" + alias + "'";
                            throw e;
                        }
                        for (int i = 0; i < keyManagers.length; ++i) {
                            keyManagers[i] = new X509KeyManagerI((X509KeyManager)keyManagers[i], alias);
                        }
                    }
                }
                javax.net.ssl.TrustManager[] trustManagers = null;
                if (this._truststoreStream != null || truststorePath.length() > 0) {
                    KeyStore ts;
                    block80: {
                        if (this._truststoreStream != null && this._truststoreStream == this._keystoreStream || truststorePath.length() > 0 && truststorePath.equals(keystorePath)) {
                            assert (keys != null);
                            ts = keys;
                        } else {
                            InputStream truststoreStream = null;
                            try {
                                try {
                                    if (this._truststoreStream != null) {
                                        truststoreStream = this._truststoreStream;
                                    } else {
                                        truststoreStream = this.openResource(truststorePath);
                                        if (truststoreStream == null) {
                                            PluginInitializationException e8 = new PluginInitializationException();
                                            e8.reason = "IceSSL: truststore not found:\n" + truststorePath;
                                            throw e8;
                                        }
                                    }
                                    ts = KeyStore.getInstance(truststoreType);
                                    passwordChars = null;
                                    if (truststorePassword.length() > 0) {
                                        passwordChars = truststorePassword.toCharArray();
                                    } else if (this._passwordCallback != null) {
                                        passwordChars = this._passwordCallback.getTruststorePassword();
                                    } else if (truststoreType.equals("BKS")) {
                                        passwordChars = new char[]{};
                                    }
                                    ts.load(truststoreStream, passwordChars);
                                    if (passwordChars != null) {
                                        Arrays.fill(passwordChars, '\u0000');
                                    }
                                    truststorePassword = null;
                                }
                                catch (IOException ex) {
                                    e = new PluginInitializationException();
                                    e.reason = "IceSSL: unable to load truststore:\n" + truststorePath;
                                    e.initCause(ex);
                                    throw e;
                                }
                                Object var27_55 = null;
                                if (truststoreStream == null) break block80;
                            }
                            catch (Throwable throwable) {
                                Object var27_56 = null;
                                if (truststoreStream == null) throw throwable;
                                try {
                                    truststoreStream.close();
                                    throw throwable;
                                }
                                catch (IOException e9) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                            try {}
                            catch (IOException e9) {}
                            truststoreStream.close();
                        }
                    }
                    String algorithm = TrustManagerFactory.getDefaultAlgorithm();
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                    tmf.init(ts);
                    trustManagers = tmf.getTrustManagers();
                }
                if (trustManagers == null) {
                    trustManagers = new javax.net.ssl.TrustManager[]{new X509TrustManagerI(null)};
                } else {
                    for (int i = 0; i < trustManagers.length; ++i) {
                        trustManagers[i] = new X509TrustManagerI((X509TrustManager)trustManagers[i]);
                    }
                }
                this._context = SSLContext.getInstance("TLS");
                this._context.init(keyManagers, trustManagers, rand);
            }
            catch (GeneralSecurityException ex) {
                PluginInitializationException e = new PluginInitializationException();
                e.reason = "IceSSL: unable to initialize context";
                e.initCause(ex);
                throw e;
            }
        }
        this._seeds.clear();
        this._keystoreStream = null;
        this._truststoreStream = null;
        this._initialized = true;
    }

    void context(SSLContext context) {
        if (this._initialized) {
            PluginInitializationException ex = new PluginInitializationException();
            ex.reason = "IceSSL: plug-in is already initialized";
            throw ex;
        }
        this._context = context;
    }

    SSLContext context() {
        return this._context;
    }

    void setCertificateVerifier(CertificateVerifier verifier) {
        this._verifier = verifier;
    }

    CertificateVerifier getCertificateVerifier() {
        return this._verifier;
    }

    void setPasswordCallback(PasswordCallback callback) {
        this._passwordCallback = callback;
    }

    PasswordCallback getPasswordCallback() {
        return this._passwordCallback;
    }

    void setKeystoreStream(InputStream stream) {
        if (this._initialized) {
            PluginInitializationException ex = new PluginInitializationException();
            ex.reason = "IceSSL: plugin is already initialized";
            throw ex;
        }
        this._keystoreStream = stream;
    }

    void setTruststoreStream(InputStream stream) {
        if (this._initialized) {
            PluginInitializationException ex = new PluginInitializationException();
            ex.reason = "IceSSL: plugin is already initialized";
            throw ex;
        }
        this._truststoreStream = stream;
    }

    void addSeedStream(InputStream stream) {
        this._seeds.add(stream);
    }

    Communicator communicator() {
        return this._facade.getCommunicator();
    }

    EndpointHostResolver endpointHostResolver() {
        return this._facade.getEndpointHostResolver();
    }

    int protocolSupport() {
        return this._facade.getProtocolSupport();
    }

    String defaultHost() {
        return this._facade.getDefaultHost();
    }

    int networkTraceLevel() {
        return this._facade.getNetworkTraceLevel();
    }

    String networkTraceCategory() {
        return this._facade.getNetworkTraceCategory();
    }

    int securityTraceLevel() {
        return this._securityTraceLevel;
    }

    String securityTraceCategory() {
        return this._securityTraceCategory;
    }

    boolean initialized() {
        return this._initialized;
    }

    SSLEngine createSSLEngine(boolean incoming) {
        SSLEngine engine = this._context.createSSLEngine();
        engine.setUseClientMode(!incoming);
        String[] cipherSuites = this.filterCiphers(engine.getSupportedCipherSuites(), engine.getEnabledCipherSuites());
        try {
            engine.setEnabledCipherSuites(cipherSuites);
        }
        catch (IllegalArgumentException ex) {
            SecurityException e = new SecurityException();
            e.reason = "IceSSL: invalid ciphersuite";
            e.initCause(ex);
            throw e;
        }
        if (this._securityTraceLevel >= 1) {
            StringBuilder s = new StringBuilder(128);
            s.append("enabling SSL ciphersuites:");
            for (int i = 0; i < cipherSuites.length; ++i) {
                s.append("\n  ");
                s.append(cipherSuites[i]);
            }
            this._logger.trace(this._securityTraceCategory, s.toString());
        }
        if (this._protocols != null) {
            try {
                engine.setEnabledProtocols(this._protocols);
            }
            catch (IllegalArgumentException ex) {
                SecurityException e = new SecurityException();
                e.reason = "IceSSL: invalid protocol";
                e.initCause(ex);
                throw e;
            }
        }
        if (incoming) {
            int verifyPeer = this.communicator().getProperties().getPropertyAsIntWithDefault("IceSSL.VerifyPeer", 2);
            if (verifyPeer == 0) {
                engine.setWantClientAuth(false);
                engine.setNeedClientAuth(false);
            } else if (verifyPeer == 1) {
                engine.setWantClientAuth(true);
            } else {
                engine.setNeedClientAuth(true);
            }
        }
        try {
            engine.beginHandshake();
        }
        catch (SSLException ex) {
            SecurityException e = new SecurityException();
            e.reason = "IceSSL: handshake error";
            e.initCause(ex);
            throw e;
        }
        return engine;
    }

    String[] filterCiphers(String[] supportedCiphers, String[] defaultCiphers) {
        int i;
        LinkedList<String> result = new LinkedList<String>();
        if (this._allCiphers) {
            for (i = 0; i < supportedCiphers.length; ++i) {
                result.add(supportedCiphers[i]);
            }
        } else if (!this._noCiphers) {
            for (i = 0; i < defaultCiphers.length; ++i) {
                result.add(defaultCiphers[i]);
            }
        }
        if (this._ciphers != null) {
            for (i = 0; i < this._ciphers.length; ++i) {
                CipherExpression ce = this._ciphers[i];
                if (ce.not) {
                    Iterator e = result.iterator();
                    while (e.hasNext()) {
                        String cipher = (String)e.next();
                        if (ce.cipher != null) {
                            if (!ce.cipher.equals(cipher)) continue;
                            e.remove();
                            continue;
                        }
                        assert (ce.re != null);
                        Matcher m = ce.re.matcher(cipher);
                        if (!m.find()) continue;
                        e.remove();
                    }
                    continue;
                }
                if (ce.cipher != null) {
                    result.add(0, ce.cipher);
                    continue;
                }
                assert (ce.re != null);
                for (int j = 0; j < supportedCiphers.length; ++j) {
                    Matcher m = ce.re.matcher(supportedCiphers[j]);
                    if (!m.find()) continue;
                    result.add(0, supportedCiphers[j]);
                }
            }
        }
        String[] arr = new String[result.size()];
        result.toArray(arr);
        return arr;
    }

    String[] protocols() {
        return this._protocols;
    }

    void traceConnection(SocketChannel fd, SSLEngine engine, boolean incoming) {
        SSLSession session = engine.getSession();
        String msg = "SSL summary for " + (incoming ? "incoming" : "outgoing") + " connection\n" + "cipher = " + session.getCipherSuite() + "\n" + "protocol = " + session.getProtocol() + "\n" + Network.fdToString(fd);
        this._logger.trace(this._securityTraceCategory, msg);
    }

    void verifyPeer(ConnectionInfo info, SelectableChannel fd, String address, boolean incoming) {
        SecurityException ex;
        String msg;
        block25: {
            if (this._verifyDepthMax > 0 && info.certs != null && info.certs.length > this._verifyDepthMax) {
                String msg2 = (incoming ? "incoming" : "outgoing") + " connection rejected:\n" + "length of peer's certificate chain (" + info.certs.length + ") exceeds maximum of " + this._verifyDepthMax + "\n" + Network.fdToString(fd);
                if (this._securityTraceLevel >= 1) {
                    this._logger.trace(this._securityTraceCategory, msg2);
                }
                SecurityException ex2 = new SecurityException();
                ex2.reason = msg2;
                throw ex2;
            }
            if (info.certs != null) {
                try {
                    Collection<List<?>> subjectAltNames = ((X509Certificate)info.certs[0]).getSubjectAlternativeNames();
                    ArrayList<String> ipAddresses = new ArrayList<String>();
                    ArrayList<String> dnsNames = new ArrayList<String>();
                    if (subjectAltNames != null) {
                        for (List<?> l : subjectAltNames) {
                            assert (!l.isEmpty());
                            Integer n = (Integer)l.get(0);
                            if (n == 7) {
                                ipAddresses.add((String)l.get(1));
                                continue;
                            }
                            if (n != 2) continue;
                            dnsNames.add(((String)l.get(1)).toLowerCase());
                        }
                    }
                    if (address.length() > 0) {
                        boolean certNameOK = ipAddresses.contains(address);
                        if (!certNameOK) {
                            certNameOK = dnsNames.contains(address.toLowerCase());
                        }
                        if (!certNameOK && (this._checkCertName || this._securityTraceLevel >= 1 && this._verifier == null)) {
                            StringBuilder sb = new StringBuilder(128);
                            sb.append("IceSSL: ");
                            if (!this._checkCertName) {
                                sb.append("ignoring ");
                            }
                            sb.append("certificate validation failure:\npeer certificate does not contain `");
                            sb.append(address);
                            sb.append("' in its subjectAltName extension");
                            if (!dnsNames.isEmpty()) {
                                sb.append("\nDNS names found in certificate: ");
                                for (int j = 0; j < dnsNames.size(); ++j) {
                                    if (j > 0) {
                                        sb.append(", ");
                                    }
                                    sb.append(((String)dnsNames.get(j)).toString());
                                }
                            }
                            if (!ipAddresses.isEmpty()) {
                                sb.append("\nIP addresses found in certificate: ");
                                for (int j = 0; j < ipAddresses.size(); ++j) {
                                    if (j > 0) {
                                        sb.append(", ");
                                    }
                                    sb.append(((String)ipAddresses.get(j)).toString());
                                }
                            }
                            if (this._securityTraceLevel >= 1) {
                                this._logger.trace(this._securityTraceCategory, sb.toString());
                            }
                            if (this._checkCertName) {
                                SecurityException ex3 = new SecurityException();
                                ex3.reason = sb.toString();
                                throw ex3;
                            }
                        }
                    }
                }
                catch (CertificateParsingException ex4) {
                    if ($assertionsDisabled) break block25;
                    throw new AssertionError();
                }
            }
        }
        if (!this._trustManager.verify(info)) {
            msg = (incoming ? "incoming" : "outgoing") + " connection rejected by trust manager\n" + Network.fdToString(fd);
            if (this._securityTraceLevel >= 1) {
                this._logger.trace(this._securityTraceCategory, msg);
            }
            ex = new SecurityException();
            ex.reason = msg;
            throw ex;
        }
        if (this._verifier != null && !this._verifier.verify(info)) {
            msg = (incoming ? "incoming" : "outgoing") + " connection rejected by certificate verifier\n" + Network.fdToString(fd);
            if (this._securityTraceLevel > 0) {
                this._logger.trace(this._securityTraceCategory, msg);
            }
            ex = new SecurityException();
            ex.reason = msg;
            throw ex;
        }
    }

    private void parseCiphers(String ciphers) {
        ArrayList<CipherExpression> cipherList = new ArrayList<CipherExpression>();
        String[] expr = ciphers.split("[ \t]+");
        for (int i = 0; i < expr.length; ++i) {
            PluginInitializationException ex;
            if (expr[i].equals("ALL")) {
                if (i != 0) {
                    ex = new PluginInitializationException();
                    ex.reason = "IceSSL: `ALL' must be first in cipher list `" + ciphers + "'";
                    throw ex;
                }
                this._allCiphers = true;
                continue;
            }
            if (expr[i].equals("NONE")) {
                if (i != 0) {
                    ex = new PluginInitializationException();
                    ex.reason = "IceSSL: `NONE' must be first in cipher list `" + ciphers + "'";
                    throw ex;
                }
                this._noCiphers = true;
                continue;
            }
            CipherExpression ce = new CipherExpression();
            String exp = expr[i];
            if (exp.charAt(0) == '!') {
                ce.not = true;
                if (exp.length() > 1) {
                    exp = exp.substring(1);
                } else {
                    PluginInitializationException ex2 = new PluginInitializationException();
                    ex2.reason = "IceSSL: invalid cipher expression `" + exp + "'";
                    throw ex2;
                }
            }
            if (exp.charAt(0) == '(') {
                if (!exp.endsWith(")")) {
                    PluginInitializationException ex3 = new PluginInitializationException();
                    ex3.reason = "IceSSL: invalid cipher expression `" + exp + "'";
                    throw ex3;
                }
                try {
                    ce.re = Pattern.compile(exp.substring(1, exp.length() - 2));
                }
                catch (PatternSyntaxException ex4) {
                    PluginInitializationException e = new PluginInitializationException();
                    e.reason = "IceSSL: invalid cipher expression `" + exp + "'";
                    e.initCause(ex4);
                    throw e;
                }
            } else {
                ce.cipher = exp;
            }
            cipherList.add(ce);
        }
        this._ciphers = new CipherExpression[cipherList.size()];
        cipherList.toArray(this._ciphers);
    }

    private InputStream openResource(String path) throws IOException {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(path);
        if (stream != null) {
            stream = new BufferedInputStream(stream);
        } else {
            try {
                File f = new File(path);
                if (f.exists()) {
                    stream = new BufferedInputStream(new FileInputStream(f));
                } else if (this._defaultDir.length() > 0 && (f = new File(this._defaultDir + File.separator + path)).exists()) {
                    stream = new BufferedInputStream(new FileInputStream(f));
                }
            }
            catch (java.lang.SecurityException securityException) {
                // empty catch block
            }
        }
        return stream;
    }

    private static class CipherExpression {
        boolean not;
        String cipher;
        Pattern re;

        private CipherExpression() {
        }
    }
}

