/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import IceInternal.Connector;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.Transceiver;
import IceInternal.UdpTransceiver;
import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;

final class UdpConnector
implements Connector {
    private Instance _instance;
    private InetSocketAddress _addr;
    private String _mcastInterface;
    private int _mcastTtl;
    private byte _protocolMajor;
    private byte _protocolMinor;
    private byte _encodingMajor;
    private byte _encodingMinor;
    private String _connectionId;
    private int _hashCode;

    public Transceiver connect() {
        return new UdpTransceiver(this._instance, this._addr, this._mcastInterface, this._mcastTtl);
    }

    public SelectableChannel fd() {
        assert (false);
        return null;
    }

    public short type() {
        return 3;
    }

    public String toString() {
        return Network.addrToString(this._addr);
    }

    public int hashCode() {
        return this._hashCode;
    }

    UdpConnector(Instance instance, InetSocketAddress addr, String mcastInterface, int mcastTtl, byte protocolMajor, byte protocolMinor, byte encodingMajor, byte encodingMinor, String connectionId) {
        this._instance = instance;
        this._addr = addr;
        this._mcastInterface = mcastInterface;
        this._mcastTtl = mcastTtl;
        this._protocolMajor = protocolMajor;
        this._protocolMinor = protocolMinor;
        this._encodingMajor = encodingMajor;
        this._encodingMinor = encodingMinor;
        this._connectionId = connectionId;
        this._hashCode = this._addr.getAddress().getHostAddress().hashCode();
        this._hashCode = 5 * this._hashCode + this._addr.getPort();
        this._hashCode = 5 * this._hashCode + this._mcastInterface.hashCode();
        this._hashCode = 5 * this._hashCode + this._mcastTtl;
        this._hashCode = 5 * this._hashCode + this._connectionId.hashCode();
    }

    public boolean equals(Object obj) {
        UdpConnector p = null;
        try {
            p = (UdpConnector)obj;
        }
        catch (ClassCastException ex) {
            return false;
        }
        if (this == p) {
            return false;
        }
        if (!this._connectionId.equals(p._connectionId)) {
            return false;
        }
        if (this._protocolMajor != p._protocolMajor) {
            return false;
        }
        if (this._protocolMinor != p._protocolMinor) {
            return false;
        }
        if (this._encodingMajor != p._encodingMajor) {
            return false;
        }
        if (this._encodingMinor != p._encodingMinor) {
            return false;
        }
        if (this._mcastTtl != p._mcastTtl) {
            return false;
        }
        if (this._mcastInterface.compareTo(p._mcastInterface) != 0) {
            return false;
        }
        return Network.compareAddress(this._addr, p._addr) == 0;
    }
}

