/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Logger;
import IceInternal.Acceptor;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.TcpTransceiver;
import IceInternal.TraceLevels;
import IceInternal.Transceiver;
import IceUtilInternal.Assert;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

class TcpAcceptor
implements Acceptor {
    private Instance _instance;
    private TraceLevels _traceLevels;
    private Logger _logger;
    private ServerSocketChannel _fd;
    private int _backlog;
    private InetSocketAddress _addr;

    public ServerSocketChannel fd() {
        return this._fd;
    }

    public void close() {
        if (this._traceLevels.network >= 1) {
            String s = "stopping to accept tcp connections at " + this.toString();
            this._logger.trace(this._traceLevels.networkCat, s);
        }
        assert (this._fd != null);
        Network.closeSocketNoThrow(this._fd);
        this._fd = null;
    }

    public void listen() {
        if (this._traceLevels.network >= 1) {
            String s = "accepting tcp connections at " + this.toString();
            this._logger.trace(this._traceLevels.networkCat, s);
        }
    }

    public Transceiver accept() {
        SocketChannel fd = Network.doAccept(this._fd);
        Network.setBlock(fd, false);
        Network.setTcpBufSize(fd, this._instance.initializationData().properties, this._logger);
        if (this._traceLevels.network >= 1) {
            String s = "accepted tcp connection\n" + Network.fdToString(fd);
            this._logger.trace(this._traceLevels.networkCat, s);
        }
        return new TcpTransceiver(this._instance, fd, true);
    }

    public String toString() {
        return Network.addrToString(this._addr);
    }

    int effectivePort() {
        return this._addr.getPort();
    }

    TcpAcceptor(Instance instance, String host, int port) {
        this._instance = instance;
        this._traceLevels = instance.traceLevels();
        this._logger = instance.initializationData().logger;
        this._backlog = instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.TCP.Backlog", 511);
        try {
            this._fd = Network.createTcpServerSocket();
            Network.setBlock(this._fd, false);
            Network.setTcpBufSize(this._fd, this._instance.initializationData().properties, this._logger);
            if (!System.getProperty("os.name").startsWith("Windows")) {
                Network.setReuseAddress(this._fd, true);
            }
            this._addr = Network.getAddressForServer(host, port, this._instance.protocolSupport());
            if (this._traceLevels.network >= 2) {
                String s = "attempting to bind to tcp socket " + this.toString();
                this._logger.trace(this._traceLevels.networkCat, s);
            }
            this._addr = Network.doBind(this._fd, this._addr, this._backlog);
        }
        catch (RuntimeException ex) {
            this._fd = null;
            throw ex;
        }
    }

    protected synchronized void finalize() throws Throwable {
        Assert.FinalizerAssert(this._fd == null);
        super.finalize();
    }
}

