/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AlreadyRegisteredException;
import Ice.Identity;
import Ice.NotRegisteredException;
import Ice.Object;
import Ice.ServantLocator;
import IceInternal.Instance;
import IceUtilInternal.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServantManager {
    private Instance _instance;
    private final String _adapterName;
    private Map<Identity, Map<String, Object>> _servantMapMap = new HashMap<Identity, Map<String, Object>>();
    private Map<String, ServantLocator> _locatorMap = new HashMap<String, ServantLocator>();

    public synchronized void addServant(Object servant, Identity ident, String facet) {
        Map<String, Object> m;
        assert (this._instance != null);
        if (facet == null) {
            facet = "";
        }
        if ((m = this._servantMapMap.get(ident)) == null) {
            m = new HashMap<String, Object>();
            this._servantMapMap.put(ident, m);
        } else if (m.containsKey(facet)) {
            AlreadyRegisteredException ex = new AlreadyRegisteredException();
            ex.id = this._instance.identityToString(ident);
            ex.kindOfObject = "servant";
            if (facet.length() > 0) {
                ex.id = ex.id + " -f " + StringUtil.escapeString(facet, "");
            }
            throw ex;
        }
        m.put(facet, servant);
    }

    public synchronized Object removeServant(Identity ident, String facet) {
        assert (this._instance != null);
        if (facet == null) {
            facet = "";
        }
        Map<String, Object> m = this._servantMapMap.get(ident);
        Object obj = null;
        if (m == null || (obj = m.remove(facet)) == null) {
            NotRegisteredException ex = new NotRegisteredException();
            ex.id = this._instance.identityToString(ident);
            ex.kindOfObject = "servant";
            if (facet.length() > 0) {
                ex.id = ex.id + " -f " + StringUtil.escapeString(facet, "");
            }
            throw ex;
        }
        if (m.isEmpty()) {
            this._servantMapMap.remove(ident);
        }
        return obj;
    }

    public synchronized Map<String, Object> removeAllFacets(Identity ident) {
        assert (this._instance != null);
        Map<String, Object> m = this._servantMapMap.get(ident);
        if (m == null) {
            NotRegisteredException ex = new NotRegisteredException();
            ex.id = this._instance.identityToString(ident);
            ex.kindOfObject = "servant";
            throw ex;
        }
        this._servantMapMap.remove(ident);
        return m;
    }

    public synchronized Object findServant(Identity ident, String facet) {
        if (facet == null) {
            facet = "";
        }
        Map<String, Object> m = this._servantMapMap.get(ident);
        Object obj = null;
        if (m != null) {
            obj = m.get(facet);
        }
        return obj;
    }

    public synchronized Map<String, Object> findAllFacets(Identity ident) {
        assert (this._instance != null);
        Map<String, Object> m = this._servantMapMap.get(ident);
        if (m != null) {
            return new HashMap<String, Object>(m);
        }
        return new HashMap<String, Object>();
    }

    public synchronized boolean hasServant(Identity ident) {
        Map<String, Object> m = this._servantMapMap.get(ident);
        if (m == null) {
            return false;
        }
        assert (!m.isEmpty());
        return true;
    }

    public synchronized void addServantLocator(ServantLocator locator, String category) {
        assert (this._instance != null);
        ServantLocator l = this._locatorMap.get(category);
        if (l != null) {
            AlreadyRegisteredException ex = new AlreadyRegisteredException();
            ex.id = StringUtil.escapeString(category, "");
            ex.kindOfObject = "servant locator";
            throw ex;
        }
        this._locatorMap.put(category, locator);
    }

    public synchronized ServantLocator findServantLocator(String category) {
        return this._locatorMap.get(category);
    }

    public ServantManager(Instance instance, String adapterName) {
        this._instance = instance;
        this._adapterName = adapterName;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public synchronized void destroy() {
        assert (this._instance != null);
        this._servantMapMap.clear();
        for (Map.Entry<String, ServantLocator> e : this._locatorMap.entrySet()) {
            ServantLocator locator = e.getValue();
            try {
                locator.deactivate(e.getKey());
            }
            catch (Exception ex) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                pw.flush();
                String s = "exception during locator deactivation:\nobject adapter: `" + this._adapterName + "'\n" + "locator category: `" + e.getKey() + "'\n" + sw.toString();
                this._instance.initializationData().logger.error(s);
            }
        }
        this._locatorMap.clear();
        this._instance = null;
    }
}

