/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.SocketException;
import Ice.SyscallException;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.SelectorHandler;
import IceInternal.SocketStatus;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.WritableByteChannel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class Selector {
    private final Instance _instance;
    private final int _timeout;
    private java.nio.channels.Selector _selector;
    private ReadableByteChannel _fdIntrRead;
    private WritableByteChannel _fdIntrWrite;
    private SelectionKey _fdIntrReadKey;
    private Set<SelectionKey> _keys;
    private Iterator<SelectionKey> _iter;
    private HashSet<SelectorHandler> _changes = new HashSet();
    private boolean _interrupted;
    private int _spuriousWakeUp;
    private int _interruptCount;
    private int _pendingInterruptRead;
    private HashSet<SelectorHandler> _pendingHandlers = new HashSet();
    private HashSet<SelectorHandler> _nextPendingHandlers = new HashSet();
    private Iterator<SelectorHandler> _pendingIter;

    public Selector(Instance instance, int timeout) {
        this._instance = instance;
        this._timeout = timeout;
        this._interruptCount = 0;
        Network.SocketPair pair = Network.createPipe();
        this._fdIntrRead = (ReadableByteChannel)((Object)pair.source);
        this._fdIntrWrite = pair.sink;
        try {
            this._selector = java.nio.channels.Selector.open();
            pair.source.configureBlocking(false);
            this._fdIntrReadKey = pair.source.register(this._selector, 1);
        }
        catch (IOException ex) {
            SyscallException sys = new SyscallException();
            sys.initCause(ex);
            throw sys;
        }
        this._keys = this._selector.selectedKeys();
    }

    public void destroy() {
        try {
            this._selector.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        this._selector = null;
        try {
            this._fdIntrWrite.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        this._fdIntrWrite = null;
        try {
            this._fdIntrRead.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._fdIntrRead = null;
    }

    public void add(SelectorHandler handler, SocketStatus status) {
        handler._pendingStatus = status;
        if (this._changes.add(handler)) {
            this.setInterrupt();
        }
    }

    public void update(SelectorHandler handler, SocketStatus newStatus) {
        assert (handler._key != null);
        handler._key.interestOps(this.convertStatus(handler.fd(), newStatus));
    }

    public void remove(SelectorHandler handler) {
        handler._pendingStatus = SocketStatus.Finished;
        if (this._changes.add(handler)) {
            this.setInterrupt();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void select() throws IOException {
        if (this._interrupted || !this._keys.isEmpty() || !this._pendingHandlers.isEmpty()) {
            return;
        }
        while (true) {
            try {
                if (this._nextPendingHandlers.isEmpty()) {
                    if (this._timeout > 0) {
                        this._selector.select(this._timeout * 1000);
                        return;
                    }
                    this._selector.select();
                    return;
                }
                this._selector.selectNow();
                HashSet<SelectorHandler> tmp = this._nextPendingHandlers;
                this._nextPendingHandlers = this._pendingHandlers;
                this._pendingHandlers = tmp;
                return;
            }
            catch (CancelledKeyException ex) {
                continue;
            }
            catch (IOException ex) {
                if (!Network.interrupted(ex)) throw ex;
                continue;
            }
            break;
        }
    }

    public SelectorHandler getNextSelected() {
        assert (this._interruptCount == 0);
        if (this._iter == null && !this._keys.isEmpty()) {
            this._iter = this._keys.iterator();
        }
        while (this._iter != null && this._iter.hasNext()) {
            SelectionKey key = this._iter.next();
            this._iter.remove();
            SelectorHandler handler = (SelectorHandler)key.attachment();
            if (handler == null) {
                assert (this._pendingInterruptRead > 0);
                this._pendingInterruptRead -= this.readInterrupt(this._pendingInterruptRead);
                continue;
            }
            if (handler._key == null || !handler._key.isValid()) continue;
            if (handler.hasMoreData()) {
                assert (this._pendingIter == null);
                this._pendingHandlers.remove(handler);
            }
            if (!this._iter.hasNext()) {
                this._iter = null;
            }
            return handler;
        }
        if (this._pendingIter == null && !this._pendingHandlers.isEmpty()) {
            this._pendingIter = this._pendingHandlers.iterator();
        }
        while (this._pendingIter != null && this._pendingIter.hasNext()) {
            SelectorHandler handler = this._pendingIter.next();
            this._pendingIter.remove();
            if (handler._key == null || !handler._key.isValid() || !handler.hasMoreData()) continue;
            if (!this._pendingIter.hasNext()) {
                this._pendingIter = null;
            }
            return handler;
        }
        this._iter = null;
        this._pendingIter = null;
        return null;
    }

    public void hasMoreData(SelectorHandler handler) {
        this._nextPendingHandlers.add(handler);
    }

    public boolean processInterrupt() {
        assert (this._changes.size() <= this._interruptCount);
        if (!this._changes.isEmpty()) {
            for (SelectorHandler handler : this._changes) {
                if (handler._pendingStatus == SocketStatus.Finished) {
                    this.removeImpl(handler);
                } else {
                    this.addImpl(handler, handler._pendingStatus);
                }
                this.clearInterrupt();
            }
            this._changes.clear();
            try {
                this._selector.selectNow();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._iter = null;
            this._pendingIter = null;
        }
        this._interrupted = this._interruptCount > 0;
        return this._interruptCount == 0;
    }

    public boolean checkTimeout() {
        if (this._interruptCount == 0 && this._keys.isEmpty() && this._pendingHandlers.isEmpty()) {
            if (this._timeout <= 0) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (++this._spuriousWakeUp > 100) {
                    this._instance.initializationData().logger.error("spurious selector wake up");
                }
                return false;
            }
            return true;
        }
        this._spuriousWakeUp = 0;
        return false;
    }

    public boolean isInterrupted() {
        return this._interruptCount > 0;
    }

    public void setInterrupt() {
        if (++this._interruptCount == 1) {
            ByteBuffer buf = ByteBuffer.allocate(1);
            buf.put(0, (byte)0);
            while (buf.hasRemaining()) {
                try {
                    this._fdIntrWrite.write(buf);
                }
                catch (IOException ex) {
                    SocketException se = new SocketException();
                    se.initCause(ex);
                    throw se;
                }
            }
        }
    }

    public boolean clearInterrupt() {
        if (--this._interruptCount == 0) {
            if (this._keys.contains(this._fdIntrReadKey)) {
                this.readInterrupt(1);
                this._keys.remove(this._fdIntrReadKey);
                this._iter = null;
                this._pendingIter = null;
            } else {
                ++this._pendingInterruptRead;
            }
            this._interrupted = false;
            return false;
        }
        return true;
    }

    private int readInterrupt(int count) {
        ByteBuffer buf = ByteBuffer.allocate(count);
        try {
            buf.rewind();
            int ret = this._fdIntrRead.read(buf);
            assert (ret > 0);
            return ret;
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    private int convertStatus(SelectableChannel fd, SocketStatus status) {
        if (status == SocketStatus.NeedConnect) {
            return 8;
        }
        if (status == SocketStatus.NeedRead) {
            if ((fd.validOps() & 1) > 0) {
                return 1;
            }
            return 16;
        }
        assert (status == SocketStatus.NeedWrite);
        return 4;
    }

    private void addImpl(SelectorHandler handler, SocketStatus status) {
        if (handler._key != null) {
            handler._key.interestOps(this.convertStatus(handler.fd(), status));
        } else {
            block6: {
                try {
                    handler._key = handler.fd().register(this._selector, this.convertStatus(handler.fd(), status), handler);
                }
                catch (ClosedChannelException ex) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError();
                }
            }
            assert (!this._nextPendingHandlers.contains(handler));
        }
        if (handler.hasMoreData()) {
            this._nextPendingHandlers.add(handler);
        }
    }

    private void removeImpl(SelectorHandler handler) {
        block3: {
            this._nextPendingHandlers.remove(handler);
            if (handler._key != null) {
                try {
                    handler._key.cancel();
                    handler._key = null;
                }
                catch (CancelledKeyException ex) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
    }
}

