/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AMI_Router_addProxies;
import Ice.AMI_Router_getClientProxy;
import Ice.CollocationOptimizationException;
import Ice.Identity;
import Ice.LocalException;
import Ice.NoEndpointException;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.RouterPrx;
import IceInternal.EndpointI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class RouterInfo {
    private final RouterPrx _router;
    private EndpointI[] _clientEndpoints;
    private EndpointI[] _serverEndpoints;
    private ObjectAdapter _adapter;
    private Set<Identity> _identities = new HashSet<Identity>();
    private List<Identity> _evictedIdentities = new ArrayList<Identity>();

    RouterInfo(RouterPrx router) {
        this._router = router;
        assert (this._router != null);
    }

    public synchronized void destroy() {
        this._clientEndpoints = new EndpointI[0];
        this._serverEndpoints = new EndpointI[0];
        this._adapter = null;
        this._identities.clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RouterInfo) {
            return this._router.equals(((RouterInfo)obj)._router);
        }
        return false;
    }

    public RouterPrx getRouter() {
        return this._router;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointI[] getClientEndpoints() {
        RouterInfo routerInfo = this;
        synchronized (routerInfo) {
            if (this._clientEndpoints != null) {
                return this._clientEndpoints;
            }
        }
        return this.setClientEndpoints(this._router.getClientProxy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getClientEndpoints(final GetClientEndpointsCallback callback) {
        EndpointI[] clientEndpoints = null;
        RouterInfo routerInfo = this;
        synchronized (routerInfo) {
            clientEndpoints = this._clientEndpoints;
        }
        if (clientEndpoints != null) {
            callback.setEndpoints(clientEndpoints);
            return;
        }
        this._router.getClientProxy_async(new AMI_Router_getClientProxy(){

            public void ice_response(ObjectPrx clientProxy) {
                callback.setEndpoints(RouterInfo.this.setClientEndpoints(clientProxy));
            }

            public void ice_exception(LocalException ex) {
                if (ex instanceof CollocationOptimizationException) {
                    try {
                        callback.setEndpoints(RouterInfo.this.getClientEndpoints());
                    }
                    catch (LocalException e) {
                        callback.setException(e);
                    }
                } else {
                    callback.setException(ex);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointI[] getServerEndpoints() {
        RouterInfo routerInfo = this;
        synchronized (routerInfo) {
            if (this._serverEndpoints != null) {
                return this._serverEndpoints;
            }
        }
        return this.setServerEndpoints(this._router.getServerProxy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProxy(ObjectPrx proxy) {
        assert (proxy != null);
        RouterInfo routerInfo = this;
        synchronized (routerInfo) {
            if (this._identities.contains(proxy.ice_getIdentity())) {
                return;
            }
        }
        this.addAndEvictProxies(proxy, this._router.addProxies(new ObjectPrx[]{proxy}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addProxy(final ObjectPrx proxy, final AddProxyCallback callback) {
        assert (proxy != null);
        RouterInfo routerInfo = this;
        synchronized (routerInfo) {
            if (this._identities.contains(proxy.ice_getIdentity())) {
                return true;
            }
        }
        this._router.addProxies_async(new AMI_Router_addProxies(){

            public void ice_response(ObjectPrx[] evictedProxies) {
                RouterInfo.this.addAndEvictProxies(proxy, evictedProxies);
                callback.addedProxy();
            }

            public void ice_exception(LocalException ex) {
                if (ex instanceof CollocationOptimizationException) {
                    try {
                        RouterInfo.this.addProxy(proxy);
                        callback.addedProxy();
                    }
                    catch (LocalException e) {
                        callback.setException(ex);
                    }
                } else {
                    callback.setException(ex);
                }
            }
        }, new ObjectPrx[]{proxy});
        return false;
    }

    public synchronized void setAdapter(ObjectAdapter adapter) {
        this._adapter = adapter;
    }

    public synchronized ObjectAdapter getAdapter() {
        return this._adapter;
    }

    private synchronized EndpointI[] setClientEndpoints(ObjectPrx clientProxy) {
        if (this._clientEndpoints == null) {
            if (clientProxy == null) {
                this._clientEndpoints = ((ObjectPrxHelperBase)((Object)this._router)).__reference().getEndpoints();
            } else {
                clientProxy = clientProxy.ice_router(null);
                try {
                    clientProxy = clientProxy.ice_timeout(this._router.ice_getConnection().timeout());
                }
                catch (CollocationOptimizationException collocationOptimizationException) {
                    // empty catch block
                }
                this._clientEndpoints = ((ObjectPrxHelperBase)clientProxy).__reference().getEndpoints();
            }
        }
        return this._clientEndpoints;
    }

    private synchronized EndpointI[] setServerEndpoints(ObjectPrx serverProxy) {
        if (serverProxy == null) {
            throw new NoEndpointException();
        }
        serverProxy = serverProxy.ice_router(null);
        this._serverEndpoints = ((ObjectPrxHelperBase)serverProxy).__reference().getEndpoints();
        return this._serverEndpoints;
    }

    private synchronized void addAndEvictProxies(ObjectPrx proxy, ObjectPrx[] evictedProxies) {
        int index = this._evictedIdentities.indexOf(proxy.ice_getIdentity());
        if (index >= 0) {
            this._evictedIdentities.remove(index);
        } else {
            this._identities.add(proxy.ice_getIdentity());
        }
        for (int i = 0; i < evictedProxies.length; ++i) {
            if (this._identities.remove(evictedProxies[i].ice_getIdentity())) continue;
            this._evictedIdentities.add(evictedProxies[i].ice_getIdentity());
        }
    }

    static interface AddProxyCallback {
        public void addedProxy();

        public void setException(LocalException var1);
    }

    static interface GetClientEndpointsCallback {
        public void setEndpoints(EndpointI[] var1);

        public void setException(LocalException var1);
    }
}

