/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CommunicatorDestroyedException;
import Ice.LocalException;
import IceInternal.OutgoingAsync;
import IceInternal.RetryQueue;
import IceInternal.TimerTask;

class RetryTask
implements TimerTask {
    private final RetryQueue _queue;
    private final OutgoingAsync _outAsync;

    RetryTask(RetryQueue queue, OutgoingAsync outAsync) {
        this._queue = queue;
        this._outAsync = outAsync;
    }

    public void runTimerTask() {
        if (this._queue.remove(this)) {
            try {
                this._outAsync.__send();
            }
            catch (LocalException ex) {
                this._outAsync.__releaseCallback(ex);
            }
        }
    }

    public void destroy() {
        this._outAsync.__releaseCallback(new CommunicatorDestroyedException());
    }
}

