/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import IceInternal.Instance;
import IceInternal.OutgoingAsync;
import IceInternal.RetryTask;
import java.util.HashSet;

public class RetryQueue {
    private final Instance _instance;
    private final HashSet<RetryTask> _requests = new HashSet();

    RetryQueue(Instance instance) {
        this._instance = instance;
    }

    public synchronized void add(OutgoingAsync outAsync, int interval) {
        RetryTask task = new RetryTask(this, outAsync);
        this._instance.timer().schedule(task, interval);
        this._requests.add(task);
    }

    public synchronized void destroy() {
        for (RetryTask task : this._requests) {
            this._instance.timer().cancel(task);
            task.destroy();
        }
        this._requests.clear();
    }

    synchronized boolean remove(RetryTask task) {
        return this._requests.remove(task);
    }
}

