/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Identity;
import Ice.LocalException;
import Ice.Logger;
import Ice.MarshalException;
import Ice.ObjectNotExistException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.RequestFailedException;
import IceInternal.BasicStream;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.OutgoingAsync;
import IceInternal.Reference;
import IceInternal.TraceLevels;

public final class ProxyFactory {
    private Instance _instance;
    private int[] _retryIntervals;

    public ObjectPrx stringToProxy(String str) {
        Reference ref = this._instance.referenceFactory().create(str, null);
        return this.referenceToProxy(ref);
    }

    public String proxyToString(ObjectPrx proxy) {
        if (proxy != null) {
            ObjectPrxHelperBase h = (ObjectPrxHelperBase)proxy;
            return h.__reference().toString();
        }
        return "";
    }

    public ObjectPrx propertyToProxy(String prefix) {
        String proxy = this._instance.initializationData().properties.getProperty(prefix);
        Reference ref = this._instance.referenceFactory().create(proxy, prefix);
        return this.referenceToProxy(ref);
    }

    public ObjectPrx streamToProxy(BasicStream s) {
        Identity ident = new Identity();
        ident.__read(s);
        Reference ref = this._instance.referenceFactory().create(ident, s);
        return this.referenceToProxy(ref);
    }

    public ObjectPrx referenceToProxy(Reference ref) {
        if (ref != null) {
            ObjectPrxHelperBase proxy = new ObjectPrxHelperBase();
            proxy.setup(ref);
            return proxy;
        }
        return null;
    }

    public void proxyToStream(ObjectPrx proxy, BasicStream s) {
        if (proxy != null) {
            ObjectPrxHelperBase h = (ObjectPrxHelperBase)proxy;
            Reference ref = h.__reference();
            ref.getIdentity().__write(s);
            ref.streamWrite(s);
        } else {
            Identity ident = new Identity();
            ident.name = "";
            ident.category = "";
            ident.__write(s);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int checkRetryAfterException(LocalException ex, Reference ref, OutgoingAsync out, int cnt) {
        TraceLevels traceLevels = this._instance.traceLevels();
        Logger logger = this._instance.initializationData().logger;
        if (ref.getMode() == 2 || ref.getMode() == 4) {
            throw ex;
        }
        if (ex instanceof ObjectNotExistException) {
            LocatorInfo li;
            ObjectNotExistException one = (ObjectNotExistException)ex;
            if (ref.getRouterInfo() != null && one.operation.equals("ice_add_proxy")) {
                if (traceLevels.retry >= 1) {
                    String s = "retrying operation call to add proxy to router\n" + ex.toString();
                    logger.trace(traceLevels.retryCat, s);
                }
                if (out == null) return cnt;
                out.__retry(cnt, 0);
                return cnt;
            }
            if (!ref.isIndirect()) throw ex;
            if (ref.isWellKnown() && (li = ref.getLocatorInfo()) != null) {
                li.clearCache(ref);
            }
        } else if (ex instanceof RequestFailedException) {
            throw ex;
        }
        if (ex instanceof MarshalException) {
            throw ex;
        }
        assert (++cnt > 0);
        if (cnt > this._retryIntervals.length) {
            if (traceLevels.retry < 1) throw ex;
            String s = "cannot retry operation call because retry limit has been exceeded\n" + ex.toString();
            logger.trace(traceLevels.retryCat, s);
            throw ex;
        }
        int interval = this._retryIntervals[cnt - 1];
        if (traceLevels.retry >= 1) {
            String s = "retrying operation call";
            if (interval > 0) {
                s = s + " in " + interval + "ms";
            }
            s = s + " because of exception\n" + ex;
            logger.trace(traceLevels.retryCat, s);
        }
        if (out != null) {
            out.__retry(cnt, interval);
            return cnt;
        }
        if (interval <= 0) return cnt;
        try {
            Thread.sleep(interval);
            return cnt;
        }
        catch (InterruptedException ex1) {
            // empty catch block
        }
        return cnt;
    }

    ProxyFactory(Instance instance) {
        this._instance = instance;
        String[] arr = this._instance.initializationData().properties.getPropertyAsList("Ice.RetryIntervals");
        if (arr.length > 0) {
            this._retryIntervals = new int[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                int v;
                try {
                    v = Integer.parseInt(arr[i]);
                }
                catch (NumberFormatException ex) {
                    v = 0;
                }
                if (i == 0 && v == -1) {
                    this._retryIntervals = new int[0];
                    break;
                }
                this._retryIntervals[i] = v > 0 ? v : 0;
            }
        } else {
            this._retryIntervals = new int[1];
            this._retryIntervals[0] = 0;
        }
    }
}

