/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import IceInternal.BasicStream;
import java.io.IOException;
import java.io.OutputStream;

public class OutputStreamWrapper
extends OutputStream {
    private BasicStream _s;
    private int _spos;
    private byte[] _bytes;
    private int _pos;

    public OutputStreamWrapper(BasicStream s) {
        this._s = s;
        this._spos = s.pos();
        this._bytes = new byte[254];
        this._pos = 0;
    }

    public void write(int b) throws IOException {
        try {
            if (this._bytes != null) {
                if (this._pos < this._bytes.length) {
                    this._bytes[this._pos++] = (byte)b;
                    return;
                }
                this._s.writeSize(255);
                if (this._pos > 0) {
                    this._s.expand(this._pos);
                    this._s.getBuffer().b.put(this._bytes, 0, this._pos);
                }
                this._bytes = null;
            }
            this._s.expand(1);
            this._s.getBuffer().b.put((byte)b);
            ++this._pos;
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] bytes, int offset, int count) throws IOException {
        try {
            if (this._bytes != null) {
                if (count <= this._bytes.length - this._pos) {
                    System.arraycopy(bytes, offset, this._bytes, this._pos, count);
                    this._pos += count;
                    return;
                }
                this._s.writeSize(255);
                if (this._pos > 0) {
                    this._s.expand(this._pos);
                    this._s.getBuffer().b.put(this._bytes, 0, this._pos);
                }
                this._bytes = null;
            }
            this._s.expand(count);
            this._s.getBuffer().b.put(bytes, offset, count);
            this._pos += count;
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        try {
            if (this._bytes != null) {
                assert (this._pos <= this._bytes.length);
                this._s.pos(this._spos);
                this._s.writeSize(this._pos);
                this._s.expand(this._pos);
                this._s.getBuffer().b.put(this._bytes, 0, this._pos);
                this._bytes = null;
            } else {
                int currentPos = this._s.pos();
                this._s.pos(this._spos);
                this._s.writeSize(this._pos);
                this._s.pos(currentPos);
            }
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
    }
}

