/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CloseConnectionException;
import Ice.ConnectionI;
import Ice.ContextHelper;
import Ice.FacetNotExistException;
import Ice.FeatureNotSupportedException;
import Ice.Identity;
import Ice.ImplicitContextI;
import Ice.LocalException;
import Ice.MarshalException;
import Ice.ObjectNotExistException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.OperationMode;
import Ice.OperationNotExistException;
import Ice.RequestFailedException;
import Ice.TimeoutException;
import Ice.UnknownException;
import Ice.UnknownLocalException;
import Ice.UnknownReplyStatusException;
import Ice.UnknownUserException;
import Ice.UserException;
import Ice._ObjectDel;
import IceInternal.BasicStream;
import IceInternal.LocalExceptionWrapper;
import IceInternal.OutgoingAsyncMessageCallback;
import IceInternal.Protocol;
import IceInternal.Reference;
import IceInternal.TimerTask;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OutgoingAsync
extends OutgoingAsyncMessageCallback {
    private boolean _sent;
    private boolean _sentSynchronously;
    private boolean _response;
    private ObjectPrxHelperBase _proxy;
    private _ObjectDel _delegate;
    private int _cnt;
    private OperationMode _mode;
    private TimerTask _timerTask;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void __sent(final ConnectionI connection) {
        Object object = this.__monitor;
        synchronized (object) {
            this._sent = true;
            if (!this._proxy.ice_isTwoway()) {
                this.__releaseCallback();
            } else if (this._response) {
                this.__monitor.notifyAll();
            } else if (connection.timeout() >= 0) {
                assert (this._timerTask == null);
                this._timerTask = new TimerTask(){

                    public void runTimerTask() {
                        OutgoingAsync.this.__runTimerTask(connection);
                    }
                };
                this._proxy.__reference().getInstance().timer().schedule(this._timerTask, connection.timeout());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void __finished(BasicStream is) {
        byte replyStatus;
        assert (this._proxy.ice_isTwoway());
        try {
            Object object = this.__monitor;
            synchronized (object) {
                assert (this.__os != null);
                this._response = true;
                if (this._timerTask != null && this._proxy.__reference().getInstance().timer().cancel(this._timerTask)) {
                    this._timerTask = null;
                }
                while (!this._sent || this._timerTask != null) {
                    try {
                        this.__monitor.wait();
                    }
                    catch (InterruptedException ex) {}
                }
                this.__is.swap(is);
                replyStatus = this.__is.readByte();
                switch (replyStatus) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        String facet;
                        Identity id = new Identity();
                        id.__read(this.__is);
                        String[] facetPath = this.__is.readStringSeq();
                        if (facetPath.length > 0) {
                            if (facetPath.length > 1) {
                                throw new MarshalException();
                            }
                            facet = facetPath[0];
                        } else {
                            facet = "";
                        }
                        String operation = this.__is.readString();
                        RequestFailedException ex = null;
                        switch (replyStatus) {
                            case 2: {
                                ex = new ObjectNotExistException();
                                break;
                            }
                            case 3: {
                                ex = new FacetNotExistException();
                                break;
                            }
                            case 4: {
                                ex = new OperationNotExistException();
                                break;
                            }
                            default: {
                                assert (false);
                                break;
                            }
                        }
                        ex.id = id;
                        ex.facet = facet;
                        ex.operation = operation;
                        throw ex;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        String unknown = this.__is.readString();
                        UnknownException ex = null;
                        switch (replyStatus) {
                            case 7: {
                                ex = new UnknownException();
                                break;
                            }
                            case 5: {
                                ex = new UnknownLocalException();
                                break;
                            }
                            case 6: {
                                ex = new UnknownUserException();
                                break;
                            }
                            default: {
                                assert (false);
                                break;
                            }
                        }
                        ex.unknown = unknown;
                        throw ex;
                    }
                    default: {
                        throw new UnknownReplyStatusException();
                    }
                }
            }
        }
        catch (LocalException ex) {
            this.__finished(ex);
            return;
        }
        assert (replyStatus == 0 || replyStatus == 1);
        try {
            this.__response(replyStatus == 0);
        }
        catch (Exception ex) {
            this.__warning(ex);
            this.__releaseCallback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void __finished(LocalException exc) {
        Object object = this.__monitor;
        synchronized (object) {
            if (this.__os != null) {
                if (this._timerTask != null && this._proxy.__reference().getInstance().timer().cancel(this._timerTask)) {
                    this._timerTask = null;
                }
                while (this._timerTask != null) {
                    try {
                        this.__monitor.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        try {
            this.handleException(exc);
        }
        catch (LocalException ex) {
            this.__exception(ex);
        }
    }

    public final void __finished(LocalExceptionWrapper ex) {
        assert (this.__os != null && !this._sent);
        try {
            this.handleException(ex);
        }
        catch (LocalException exc) {
            this.__exception(exc);
        }
    }

    public final void __retry(int cnt, int interval) {
        this._cnt = cnt;
        if (interval > 0) {
            assert (this.__os != null);
            this.__os.instance().retryQueue().add(this, interval);
        } else {
            this.__send();
        }
    }

    public final boolean __send() {
        try {
            this._sent = false;
            this._response = false;
            this._delegate = this._proxy.__getDelegate(true);
            this._sentSynchronously = this._delegate.__getRequestHandler().sendAsyncRequest(this);
        }
        catch (LocalExceptionWrapper ex) {
            this.handleException(ex);
        }
        catch (LocalException ex) {
            this.handleException(ex);
        }
        return this._sentSynchronously;
    }

    protected final void __prepare(ObjectPrx prx, String operation, OperationMode mode, Map<String, String> context) {
        assert (this.__os != null);
        this._proxy = (ObjectPrxHelperBase)prx;
        this._delegate = null;
        this._cnt = 0;
        this._mode = mode;
        this._sentSynchronously = false;
        if (this._proxy.ice_isBatchOneway() || this._proxy.ice_isBatchDatagram()) {
            throw new FeatureNotSupportedException("can't send batch requests with AMI");
        }
        this.__os.writeBlob(Protocol.requestHdr);
        Reference ref = this._proxy.__reference();
        ref.getIdentity().__write(this.__os);
        String facet = ref.getFacet();
        if (facet == null || facet.length() == 0) {
            this.__os.writeStringSeq(null);
        } else {
            String[] facetPath = new String[]{facet};
            this.__os.writeStringSeq(facetPath);
        }
        this.__os.writeString(operation);
        this.__os.writeByte((byte)mode.value());
        if (context != null) {
            ContextHelper.write(this.__os, context);
        } else {
            ImplicitContextI implicitContext = ref.getInstance().getImplicitContext();
            Map<String, String> prxContext = ref.getContext();
            if (implicitContext == null) {
                ContextHelper.write(this.__os, prxContext);
            } else {
                implicitContext.write(prxContext, this.__os);
            }
        }
        this.__os.startWriteEncaps();
    }

    protected abstract void __response(boolean var1);

    protected void __throwUserException() throws UserException {
        try {
            this.__is.startReadEncaps();
            this.__is.throwException();
        }
        catch (UserException ex) {
            this.__is.endReadEncaps();
            throw ex;
        }
    }

    private void handleException(LocalExceptionWrapper ex) {
        if (this._mode == OperationMode.Nonmutating || this._mode == OperationMode.Idempotent) {
            this._proxy.__handleExceptionWrapperRelaxed(this._delegate, ex, this, this._cnt);
        } else {
            this._proxy.__handleExceptionWrapper(this._delegate, ex, this);
        }
    }

    private void handleException(LocalException exc) {
        try {
            if (!this._sent || exc instanceof CloseConnectionException || exc instanceof ObjectNotExistException) {
                throw exc;
            }
            throw new LocalExceptionWrapper(exc, false);
        }
        catch (LocalExceptionWrapper ex) {
            if (this._mode == OperationMode.Nonmutating || this._mode == OperationMode.Idempotent) {
                this._proxy.__handleExceptionWrapperRelaxed(this._delegate, ex, this, this._cnt);
            } else {
                this._proxy.__handleExceptionWrapper(this._delegate, ex, this);
            }
        }
        catch (LocalException ex) {
            this._proxy.__handleException(this._delegate, ex, this, this._cnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void __runTimerTask(ConnectionI connection) {
        Object object = this.__monitor;
        synchronized (object) {
            assert (this._timerTask != null && this._sent);
            if (this._response) {
                connection = null;
            }
            this._timerTask = null;
            this.__monitor.notifyAll();
        }
        if (connection != null) {
            connection.exception(new TimeoutException());
        }
    }
}

