/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectFailedException;
import Ice.ConnectionRefusedException;
import Ice.DNSException;
import Ice.Logger;
import Ice.Properties;
import Ice.SocketException;
import Ice.TimeoutException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Network {
    public static final int EnableIPv4 = 0;
    public static final int EnableIPv6 = 1;
    public static final int EnableBoth = 2;

    public static boolean connectionLost(IOException ex) {
        String msg = ex.getMessage();
        if (msg != null) {
            msg = msg.toLowerCase();
            String[] msgs = new String[]{"connection reset by peer", "cannot send after socket shutdown", "cannot send after transport endpoint shutdown", "software caused connection abort", "an existing connection was forcibly closed", "connection closed by remote host", "an established connection was aborted by the software in your host machine", "broken pipe", "there is no process to read data written to a pipe", "socket is closed"};
            for (int i = 0; i < msgs.length; ++i) {
                if (msg.indexOf(msgs[i]) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean connectionRefused(ConnectException ex) {
        String msg = ex.getMessage().toLowerCase();
        if (msg != null) {
            String[] msgs = new String[]{"connection refused", "remote host refused an attempted connect operation"};
            for (int i = 0; i < msgs.length; ++i) {
                if (msg.indexOf(msgs[i]) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean noMoreFds(Throwable ex) {
        String msg = ex.getMessage();
        if (msg != null) {
            msg = msg.toLowerCase();
            String[] msgs = new String[]{"too many open files", "file table overflow", "too many open files in system"};
            for (int i = 0; i < msgs.length; ++i) {
                if (msg.indexOf(msgs[i]) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public static SocketChannel createTcpSocket() {
        try {
            SocketChannel fd = SocketChannel.open();
            Socket socket = fd.socket();
            socket.setTcpNoDelay(true);
            socket.setKeepAlive(true);
            return fd;
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public static ServerSocketChannel createTcpServerSocket() {
        try {
            ServerSocketChannel fd = ServerSocketChannel.open();
            return fd;
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public static DatagramChannel createUdpSocket() {
        try {
            return DatagramChannel.open();
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public static void closeSocketNoThrow(SelectableChannel fd) {
        try {
            fd.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeSocket(SelectableChannel fd) {
        try {
            fd.close();
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public static void setBlock(SelectableChannel fd, boolean block) {
        try {
            fd.configureBlocking(block);
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public static void setReuseAddress(DatagramChannel fd, boolean reuse) {
        try {
            fd.socket().setReuseAddress(reuse);
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public static void setReuseAddress(ServerSocketChannel fd, boolean reuse) {
        try {
            fd.socket().setReuseAddress(reuse);
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public static InetSocketAddress doBind(ServerSocketChannel fd, InetSocketAddress addr, int backlog) {
        try {
            ServerSocket sock = fd.socket();
            sock.bind(addr, backlog);
            return (InetSocketAddress)sock.getLocalSocketAddress();
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public static InetSocketAddress doBind(DatagramChannel fd, InetSocketAddress addr) {
        try {
            DatagramSocket sock = fd.socket();
            sock.bind(addr);
            return (InetSocketAddress)sock.getLocalSocketAddress();
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public static SocketChannel doAccept(ServerSocketChannel afd) {
        SocketChannel fd = null;
        while (true) {
            try {
                fd = afd.accept();
            }
            catch (IOException ex) {
                if (Network.interrupted(ex)) continue;
                SocketException se = new SocketException();
                se.initCause(ex);
                throw se;
            }
            break;
        }
        try {
            Socket socket = fd.socket();
            socket.setTcpNoDelay(true);
            socket.setKeepAlive(true);
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
        return fd;
    }

    public static boolean doConnect(SocketChannel fd, InetSocketAddress addr) {
        try {
            if (!fd.connect(addr)) {
                return false;
            }
        }
        catch (ConnectException ex) {
            Network.closeSocketNoThrow(fd);
            ConnectFailedException se = Network.connectionRefused(ex) ? new ConnectionRefusedException() : new ConnectFailedException();
            se.initCause(ex);
            throw se;
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
        catch (SecurityException ex) {
            Network.closeSocketNoThrow(fd);
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
        if (System.getProperty("os.name").equals("Linux") && addr.equals(fd.socket().getLocalSocketAddress())) {
            Network.closeSocketNoThrow(fd);
            throw new ConnectionRefusedException();
        }
        return true;
    }

    public static void doFinishConnect(SocketChannel fd) {
        try {
            SocketAddress addr;
            if (!fd.finishConnect()) {
                throw new ConnectFailedException();
            }
            if (System.getProperty("os.name").equals("Linux") && (addr = fd.socket().getRemoteSocketAddress()) != null && addr.equals(fd.socket().getLocalSocketAddress())) {
                throw new ConnectionRefusedException();
            }
        }
        catch (ConnectException ex) {
            ConnectFailedException se = Network.connectionRefused(ex) ? new ConnectionRefusedException() : new ConnectFailedException();
            se.initCause(ex);
            throw se;
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public static void doConnect(DatagramChannel fd, InetSocketAddress addr) {
        try {
            fd.connect(addr);
        }
        catch (ConnectException ex) {
            Network.closeSocketNoThrow(fd);
            ConnectFailedException se = Network.connectionRefused(ex) ? new ConnectionRefusedException() : new ConnectFailedException();
            se.initCause(ex);
            throw se;
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SocketChannel doAccept(ServerSocketChannel fd, int timeout) {
        SocketChannel result = null;
        while (result == null) {
            try {
                IOException ex3;
                Object var7_10;
                result = fd.accept();
                if (result != null) continue;
                Selector selector = Selector.open();
                try {
                    while (true) {
                        try {
                            fd.register(selector, 16);
                            int n = timeout > 0 ? selector.select(timeout) : (timeout == 0 ? selector.selectNow() : selector.select());
                            if (n == 0) {
                                throw new TimeoutException();
                            }
                        }
                        catch (IOException ex2) {
                            if (Network.interrupted(ex2)) continue;
                            SocketException se = new SocketException();
                            se.initCause(ex2);
                            throw se;
                        }
                        break;
                    }
                    var7_10 = null;
                }
                catch (Throwable throwable) {
                    var7_10 = null;
                    try {
                        selector.close();
                    }
                    catch (IOException ex3) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    selector.close();
                }
                catch (IOException ex3) {}
            }
            catch (IOException ex) {
                if (Network.interrupted(ex)) continue;
                SocketException se = new SocketException();
                se.initCause(ex);
                throw se;
            }
        }
        try {
            Socket socket = result.socket();
            socket.setTcpNoDelay(true);
            socket.setKeepAlive(true);
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
        return result;
    }

    public static void setSendBufferSize(SocketChannel fd, int size) {
        try {
            Socket socket = fd.socket();
            socket.setSendBufferSize(size);
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public static int getSendBufferSize(SocketChannel fd) {
        int size;
        try {
            Socket socket = fd.socket();
            size = socket.getSendBufferSize();
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
        return size;
    }

    public static void setRecvBufferSize(SocketChannel fd, int size) {
        try {
            Socket socket = fd.socket();
            socket.setReceiveBufferSize(size);
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public static int getRecvBufferSize(SocketChannel fd) {
        int size;
        try {
            Socket socket = fd.socket();
            size = socket.getReceiveBufferSize();
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
        return size;
    }

    public static void setRecvBufferSize(ServerSocketChannel fd, int size) {
        try {
            ServerSocket socket = fd.socket();
            socket.setReceiveBufferSize(size);
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public static int getRecvBufferSize(ServerSocketChannel fd) {
        int size;
        try {
            ServerSocket socket = fd.socket();
            size = socket.getReceiveBufferSize();
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
        return size;
    }

    public static void setSendBufferSize(DatagramChannel fd, int size) {
        try {
            DatagramSocket socket = fd.socket();
            socket.setSendBufferSize(size);
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public static int getSendBufferSize(DatagramChannel fd) {
        int size;
        try {
            DatagramSocket socket = fd.socket();
            size = socket.getSendBufferSize();
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
        return size;
    }

    public static void setRecvBufferSize(DatagramChannel fd, int size) {
        try {
            DatagramSocket socket = fd.socket();
            socket.setReceiveBufferSize(size);
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public static int getRecvBufferSize(DatagramChannel fd) {
        int size;
        try {
            DatagramSocket socket = fd.socket();
            size = socket.getReceiveBufferSize();
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
        return size;
    }

    public static InetSocketAddress getAddress(String host, int port, int protocol) {
        return Network.getAddressImpl(host, port, protocol, false);
    }

    public static InetSocketAddress getAddressForServer(String host, int port, int protocol) {
        return Network.getAddressImpl(host, port, protocol, true);
    }

    public static int compareAddress(InetSocketAddress addr1, InetSocketAddress addr2) {
        byte[] rarr;
        if (addr1.getPort() < addr2.getPort()) {
            return -1;
        }
        if (addr2.getPort() < addr1.getPort()) {
            return 1;
        }
        byte[] larr = addr1.getAddress().getAddress();
        if (larr.length < (rarr = addr2.getAddress().getAddress()).length) {
            return -1;
        }
        if (rarr.length < larr.length) {
            return 1;
        }
        assert (larr.length == rarr.length);
        for (int i = 0; i < larr.length; ++i) {
            if (larr[i] < rarr[i]) {
                return -1;
            }
            if (rarr[i] >= larr[i]) continue;
            return 1;
        }
        return 0;
    }

    public static InetAddress getLocalAddress(int protocol) {
        InetAddress addr = null;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        if (addr == null || !Network.isValidAddr(addr, protocol)) {
            ArrayList<InetAddress> addrs = Network.getLocalAddresses(protocol);
            Iterator<InetAddress> iter = addrs.iterator();
            while (addr == null && iter.hasNext()) {
                InetAddress a = iter.next();
                if (protocol != 2 && !Network.isValidAddr(a, protocol)) continue;
                addr = a;
            }
            if (addr == null) {
                addr = Network.getLoopbackAddresses(protocol)[0];
            }
        }
        assert (addr != null);
        return addr;
    }

    public static ArrayList<InetSocketAddress> getAddresses(String host, int port, int protocol) {
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        try {
            InetAddress[] addrs = host == null || host.length() == 0 ? Network.getLoopbackAddresses(protocol) : InetAddress.getAllByName(host);
            for (int i = 0; i < addrs.length; ++i) {
                if (protocol != 2 && !Network.isValidAddr(addrs[i], protocol)) continue;
                addresses.add(new InetSocketAddress(addrs[i], port));
            }
        }
        catch (UnknownHostException ex) {
            DNSException e = new DNSException();
            e.host = host;
            e.initCause(ex);
            throw e;
        }
        catch (SecurityException ex) {
            SocketException e = new SocketException();
            e.initCause(ex);
            throw e;
        }
        if (addresses.size() == 0) {
            DNSException e = new DNSException();
            e.host = host;
            throw e;
        }
        return addresses;
    }

    public static ArrayList<InetAddress> getLocalAddresses(int protocol) {
        ArrayList<InetAddress> result = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> addrs = iface.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (addr.isLoopbackAddress() || protocol != 2 && !Network.isValidAddr(addr, protocol)) continue;
                    result.add(addr);
                }
            }
        }
        catch (java.net.SocketException e) {
            SocketException se = new SocketException();
            se.initCause(e);
            throw se;
        }
        catch (SecurityException ex) {
            SocketException e = new SocketException();
            e.initCause(ex);
            throw e;
        }
        return result;
    }

    public static SocketPair createPipe() {
        SocketPair fds = new SocketPair();
        try {
            Pipe pipe = Pipe.open();
            fds.sink = pipe.sink();
            fds.source = pipe.source();
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
        return fds;
    }

    public static ArrayList<String> getHostsForEndpointExpand(String host, int protocolSupport) {
        boolean wildcard;
        boolean bl = wildcard = host == null || host.length() == 0;
        if (!wildcard) {
            try {
                wildcard = InetAddress.getByName(host).isAnyLocalAddress();
            }
            catch (UnknownHostException ex) {
            }
            catch (SecurityException ex) {
                SocketException e = new SocketException();
                e.initCause(ex);
                throw e;
            }
        }
        ArrayList<String> hosts = new ArrayList<String>();
        if (wildcard) {
            ArrayList<InetAddress> addrs = Network.getLocalAddresses(protocolSupport);
            for (InetAddress addr : addrs) {
                if (addr.isLinkLocalAddress()) continue;
                hosts.add(addr.getHostAddress());
            }
            if (hosts.isEmpty()) {
                if (protocolSupport != 1) {
                    hosts.add("127.0.0.1");
                }
                if (protocolSupport != 0) {
                    hosts.add("0:0:0:0:0:0:0:1");
                }
            }
        }
        return hosts;
    }

    public static void setTcpBufSize(SocketChannel socket, Properties properties, Logger logger) {
        int size;
        int sizeRequested;
        int dfltBufSize = 0;
        if (System.getProperty("os.name").startsWith("Windows")) {
            dfltBufSize = 131072;
        }
        if ((sizeRequested = properties.getPropertyAsIntWithDefault("Ice.TCP.RcvSize", dfltBufSize)) > 0) {
            Network.setRecvBufferSize(socket, sizeRequested);
            size = Network.getRecvBufferSize(socket);
            if (size < sizeRequested) {
                logger.warning("TCP receive buffer size: requested size of " + sizeRequested + " adjusted to " + size);
            }
        }
        if ((sizeRequested = properties.getPropertyAsIntWithDefault("Ice.TCP.SndSize", dfltBufSize)) > 0) {
            Network.setSendBufferSize(socket, sizeRequested);
            size = Network.getSendBufferSize(socket);
            if (size < sizeRequested) {
                logger.warning("TCP send buffer size: requested size of " + sizeRequested + " adjusted to " + size);
            }
        }
    }

    public static void setTcpBufSize(ServerSocketChannel socket, Properties properties, Logger logger) {
        int sizeRequested;
        int dfltBufSize = 0;
        if (System.getProperty("os.name").startsWith("Windows")) {
            dfltBufSize = 131072;
        }
        if ((sizeRequested = properties.getPropertyAsIntWithDefault("Ice.TCP.RcvSize", dfltBufSize)) > 0) {
            Network.setRecvBufferSize(socket, sizeRequested);
            int size = Network.getRecvBufferSize(socket);
            if (size < sizeRequested) {
                logger.warning("TCP receive buffer size: requested size of " + sizeRequested + " adjusted to " + size);
            }
        }
    }

    public static String fdToString(SelectableChannel fd) {
        if (fd == null) {
            return "<closed>";
        }
        InetAddress localAddr = null;
        InetAddress remoteAddr = null;
        int localPort = -1;
        int remotePort = -1;
        if (fd instanceof SocketChannel) {
            Socket socket = ((SocketChannel)fd).socket();
            localAddr = socket.getLocalAddress();
            localPort = socket.getLocalPort();
            remoteAddr = socket.getInetAddress();
            remotePort = socket.getPort();
        } else if (fd instanceof DatagramChannel) {
            DatagramSocket socket = ((DatagramChannel)fd).socket();
            localAddr = socket.getLocalAddress();
            localPort = socket.getLocalPort();
            remoteAddr = socket.getInetAddress();
            remotePort = socket.getPort();
        } else assert (false);
        return Network.addressesToString(localAddr, localPort, remoteAddr, remotePort);
    }

    public static String fdToString(Socket fd) {
        if (fd == null) {
            return "<closed>";
        }
        InetAddress localAddr = fd.getLocalAddress();
        int localPort = fd.getLocalPort();
        InetAddress remoteAddr = fd.getInetAddress();
        int remotePort = fd.getPort();
        return Network.addressesToString(localAddr, localPort, remoteAddr, remotePort);
    }

    public static String addressesToString(InetAddress localAddr, int localPort, InetAddress remoteAddr, int remotePort) {
        StringBuilder s = new StringBuilder(128);
        s.append("local address = ");
        s.append(localAddr.getHostAddress());
        s.append(':');
        s.append(localPort);
        if (remoteAddr == null) {
            s.append("\nremote address = <not connected>");
        } else {
            s.append("\nremote address = ");
            s.append(remoteAddr.getHostAddress());
            s.append(':');
            s.append(remotePort);
        }
        return s.toString();
    }

    public static String addrToString(InetSocketAddress addr) {
        StringBuilder s = new StringBuilder(128);
        s.append(addr.getAddress().getHostAddress());
        s.append(':');
        s.append(addr.getPort());
        return s.toString();
    }

    public static boolean interrupted(IOException ex) {
        return ex instanceof InterruptedIOException || ex.getMessage().indexOf("Interrupted system call") >= 0 || ex.getMessage().indexOf("A system call received an interrupt") >= 0;
    }

    private static boolean isValidAddr(InetAddress addr, int protocol) {
        byte[] bytes = null;
        if (addr != null) {
            bytes = addr.getAddress();
        }
        return bytes != null && (bytes.length == 16 && protocol == 1 || bytes.length == 4 && protocol == 0);
    }

    private static InetSocketAddress getAddressImpl(String host, int port, int protocol, boolean server) {
        try {
            InetAddress[] addrs = host == null || host.length() == 0 ? (server ? Network.getWildcardAddresses(protocol) : Network.getLoopbackAddresses(protocol)) : InetAddress.getAllByName(host);
            for (int i = 0; i < addrs.length; ++i) {
                if (protocol != 2 && !Network.isValidAddr(addrs[i], protocol)) continue;
                return new InetSocketAddress(addrs[i], port);
            }
        }
        catch (UnknownHostException ex) {
            DNSException e = new DNSException();
            e.host = host;
            e.initCause(ex);
            throw e;
        }
        catch (SecurityException ex) {
            SocketException e = new SocketException();
            e.initCause(ex);
            throw e;
        }
        DNSException e = new DNSException();
        e.host = host;
        throw e;
    }

    private static InetAddress[] getLoopbackAddresses(int protocol) {
        try {
            InetAddress[] addrs = new InetAddress[protocol == 2 ? 2 : 1];
            int i = 0;
            if (protocol != 1) {
                addrs[i++] = InetAddress.getByName("127.0.0.1");
            }
            if (protocol != 0) {
                addrs[i++] = InetAddress.getByName("::1");
            }
            return addrs;
        }
        catch (UnknownHostException ex) {
            assert (false);
            return null;
        }
        catch (SecurityException ex) {
            SocketException e = new SocketException();
            e.initCause(ex);
            throw e;
        }
    }

    private static InetAddress[] getWildcardAddresses(int protocol) {
        try {
            InetAddress[] addrs = new InetAddress[protocol == 2 ? 2 : 1];
            int i = 0;
            if (protocol != 0) {
                addrs[i++] = InetAddress.getByName("::0");
            }
            if (protocol != 1) {
                addrs[i++] = InetAddress.getByName("0.0.0.0");
            }
            return addrs;
        }
        catch (UnknownHostException ex) {
            assert (false);
            return null;
        }
        catch (SecurityException ex) {
            SocketException e = new SocketException();
            e.initCause(ex);
            throw e;
        }
    }

    public static final class SocketPair {
        public AbstractSelectableChannel source;
        public WritableByteChannel sink;
    }
}

