/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CommunicatorDestroyedException;
import Ice.LocalException;
import IceInternal.EndpointI;
import IceInternal.EndpointI_connectors;
import IceInternal.Instance;
import IceInternal.Network;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.LinkedList;

public class EndpointHostResolver {
    private final Instance _instance;
    private boolean _destroyed;
    private LinkedList<ResolveEntry> _queue = new LinkedList();
    private HelperThread _thread;

    EndpointHostResolver(Instance instance) {
        this._instance = instance;
        this._thread = new HelperThread();
        this._thread.start();
    }

    public synchronized void resolve(String host, int port, EndpointI endpoint, EndpointI_connectors callback) {
        assert (!this._destroyed);
        ResolveEntry entry = new ResolveEntry();
        entry.host = host;
        entry.port = port;
        entry.endpoint = endpoint;
        entry.callback = callback;
        this._queue.add(entry);
        this.notify();
    }

    public synchronized void destroy() {
        assert (!this._destroyed);
        this._destroyed = true;
        this.notify();
    }

    public void joinWithThread() {
        if (this._thread != null) {
            try {
                this._thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            ResolveEntry resolve;
            EndpointHostResolver endpointHostResolver = this;
            synchronized (endpointHostResolver) {
                while (!this._destroyed && this._queue.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this._destroyed) {
                    break;
                }
                resolve = this._queue.removeFirst();
            }
            try {
                resolve.callback.connectors(resolve.endpoint.connectors(Network.getAddresses(resolve.host, resolve.port, this._instance.protocolSupport())));
            }
            catch (LocalException ex) {
                resolve.callback.exception(ex);
            }
        }
        Iterator p = this._queue.iterator();
        while (p.hasNext()) {
            ((ResolveEntry)p.next()).callback.exception(new CommunicatorDestroyedException());
        }
        this._queue.clear();
    }

    private final class HelperThread
    extends Thread {
        HelperThread() {
            String threadName = ((EndpointHostResolver)EndpointHostResolver.this)._instance.initializationData().properties.getProperty("Ice.ProgramName");
            if (threadName.length() > 0) {
                threadName = threadName + "-";
            }
            this.setName(threadName + "Ice.EndpointHostResolverThread");
        }

        public void run() {
            if (((EndpointHostResolver)EndpointHostResolver.this)._instance.initializationData().threadHook != null) {
                ((EndpointHostResolver)EndpointHostResolver.this)._instance.initializationData().threadHook.start();
            }
            try {
                EndpointHostResolver.this.run();
            }
            catch (LocalException ex) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                pw.flush();
                String s = "exception in endpoint host resolver thread " + this.getName() + ":\n" + sw.toString();
                ((EndpointHostResolver)EndpointHostResolver.this)._instance.initializationData().logger.error(s);
            }
            catch (Exception ex) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                pw.flush();
                String s = "unknown exception in endpoint host resolver thread " + this.getName() + ":\n" + sw.toString();
                ((EndpointHostResolver)EndpointHostResolver.this)._instance.initializationData().logger.error(s);
            }
            if (((EndpointHostResolver)EndpointHostResolver.this)._instance.initializationData().threadHook != null) {
                ((EndpointHostResolver)EndpointHostResolver.this)._instance.initializationData().threadHook.stop();
            }
        }
    }

    class ResolveEntry {
        String host;
        int port;
        EndpointI endpoint;
        EndpointI_connectors callback;

        ResolveEntry() {
        }
    }
}

