/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Object;
import Ice.ReadObjectCallback;
import IceInternal.Patcher;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryPatcher<K, V>
implements Patcher,
ReadObjectCallback {
    private Map<K, V> _dict;
    private Class<V> _cls;
    private String _type;
    private K _key;

    public DictionaryPatcher(Map<K, V> dict, Class<V> cls, String type, K key) {
        this._dict = dict;
        this._cls = cls;
        this._type = type;
        this._key = key;
    }

    @Override
    public void patch(Object v) {
        if (v != null && !this._cls.isInstance(v)) {
            throw new ClassCastException("expected element of type " + this._cls.getName() + " but received " + v.getClass().getName());
        }
        this._dict.put(this._key, this._cls.cast(v));
    }

    @Override
    public String type() {
        return this._type;
    }

    @Override
    public void invoke(Object v) {
        this.patch(v);
    }
}

