/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AMISentCallback;
import Ice.ConnectionI;
import Ice.LocalException;
import Ice.MemoryLimitException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.OperationMode;
import Ice._ObjectDelM;
import IceInternal.BasicStream;
import IceInternal.BatchOutgoing;
import IceInternal.BatchOutgoingAsync;
import IceInternal.ConnectionRequestHandler;
import IceInternal.Instance;
import IceInternal.LocalExceptionWrapper;
import IceInternal.Outgoing;
import IceInternal.OutgoingAsync;
import IceInternal.OutgoingAsyncMessageCallback;
import IceInternal.Protocol;
import IceInternal.Reference;
import IceInternal.RequestHandler;
import IceInternal.RouterInfo;
import IceInternal.ThreadPool;
import IceInternal.ThreadPoolWorkItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectRequestHandler
implements RequestHandler,
Reference.GetConnectionCallback,
RouterInfo.AddProxyCallback {
    private final Reference _reference;
    private final boolean _batchAutoFlush;
    private ObjectPrxHelperBase _proxy;
    private _ObjectDelM _delegate;
    private boolean _initialized = false;
    private boolean _flushing = false;
    private ConnectionI _connection = null;
    private boolean _compress = false;
    private boolean _response;
    private LocalException _exception = null;
    private List<Request> _requests = new LinkedList<Request>();
    private boolean _batchRequestInProgress;
    private int _batchRequestsSize;
    private BasicStream _batchStream;
    private boolean _updateRequestHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestHandler connect() {
        this._reference.getConnection(this);
        ConnectRequestHandler connectRequestHandler = this;
        synchronized (connectRequestHandler) {
            if (this.initialized()) {
                assert (this._connection != null);
                return new ConnectionRequestHandler(this._reference, this._connection, this._compress);
            }
            this._updateRequestHandler = true;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareBatchRequest(BasicStream os) {
        ConnectRequestHandler connectRequestHandler = this;
        synchronized (connectRequestHandler) {
            while (this._batchRequestInProgress) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.initialized()) {
                this._batchStream.swap(os);
                this._batchRequestInProgress = true;
                return;
            }
        }
        this._connection.prepareBatchRequest(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishBatchRequest(BasicStream os) {
        ConnectRequestHandler connectRequestHandler = this;
        synchronized (connectRequestHandler) {
            if (!this.initialized()) {
                assert (this._batchRequestInProgress);
                this._batchRequestInProgress = false;
                this.notifyAll();
                this._batchStream.swap(os);
                if (!this._batchAutoFlush && this._batchStream.size() + this._batchRequestsSize > this._reference.getInstance().messageSizeMax()) {
                    throw new MemoryLimitException();
                }
                this._requests.add(new Request(this._batchStream));
                return;
            }
        }
        this._connection.finishBatchRequest(os, this._compress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortBatchRequest() {
        ConnectRequestHandler connectRequestHandler = this;
        synchronized (connectRequestHandler) {
            if (!this.initialized()) {
                assert (this._batchRequestInProgress);
                this._batchRequestInProgress = false;
                this.notifyAll();
                BasicStream dummy = new BasicStream(this._reference.getInstance(), this._batchAutoFlush);
                this._batchStream.swap(dummy);
                this._batchRequestsSize = Protocol.requestBatchHdr.length;
                return;
            }
        }
        this._connection.abortBatchRequest();
    }

    @Override
    public ConnectionI sendRequest(Outgoing out) throws LocalExceptionWrapper {
        if (!this.getConnection(true).sendRequest(out, this._compress, this._response) || this._response) {
            return this._connection;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendAsyncRequest(OutgoingAsync out) throws LocalExceptionWrapper {
        ConnectRequestHandler connectRequestHandler = this;
        synchronized (connectRequestHandler) {
            if (!this.initialized()) {
                this._requests.add(new Request(out));
                return false;
            }
        }
        return this._connection.sendAsyncRequest(out, this._compress, this._response);
    }

    @Override
    public boolean flushBatchRequests(BatchOutgoing out) {
        return this.getConnection(true).flushBatchRequests(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flushAsyncBatchRequests(BatchOutgoingAsync out) {
        ConnectRequestHandler connectRequestHandler = this;
        synchronized (connectRequestHandler) {
            if (!this.initialized()) {
                this._requests.add(new Request(out));
                return false;
            }
        }
        return this._connection.flushAsyncBatchRequests(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Outgoing getOutgoing(String operation, OperationMode mode, Map<String, String> context) throws LocalExceptionWrapper {
        ConnectRequestHandler connectRequestHandler = this;
        synchronized (connectRequestHandler) {
            if (!this.initialized()) {
                return new Outgoing(this, operation, mode, context);
            }
        }
        return this._connection.getOutgoing(this, operation, mode, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reclaimOutgoing(Outgoing out) {
        ConnectRequestHandler connectRequestHandler = this;
        synchronized (connectRequestHandler) {
            if (this._connection == null) {
                return;
            }
        }
        this._connection.reclaimOutgoing(out);
    }

    @Override
    public Reference getReference() {
        return this._reference;
    }

    @Override
    public synchronized ConnectionI getConnection(boolean wait) {
        if (wait) {
            while (!this._initialized && this._exception == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this._exception != null) {
            throw this._exception;
        }
        assert (!wait || this._initialized);
        return this._connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConnection(ConnectionI connection, boolean compress) {
        ConnectRequestHandler connectRequestHandler = this;
        synchronized (connectRequestHandler) {
            assert (this._connection == null && this._exception == null);
            this._connection = connection;
            this._compress = compress;
        }
        RouterInfo ri = this._reference.getRouterInfo();
        if (ri != null && !ri.addProxy(this._proxy, this)) {
            return;
        }
        this.flushRequests();
    }

    @Override
    public synchronized void setException(final LocalException ex) {
        assert (!this._initialized && this._exception == null);
        assert (this._updateRequestHandler || this._requests.isEmpty());
        this._exception = ex;
        this._proxy = null;
        this._delegate = null;
        if (!this._requests.isEmpty()) {
            this._reference.getInstance().clientThreadPool().execute(new ThreadPoolWorkItem(){

                public void execute(ThreadPool threadPool) {
                    threadPool.promoteFollower(null);
                    ConnectRequestHandler.this.flushRequestsWithException(ex);
                }
            });
        }
        this.notifyAll();
    }

    @Override
    public void addedProxy() {
        this.flushRequests();
    }

    public ConnectRequestHandler(Reference ref, ObjectPrx proxy, _ObjectDelM delegate) {
        this._reference = ref;
        this._response = this._reference.getMode() == 0;
        this._proxy = (ObjectPrxHelperBase)proxy;
        this._delegate = delegate;
        this._batchAutoFlush = ref.getInstance().initializationData().properties.getPropertyAsIntWithDefault("Ice.BatchAutoFlush", 1) > 0;
        this._batchStream = new BasicStream(ref.getInstance(), this._batchAutoFlush);
        this._batchRequestInProgress = false;
        this._batchRequestsSize = Protocol.requestBatchHdr.length;
        this._updateRequestHandler = false;
    }

    private boolean initialized() {
        if (this._initialized) {
            assert (this._connection != null);
            return true;
        }
        while (this._flushing && this._exception == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this._exception != null) {
            throw this._exception;
        }
        return this._initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushRequests() {
        ConnectRequestHandler connectRequestHandler = this;
        synchronized (connectRequestHandler) {
            assert (this._connection != null && !this._initialized);
            if (this._batchRequestInProgress) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            this._flushing = true;
        }
        final ArrayList<OutgoingAsyncMessageCallback> sentCallbacks = new ArrayList<OutgoingAsyncMessageCallback>();
        try {
            Iterator<Request> p = this._requests.iterator();
            while (p.hasNext()) {
                Request request = p.next();
                if (request.out != null) {
                    if (this._connection.sendAsyncRequest(request.out, this._compress, this._response) && request.out instanceof AMISentCallback) {
                        sentCallbacks.add(request.out);
                    }
                } else if (request.batchOut != null) {
                    if (this._connection.flushAsyncBatchRequests(request.batchOut) && request.batchOut instanceof AMISentCallback) {
                        sentCallbacks.add(request.batchOut);
                    }
                } else {
                    BasicStream os = new BasicStream(request.os.instance());
                    this._connection.prepareBatchRequest(os);
                    try {
                        request.os.pos(0);
                        os.writeBlob(request.os.readBlob(request.os.size()));
                        this._connection.finishBatchRequest(os, this._compress);
                    }
                    catch (LocalException ex) {
                        this._connection.abortBatchRequest();
                        throw ex;
                    }
                }
                p.remove();
            }
        }
        catch (LocalExceptionWrapper ex) {
            ConnectRequestHandler connectRequestHandler2 = this;
            synchronized (connectRequestHandler2) {
                assert (this._exception == null && !this._requests.isEmpty());
                this._exception = ex.get();
                this._reference.getInstance().clientThreadPool().execute(new ThreadPoolWorkItem(){

                    public void execute(ThreadPool threadPool) {
                        threadPool.promoteFollower(null);
                        ConnectRequestHandler.this.flushRequestsWithException(ex);
                    }
                });
            }
        }
        catch (LocalException ex) {
            ConnectRequestHandler connectRequestHandler3 = this;
            synchronized (connectRequestHandler3) {
                assert (this._exception == null && !this._requests.isEmpty());
                this._exception = ex;
                this._reference.getInstance().clientThreadPool().execute(new ThreadPoolWorkItem(){

                    public void execute(ThreadPool threadPool) {
                        threadPool.promoteFollower(null);
                        ConnectRequestHandler.this.flushRequestsWithException(ex);
                    }
                });
            }
        }
        if (!sentCallbacks.isEmpty()) {
            final Instance instance = this._reference.getInstance();
            instance.clientThreadPool().execute(new ThreadPoolWorkItem(){

                public void execute(ThreadPool threadPool) {
                    threadPool.promoteFollower(null);
                    for (OutgoingAsyncMessageCallback callback : sentCallbacks) {
                        callback.__sent(instance);
                    }
                }
            });
        }
        if (this._updateRequestHandler && this._exception == null) {
            this._proxy.__setRequestHandler(this._delegate, new ConnectionRequestHandler(this._reference, this._connection, this._compress));
        }
        ConnectRequestHandler connectRequestHandler4 = this;
        synchronized (connectRequestHandler4) {
            if (this._exception == null) {
                assert (!this._initialized);
                this._initialized = true;
                this._flushing = false;
            }
            this._proxy = null;
            this._delegate = null;
            this.notifyAll();
        }
    }

    void flushRequestsWithException(LocalException ex) {
        for (Request request : this._requests) {
            if (request.out != null) {
                request.out.__finished(ex);
                continue;
            }
            if (request.batchOut == null) continue;
            request.batchOut.__finished(ex);
        }
        this._requests.clear();
    }

    void flushRequestsWithException(LocalExceptionWrapper ex) {
        for (Request request : this._requests) {
            if (request.out != null) {
                request.out.__finished(ex);
                continue;
            }
            if (request.batchOut == null) continue;
            request.batchOut.__finished(ex.get());
        }
        this._requests.clear();
    }

    static class Request {
        OutgoingAsync out = null;
        BatchOutgoingAsync batchOut = null;
        BasicStream os = null;

        Request(BasicStream os) {
            this.os = new BasicStream(os.instance());
            this.os.swap(os);
        }

        Request(OutgoingAsync out) {
            this.out = out;
        }

        Request(BatchOutgoingAsync out) {
            this.batchOut = out;
        }
    }
}

