/*
 * Decompiled with CFR 0.152.
 */
package IceBox;

import Ice.Current;
import Ice.DispatchStatus;
import Ice.InputStream;
import Ice.MarshalException;
import Ice.Object;
import Ice.ObjectImpl;
import Ice.OperationMode;
import Ice.OperationNotExistException;
import Ice.OutputStream;
import Ice.SliceChecksumDictHelper;
import IceBox.AlreadyStartedException;
import IceBox.AlreadyStoppedException;
import IceBox.NoSuchServiceException;
import IceBox.ServiceManager;
import IceBox.ServiceObserverPrx;
import IceBox.ServiceObserverPrxHelper;
import IceInternal.BasicStream;
import IceInternal.Incoming;
import java.util.Arrays;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class _ServiceManagerDisp
extends ObjectImpl
implements ServiceManager {
    public static final String[] __ids = new String[]{"::Ice::Object", "::IceBox::ServiceManager"};
    private static final String[] __all = new String[]{"addObserver", "getSliceChecksums", "ice_id", "ice_ids", "ice_isA", "ice_ping", "shutdown", "startService", "stopService"};

    protected void ice_copyStateFrom(Object __obj) throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public boolean ice_isA(String s) {
        return Arrays.binarySearch(__ids, s) >= 0;
    }

    @Override
    public boolean ice_isA(String s, Current __current) {
        return Arrays.binarySearch(__ids, s) >= 0;
    }

    @Override
    public String[] ice_ids() {
        return __ids;
    }

    @Override
    public String[] ice_ids(Current __current) {
        return __ids;
    }

    @Override
    public String ice_id() {
        return __ids[1];
    }

    @Override
    public String ice_id(Current __current) {
        return __ids[1];
    }

    public static String ice_staticId() {
        return __ids[1];
    }

    @Override
    public final void addObserver(ServiceObserverPrx observer) {
        this.addObserver(observer, null);
    }

    @Override
    public final Map<String, String> getSliceChecksums() {
        return this.getSliceChecksums(null);
    }

    @Override
    public final void shutdown() {
        this.shutdown(null);
    }

    @Override
    public final void startService(String service) throws AlreadyStartedException, NoSuchServiceException {
        this.startService(service, null);
    }

    @Override
    public final void stopService(String service) throws AlreadyStoppedException, NoSuchServiceException {
        this.stopService(service, null);
    }

    public static DispatchStatus ___getSliceChecksums(ServiceManager __obj, Incoming __inS, Current __current) {
        _ServiceManagerDisp.__checkMode(OperationMode.Idempotent, __current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        Map<String, String> __ret = __obj.getSliceChecksums(__current);
        SliceChecksumDictHelper.write(__os, __ret);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___startService(ServiceManager __obj, Incoming __inS, Current __current) {
        _ServiceManagerDisp.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String service = __is.readString();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        try {
            __obj.startService(service, __current);
            return DispatchStatus.DispatchOK;
        }
        catch (AlreadyStartedException ex) {
            __os.writeUserException(ex);
            return DispatchStatus.DispatchUserException;
        }
        catch (NoSuchServiceException ex) {
            __os.writeUserException(ex);
            return DispatchStatus.DispatchUserException;
        }
    }

    public static DispatchStatus ___stopService(ServiceManager __obj, Incoming __inS, Current __current) {
        _ServiceManagerDisp.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String service = __is.readString();
        __is.endReadEncaps();
        BasicStream __os = __inS.os();
        try {
            __obj.stopService(service, __current);
            return DispatchStatus.DispatchOK;
        }
        catch (AlreadyStoppedException ex) {
            __os.writeUserException(ex);
            return DispatchStatus.DispatchUserException;
        }
        catch (NoSuchServiceException ex) {
            __os.writeUserException(ex);
            return DispatchStatus.DispatchUserException;
        }
    }

    public static DispatchStatus ___addObserver(ServiceManager __obj, Incoming __inS, Current __current) {
        _ServiceManagerDisp.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        ServiceObserverPrx observer = ServiceObserverPrxHelper.__read(__is);
        __is.endReadEncaps();
        __obj.addObserver(observer, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___shutdown(ServiceManager __obj, Incoming __inS, Current __current) {
        _ServiceManagerDisp.__checkMode(OperationMode.Normal, __current.mode);
        __inS.is().skipEmptyEncaps();
        __obj.shutdown(__current);
        return DispatchStatus.DispatchOK;
    }

    @Override
    public DispatchStatus __dispatch(Incoming in, Current __current) {
        int pos = Arrays.binarySearch(__all, __current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(__current.id, __current.facet, __current.operation);
        }
        switch (pos) {
            case 0: {
                return _ServiceManagerDisp.___addObserver(this, in, __current);
            }
            case 1: {
                return _ServiceManagerDisp.___getSliceChecksums(this, in, __current);
            }
            case 2: {
                return _ServiceManagerDisp.___ice_id(this, in, __current);
            }
            case 3: {
                return _ServiceManagerDisp.___ice_ids(this, in, __current);
            }
            case 4: {
                return _ServiceManagerDisp.___ice_isA(this, in, __current);
            }
            case 5: {
                return _ServiceManagerDisp.___ice_ping(this, in, __current);
            }
            case 6: {
                return _ServiceManagerDisp.___shutdown(this, in, __current);
            }
            case 7: {
                return _ServiceManagerDisp.___startService(this, in, __current);
            }
            case 8: {
                return _ServiceManagerDisp.___stopService(this, in, __current);
            }
        }
        assert (false);
        throw new OperationNotExistException(__current.id, __current.facet, __current.operation);
    }

    @Override
    public void __write(BasicStream __os) {
        __os.writeTypeId(_ServiceManagerDisp.ice_staticId());
        __os.startWriteSlice();
        __os.endWriteSlice();
        super.__write(__os);
    }

    @Override
    public void __read(BasicStream __is, boolean __rid) {
        if (__rid) {
            __is.readTypeId();
        }
        __is.startReadSlice();
        __is.endReadSlice();
        super.__read(__is, true);
    }

    @Override
    public void __write(OutputStream __outS) {
        MarshalException ex = new MarshalException();
        ex.reason = "type IceBox::ServiceManager was not generated with stream support";
        throw ex;
    }

    @Override
    public void __read(InputStream __inS, boolean __rid) {
        MarshalException ex = new MarshalException();
        ex.reason = "type IceBox::ServiceManager was not generated with stream support";
        throw ex;
    }
}

