/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.Communicator;
import Ice.NegativeSizeException;
import Ice.Object;
import Ice.ObjectPrx;
import Ice.OutputStream;
import Ice.UserException;
import Ice.Util;
import IceInternal.BasicStream;
import IceInternal.Buffer;
import java.io.Serializable;

public class OutputStreamI
implements OutputStream {
    private Communicator _communicator;
    private BasicStream _os;

    public OutputStreamI(Communicator communicator) {
        this(communicator, new BasicStream(Util.getInstance(communicator)));
    }

    public OutputStreamI(Communicator communicator, BasicStream os) {
        this._communicator = communicator;
        this._os = os;
        this._os.closure(this);
    }

    public Communicator communicator() {
        return this._communicator;
    }

    public void writeBool(boolean v) {
        this._os.writeBool(v);
    }

    public void writeBoolSeq(boolean[] v) {
        this._os.writeBoolSeq(v);
    }

    public void writeByte(byte v) {
        this._os.writeByte(v);
    }

    public void writeByteSeq(byte[] v) {
        this._os.writeByteSeq(v);
    }

    public void writeSerializable(Serializable v) {
        this._os.writeSerializable(v);
    }

    public void writeShort(short v) {
        this._os.writeShort(v);
    }

    public void writeShortSeq(short[] v) {
        this._os.writeShortSeq(v);
    }

    public void writeInt(int v) {
        this._os.writeInt(v);
    }

    public void writeIntSeq(int[] v) {
        this._os.writeIntSeq(v);
    }

    public void writeLong(long v) {
        this._os.writeLong(v);
    }

    public void writeLongSeq(long[] v) {
        this._os.writeLongSeq(v);
    }

    public void writeFloat(float v) {
        this._os.writeFloat(v);
    }

    public void writeFloatSeq(float[] v) {
        this._os.writeFloatSeq(v);
    }

    public void writeDouble(double v) {
        this._os.writeDouble(v);
    }

    public void writeDoubleSeq(double[] v) {
        this._os.writeDoubleSeq(v);
    }

    public void writeString(String v) {
        this._os.writeString(v);
    }

    public void writeStringSeq(String[] v) {
        this._os.writeStringSeq(v);
    }

    public void writeSize(int sz) {
        if (sz < 0) {
            throw new NegativeSizeException();
        }
        this._os.writeSize(sz);
    }

    public void writeProxy(ObjectPrx v) {
        this._os.writeProxy(v);
    }

    public void writeObject(Object v) {
        this._os.writeObject(v);
    }

    public void writeTypeId(String id) {
        this._os.writeTypeId(id);
    }

    public void writeException(UserException v) {
        this._os.writeUserException(v);
    }

    public void startSlice() {
        this._os.startWriteSlice();
    }

    public void endSlice() {
        this._os.endWriteSlice();
    }

    public void startEncapsulation() {
        this._os.startWriteEncaps();
    }

    public void endEncapsulation() {
        this._os.endWriteEncapsChecked();
    }

    public void writePendingObjects() {
        this._os.writePendingObjects();
    }

    public byte[] finished() {
        Buffer buf = this._os.prepareWrite();
        byte[] result = new byte[buf.b.limit()];
        buf.b.get(result);
        return result;
    }

    public void destroy() {
        if (this._os != null) {
            this._os = null;
        }
    }
}

