/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import Freeze.DatabaseException;
import Freeze.EvictorI;
import Freeze.Index;
import Freeze.LinkedList;
import Freeze.NotFoundException;
import Freeze.ObjectRecord;
import Freeze.ObjectStore;
import Freeze.ServantInitializer;
import Freeze.Statistics;
import Freeze.Transaction;
import Freeze.TransactionI;
import Freeze.TransactionalEvictor;
import Freeze.TransactionalEvictorContext;
import Ice.AlreadyRegisteredException;
import Ice.Current;
import Ice.DispatchInterceptor;
import Ice.DispatchStatus;
import Ice.FacetNotExistException;
import Ice.Identity;
import Ice.LocalObjectHolder;
import Ice.NotRegisteredException;
import Ice.ObjectAdapter;
import Ice.ObjectNotExistException;
import Ice.ObjectPrx;
import Ice.Request;
import IceInternal.Time;
import IceUtilInternal.StringUtil;
import com.sleepycat.db.Environment;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class TransactionalEvictorI
extends EvictorI
implements TransactionalEvictor {
    static final int supports = 0;
    static final int mandatory = 1;
    static final int required = 2;
    static final int never = 3;
    private final LinkedList _evictorList = new LinkedList();
    private int _currentEvictorSize = 0;
    private DispatchInterceptor _interceptor = new DispatchInterceptor(){

        public DispatchStatus dispatch(Request request) {
            return TransactionalEvictorI.this.dispatch(request);
        }
    };
    private boolean _rollbackOnUserException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction getCurrentTransaction() {
        this._deactivateController.lock();
        try {
            TransactionalEvictorContext ctx = this._dbEnv.getCurrent();
            TransactionI transactionI = ctx == null ? null : ctx.transaction();
            Object var4_3 = null;
            this._deactivateController.unlock();
            return transactionI;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._deactivateController.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentTransaction(Transaction tx) {
        this._deactivateController.lock();
        try {
            this._dbEnv.setCurrentTransaction(tx);
            Object var3_2 = null;
            this._deactivateController.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._deactivateController.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectPrx addFacet(Ice.Object servant, Identity ident, String facet) {
        TransactionalEvictorI.checkIdentity(ident);
        if (facet == null) {
            facet = "";
        }
        this._deactivateController.lock();
        try {
            long currentTime = Time.currentMonotonicTimeMillis();
            ObjectRecord rec = new ObjectRecord(servant, new Statistics(currentTime, 0L, 0L));
            ObjectStore store = this.findStore(facet, this._createDb);
            if (store == null) {
                NotFoundException ex = new NotFoundException();
                ex.message = this._errorPrefix + "addFacet: could not open database for facet '" + facet + "'";
                throw ex;
            }
            TransactionI tx = this.beforeQuery();
            TransactionalEvictorI.updateStats(rec.stats, currentTime);
            if (!store.insert(ident, rec, tx)) {
                AlreadyRegisteredException ex = new AlreadyRegisteredException();
                ex.kindOfObject = "servant";
                ex.id = this._communicator.identityToString(ident);
                if (facet.length() > 0) {
                    ex.id = ex.id + " -f " + StringUtil.escapeString(facet, "");
                }
                throw ex;
            }
            if (this._trace >= 1) {
                String objString = "object \"" + this._communicator.identityToString(ident) + "\"";
                if (!facet.equals("")) {
                    objString = objString + " with facet \"" + facet + "\"";
                }
                this._communicator.getLogger().trace("Freeze.Evictor", "added " + objString + " to Db \"" + this._filename + "\"");
            }
            ObjectPrx obj = this._adapter.createProxy(ident);
            if (facet.length() > 0) {
                obj = obj.ice_facet(facet);
            }
            ObjectPrx objectPrx = obj;
            Object var12_12 = null;
            this._deactivateController.unlock();
            return objectPrx;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this._deactivateController.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ice.Object removeFacet(Identity ident, String facet) {
        TransactionalEvictorI.checkIdentity(ident);
        if (facet == null) {
            facet = "";
        }
        this._deactivateController.lock();
        try {
            Ice.Object servant = null;
            boolean removed = false;
            ObjectStore store = this.findStore(facet, false);
            if (store != null) {
                TransactionalEvictorContext ctx = this._dbEnv.getCurrent();
                TransactionI tx = null;
                if (ctx != null && (tx = ctx.transaction()) == null) {
                    throw new DatabaseException(this._errorPrefix + "inactive transaction");
                }
                removed = store.remove(ident, tx);
                if (removed) {
                    servant = ctx != null ? ctx.servantRemoved(ident, store) : this.evict(ident, store);
                }
            }
            if (!removed) {
                NotRegisteredException ex = new NotRegisteredException();
                ex.kindOfObject = "servant";
                ex.id = this._communicator.identityToString(ident);
                if (facet.length() > 0) {
                    ex.id = ex.id + " -f " + StringUtil.escapeString(facet, "");
                }
                throw ex;
            }
            if (this._trace >= 1) {
                String objString = "object \"" + this._communicator.identityToString(ident) + "\"";
                if (!facet.equals("")) {
                    objString = objString + " with facet \"" + facet + "\"";
                }
                this._communicator.getLogger().trace("Freeze.Evictor", "removed " + objString + " from Db \"" + this._filename + "\"");
            }
            Ice.Object object = servant;
            Object var9_8 = null;
            this._deactivateController.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this._deactivateController.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFacet(Identity ident, String facet) {
        TransactionI tx;
        ObjectStore store;
        block7: {
            block8: {
                block6: {
                    TransactionalEvictorI.checkIdentity(ident);
                    if (facet == null) {
                        facet = "";
                    }
                    this._deactivateController.lock();
                    try {
                        store = this.findStore(facet, false);
                        if (store != null) break block6;
                        boolean bl = false;
                        Object var8_6 = null;
                        this._deactivateController.unlock();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        this._deactivateController.unlock();
                        throw throwable;
                    }
                }
                tx = this.beforeQuery();
                if (tx != null) break block7;
                EvictorElement element = (EvictorElement)store.cache().getIfPinned(ident);
                if (element == null) break block8;
                boolean bl = true;
                Object var8_7 = null;
                this._deactivateController.unlock();
                return bl;
            }
            boolean bl = store.dbHasObject(ident, null);
            Object var8_8 = null;
            this._deactivateController.unlock();
            return bl;
        }
        boolean bl = store.dbHasObject(ident, tx);
        Object var8_9 = null;
        this._deactivateController.unlock();
        return bl;
    }

    public void finished(Current current, Ice.Object servant, Object cookieObj) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(String category) {
        if (this._deactivateController.deactivate()) {
            TransactionalEvictorI transactionalEvictorI = this;
            synchronized (transactionalEvictorI) {
                this._evictorSize = 0;
                this.evict();
            }
            try {
                this.closeDbEnv();
                Object var5_4 = null;
                this._deactivateController.deactivationComplete();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this._deactivateController.deactivationComplete();
                throw throwable;
            }
        }
    }

    TransactionalEvictorI(ObjectAdapter adapter, String envName, Environment dbEnv, String filename, Map facetTypes, ServantInitializer initializer, Index[] indices, boolean createDb) {
        super(adapter, envName, dbEnv, filename, facetTypes, initializer, indices, createDb);
        String propertyPrefix = "Freeze.Evictor." + envName + '.' + filename;
        this._rollbackOnUserException = this._communicator.getProperties().getPropertyAsIntWithDefault(propertyPrefix + ".RollbackOnUserException", 0) != 0;
    }

    TransactionalEvictorI(ObjectAdapter adapter, String envName, String filename, Map facetTypes, ServantInitializer initializer, Index[] indices, boolean createDb) {
        this(adapter, envName, null, filename, facetTypes, initializer, indices, createDb);
    }

    /*
     * Exception decompiling
     */
    DispatchStatus dispatch(Request request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    synchronized Ice.Object evict(Identity ident, ObjectStore store) {
        EvictorElement element = (EvictorElement)store.cache().unpin(ident);
        if (element != null) {
            element.evict(false);
            return element.servant;
        }
        return null;
    }

    protected Object createEvictorElement(Identity ident, ObjectRecord rec, ObjectStore store) {
        return new EvictorElement(rec.servant, ident, store);
    }

    protected Ice.Object locateImpl(Current current, LocalObjectHolder cookie) {
        return this._interceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasAnotherFacet(Identity ident, String facet) {
        boolean bl;
        block7: {
            boolean bl2;
            block6: {
                this._deactivateController.lock();
                try {
                    HashMap storeMapCopy;
                    TransactionalEvictorI transactionalEvictorI = this;
                    synchronized (transactionalEvictorI) {
                        storeMapCopy = new HashMap(this._storeMap);
                    }
                    TransactionI tx = this.beforeQuery();
                    for (Map.Entry entry : storeMapCopy.entrySet()) {
                        if (facet.equals(entry.getKey())) continue;
                        ObjectStore store = (ObjectStore)entry.getValue();
                        if (tx == null && store.cache().getIfPinned(ident) != null) {
                            boolean bl3 = true;
                            Object var10_11 = null;
                            this._deactivateController.unlock();
                            return bl3;
                        }
                        if (!store.dbHasObject(ident, tx)) continue;
                        bl2 = true;
                        break block6;
                    }
                    bl = false;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    this._deactivateController.unlock();
                    throw throwable;
                }
            }
            Object var10_12 = null;
            this._deactivateController.unlock();
            return bl2;
        }
        Object var10_13 = null;
        this._deactivateController.unlock();
        return bl;
    }

    protected void evict() {
        assert (Thread.holdsLock(this));
        while (this._currentEvictorSize > this._evictorSize) {
            EvictorElement element = (EvictorElement)this._evictorList.getLast();
            element.evict(true);
        }
    }

    protected TransactionI beforeQuery() {
        TransactionalEvictorContext ctx = this._dbEnv.getCurrent();
        TransactionI tx = null;
        if (ctx != null && (tx = ctx.transaction()) == null) {
            throw new DatabaseException(this._errorPrefix + "inactive transaction");
        }
        return tx;
    }

    private void servantNotFound(Current current) {
        if (this._trace >= 2) {
            this._communicator.getLogger().trace("Freeze.Evictor", "could not find \"" + this._communicator.identityToString(current.id) + "\" with facet \"" + current.facet + "\"");
        }
        if (this.hasAnotherFacet(current.id, current.facet)) {
            throw new FacetNotExistException(current.id, current.facet, current.operation);
        }
        throw new ObjectNotExistException(current.id, current.facet, current.operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Ice.Object loadCachedServant(Identity ident, ObjectStore store) {
        EvictorElement element;
        while (true) {
            if ((element = (EvictorElement)store.cache().pin(ident)) == null) {
                return null;
            }
            TransactionalEvictorI transactionalEvictorI = this;
            synchronized (transactionalEvictorI) {
                if (!element.stale) break;
            }
        }
        {
            element.fixEvictPosition();
            this.evict();
            if (this._trace >= 3) {
                this._communicator.getLogger().trace("Freeze.Evictor", "loaded \"" + this._communicator.identityToString(ident) + "\" with facet \"" + store.facet() + "\" into the cache");
            }
            return element.servant;
        }
    }

    private class EvictorElement {
        final Ice.Object servant;
        boolean stale = false;
        private Iterator _evictPosition;
        private final ObjectStore _store;
        private final Identity _identity;

        EvictorElement(Ice.Object servant, Identity identity, ObjectStore store) {
            this.servant = servant;
            this._identity = identity;
            this._store = store;
        }

        void evict(boolean unpin) {
            assert (Thread.holdsLock(TransactionalEvictorI.this));
            assert (!this.stale);
            this.stale = true;
            if (unpin) {
                this._store.cache().unpin(this._identity);
            }
            if (this._evictPosition != null) {
                this._evictPosition.remove();
                this._evictPosition = null;
                TransactionalEvictorI.this._currentEvictorSize--;
            } else assert (!unpin);
        }

        void fixEvictPosition() {
            assert (Thread.holdsLock(TransactionalEvictorI.this));
            assert (!this.stale);
            if (this._evictPosition == null) {
                TransactionalEvictorI.this._currentEvictorSize++;
            } else {
                this._evictPosition.remove();
            }
            TransactionalEvictorI.this._evictorList.addFirst(this);
            this._evictPosition = TransactionalEvictorI.this._evictorList.iterator();
            this._evictPosition.next();
        }
    }
}

