/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineRandomAccessible;

public class ConstantAffineRandomAccessible<T, R extends AffineGet>
extends AffineRandomAccessible<T, R> {
    protected final double[][] ds;
    protected final double[] affine;

    public ConstantAffineRandomAccessible(RealRandomAccessible<T> target, R transform) {
        super(target, transform);
        this.affine = transform.getRowPackedCopy();
        this.ds = new double[transform.numSourceDimensions()][];
        int r = 0;
        while (r < this.ds.length) {
            double[] d = new double[this.ds.length];
            transform.d(r).localize(d);
            this.ds[r] = d;
            ++r;
        }
    }

    @Override
    public ConstantAffineRandomAccess randomAccess() {
        return new ConstantAffineRandomAccess();
    }

    @Override
    public ConstantAffineRandomAccess randomAccess(Interval interval) {
        return this.randomAccess();
    }

    public class ConstantAffineRandomAccess
    extends AffineRandomAccessible.AffineRandomAccess {
        protected ConstantAffineRandomAccess() {
            super(ConstantAffineRandomAccessible.this);
        }

        @Override
        public void setPosition(long[] pos) {
            assert (pos.length >= this.n) : "source and target dimensios do not match";
            int r = 0;
            int i = 0;
            while (r < this.n) {
                this.position[r] = pos[r];
                double ar = ConstantAffineRandomAccessible.this.affine[i++] * (double)pos[0];
                int c = 1;
                while (c < this.n) {
                    ar += ConstantAffineRandomAccessible.this.affine[i] * (double)pos[c];
                    ++c;
                    ++i;
                }
                this.targetAccess.setPosition(ar + ConstantAffineRandomAccessible.this.affine[i], r);
                ++r;
                ++i;
            }
        }

        @Override
        public void setPosition(int[] pos) {
            assert (pos.length >= this.n) : "source and target dimensios do not match";
            int r = 0;
            int i = 0;
            while (r < this.n) {
                this.position[r] = pos[r];
                double ar = ConstantAffineRandomAccessible.this.affine[i++] * (double)pos[0];
                int c = 1;
                while (c < this.n) {
                    ar += ConstantAffineRandomAccessible.this.affine[i] * (double)pos[c];
                    ++c;
                    ++i;
                }
                this.targetAccess.setPosition(ar + ConstantAffineRandomAccessible.this.affine[i], r);
                ++r;
                ++i;
            }
        }

        @Override
        public void setPosition(Localizable pos) {
            assert (pos.numDimensions() >= this.n) : "source and target dimensios do not match";
            int r = 0;
            int i = 0;
            while (r < this.n) {
                this.position[r] = pos.getLongPosition(r);
                double ar = ConstantAffineRandomAccessible.this.affine[i++] * (double)pos.getLongPosition(0);
                int c = 1;
                while (c < this.n) {
                    ar += ConstantAffineRandomAccessible.this.affine[i] * (double)pos.getLongPosition(c);
                    ++c;
                    ++i;
                }
                this.targetAccess.setPosition(ar + ConstantAffineRandomAccessible.this.affine[i], r);
                ++r;
                ++i;
            }
        }

        @Override
        protected void scaleMove(double distance, int d) {
            double[] dd = ConstantAffineRandomAccessible.this.ds[d];
            int ddd = 0;
            while (ddd < this.n) {
                this.move[ddd] = distance * dd[ddd];
                ++ddd;
            }
        }

        @Override
        public void fwd(int d) {
            int n = d;
            this.position[n] = this.position[n] + 1L;
            this.targetAccess.move(ConstantAffineRandomAccessible.this.ds[d]);
        }

        @Override
        public ConstantAffineRandomAccess copy() {
            return new ConstantAffineRandomAccess();
        }

        @Override
        public ConstantAffineRandomAccess copyRandomAccess() {
            return this.copy();
        }
    }
}

