/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.concatenate.Concatenable;
import net.imglib2.concatenate.PreConcatenable;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineSet;

public class AffineTransform3D
implements AffineGet,
AffineSet,
Concatenable<AffineGet>,
PreConcatenable<AffineGet> {
    protected final AffineMatrix3D a;
    protected final RealPoint d0;
    protected final RealPoint d1;
    protected final RealPoint d2;
    protected final RealPoint[] ds;
    protected final AffineTransform3D inverse;

    public AffineTransform3D() {
        this(new AffineMatrix3D());
    }

    protected AffineTransform3D(AffineMatrix3D a) {
        this.a = a;
        this.d0 = new RealPoint(3);
        this.d1 = new RealPoint(3);
        this.d2 = new RealPoint(3);
        this.ds = new RealPoint[]{this.d0, this.d1, this.d2};
        this.updateDs();
        this.inverse = new AffineTransform3D(this);
        this.invert();
        this.inverse.updateDs();
    }

    protected AffineTransform3D(AffineTransform3D inverse) {
        this.inverse = inverse;
        this.a = new AffineMatrix3D();
        this.d0 = new RealPoint(3);
        this.d1 = new RealPoint(3);
        this.d2 = new RealPoint(3);
        this.ds = new RealPoint[]{this.d0, this.d1, this.d2};
    }

    protected void invert() {
        double det = this.a.det();
        if (det == 0.0) {
            throw new RuntimeException("Matrix is singular.");
        }
        double idet = 1.0 / det;
        this.inverse.a.m00 = (this.a.m11 * this.a.m22 - this.a.m12 * this.a.m21) * idet;
        this.inverse.a.m01 = (this.a.m02 * this.a.m21 - this.a.m01 * this.a.m22) * idet;
        this.inverse.a.m02 = (this.a.m01 * this.a.m12 - this.a.m02 * this.a.m11) * idet;
        this.inverse.a.m10 = (this.a.m12 * this.a.m20 - this.a.m10 * this.a.m22) * idet;
        this.inverse.a.m11 = (this.a.m00 * this.a.m22 - this.a.m02 * this.a.m20) * idet;
        this.inverse.a.m12 = (this.a.m02 * this.a.m10 - this.a.m00 * this.a.m12) * idet;
        this.inverse.a.m20 = (this.a.m10 * this.a.m21 - this.a.m11 * this.a.m20) * idet;
        this.inverse.a.m21 = (this.a.m01 * this.a.m20 - this.a.m00 * this.a.m21) * idet;
        this.inverse.a.m22 = (this.a.m00 * this.a.m11 - this.a.m01 * this.a.m10) * idet;
        this.inverse.a.m03 = -this.inverse.a.m00 * this.a.m03 - this.inverse.a.m01 * this.a.m13 - this.inverse.a.m02 * this.a.m23;
        this.inverse.a.m13 = -this.inverse.a.m10 * this.a.m03 - this.inverse.a.m11 * this.a.m13 - this.inverse.a.m12 * this.a.m23;
        this.inverse.a.m23 = -this.inverse.a.m20 * this.a.m03 - this.inverse.a.m21 * this.a.m13 - this.inverse.a.m22 * this.a.m23;
    }

    protected void updateDs() {
        this.d0.setPosition(this.a.m00, 0);
        this.d0.setPosition(this.a.m10, 1);
        this.d0.setPosition(this.a.m20, 2);
        this.d1.setPosition(this.a.m01, 0);
        this.d1.setPosition(this.a.m11, 1);
        this.d1.setPosition(this.a.m21, 2);
        this.d2.setPosition(this.a.m02, 0);
        this.d2.setPosition(this.a.m12, 1);
        this.d2.setPosition(this.a.m22, 2);
    }

    @Override
    public final void apply(double[] source, double[] target) {
        assert (source.length >= 3 && target.length >= 3) : "3d affine transformations can be applied to 3d coordinates only.";
        target[0] = source[0] * this.a.m00 + source[1] * this.a.m01 + source[2] * this.a.m02 + this.a.m03;
        target[1] = source[0] * this.a.m10 + source[1] * this.a.m11 + source[2] * this.a.m12 + this.a.m13;
        target[2] = source[0] * this.a.m20 + source[1] * this.a.m21 + source[2] * this.a.m22 + this.a.m23;
    }

    @Override
    public void apply(float[] source, float[] target) {
        assert (source.length >= 3 && target.length >= 3) : "3d affine transformations can be applied to 3d coordinates only.";
        target[0] = (float)((double)source[0] * this.a.m00 + (double)source[1] * this.a.m01 + (double)source[2] * this.a.m02 + this.a.m03);
        target[1] = (float)((double)source[0] * this.a.m10 + (double)source[1] * this.a.m11 + (double)source[2] * this.a.m12 + this.a.m13);
        target[2] = (float)((double)source[0] * this.a.m20 + (double)source[1] * this.a.m21 + (double)source[2] * this.a.m22 + this.a.m23);
    }

    @Override
    public void apply(RealLocalizable source, RealPositionable target) {
        assert (source.numDimensions() >= 3 && target.numDimensions() >= 3) : "3d affine transformations can be applied to 3d coordinates only.";
        target.setPosition(source.getDoublePosition(0) * this.a.m00 + source.getDoublePosition(1) * this.a.m01 + source.getDoublePosition(2) * this.a.m02 + this.a.m03, 0);
        target.setPosition(source.getDoublePosition(0) * this.a.m10 + source.getDoublePosition(1) * this.a.m11 + source.getDoublePosition(2) * this.a.m12 + this.a.m13, 1);
        target.setPosition(source.getDoublePosition(0) * this.a.m20 + source.getDoublePosition(1) * this.a.m21 + source.getDoublePosition(2) * this.a.m22 + this.a.m23, 2);
    }

    @Override
    public final void applyInverse(double[] source, double[] target) {
        assert (source.length >= 3 && target.length >= 3) : "3d affine transformations can be applied to 3d coordinates only.";
        source[0] = target[0] * this.inverse.a.m00 + target[1] * this.inverse.a.m01 + target[2] * this.inverse.a.m02 + this.inverse.a.m03;
        source[1] = target[0] * this.inverse.a.m10 + target[1] * this.inverse.a.m11 + target[2] * this.inverse.a.m12 + this.inverse.a.m13;
        source[2] = target[0] * this.inverse.a.m20 + target[1] * this.inverse.a.m21 + target[2] * this.inverse.a.m22 + this.inverse.a.m23;
    }

    @Override
    public void applyInverse(float[] source, float[] target) {
        assert (source.length >= 3 && target.length >= 3) : "3d affine transformations can be applied to 3d coordinates only.";
        source[0] = (float)((double)target[0] * this.inverse.a.m00 + (double)target[1] * this.inverse.a.m01 + (double)target[2] * this.inverse.a.m02 + this.inverse.a.m03);
        source[1] = (float)((double)target[0] * this.inverse.a.m10 + (double)target[1] * this.inverse.a.m11 + (double)target[2] * this.inverse.a.m12 + this.inverse.a.m13);
        source[2] = (float)((double)target[0] * this.inverse.a.m20 + (double)target[1] * this.inverse.a.m21 + (double)target[2] * this.inverse.a.m22 + this.inverse.a.m23);
    }

    @Override
    public void applyInverse(RealPositionable source, RealLocalizable target) {
        assert (source.numDimensions() >= 3 && target.numDimensions() >= 3) : "3d affine transformations can be applied to 3d coordinates only.";
        source.setPosition(target.getDoublePosition(0) * this.inverse.a.m00 + target.getDoublePosition(1) * this.inverse.a.m01 + target.getDoublePosition(2) * this.inverse.a.m02 + this.inverse.a.m03, 0);
        source.setPosition(target.getDoublePosition(0) * this.inverse.a.m10 + target.getDoublePosition(1) * this.inverse.a.m11 + target.getDoublePosition(2) * this.inverse.a.m12 + this.inverse.a.m13, 1);
        source.setPosition(target.getDoublePosition(0) * this.inverse.a.m20 + target.getDoublePosition(1) * this.inverse.a.m21 + target.getDoublePosition(2) * this.inverse.a.m22 + this.inverse.a.m23, 2);
    }

    public final AffineTransform3D concatenate(AffineGet affine) {
        assert (affine.numSourceDimensions() >= 3) : "Only >=3d affine transformations can be concatenated to a 3d affine transformation.";
        this.a.concatenate(new AffineMatrix3D(affine.getRowPackedCopy()));
        this.invert();
        this.updateDs();
        this.inverse.updateDs();
        return this;
    }

    public final AffineTransform3D concatenate(AffineTransform3D affine) {
        this.a.concatenate(affine.a);
        this.invert();
        this.updateDs();
        this.inverse.updateDs();
        return this;
    }

    public AffineTransform3D copy() {
        AffineMatrix3D ma = new AffineMatrix3D();
        ma.m00 = this.a.m00;
        ma.m10 = this.a.m10;
        ma.m20 = this.a.m20;
        ma.m01 = this.a.m01;
        ma.m11 = this.a.m11;
        ma.m21 = this.a.m21;
        ma.m02 = this.a.m02;
        ma.m12 = this.a.m12;
        ma.m22 = this.a.m22;
        ma.m03 = this.a.m03;
        ma.m13 = this.a.m13;
        ma.m23 = this.a.m23;
        return new AffineTransform3D(ma);
    }

    @Override
    public RealLocalizable d(int d) {
        return this.ds[d];
    }

    @Override
    public double get(int row, int column) {
        assert (row >= 0 && row < 3 && column >= 0 && column < 4) : "Index out of bounds, a 3d affine matrix is a 3x4 matrix.";
        switch (row) {
            case 0: {
                switch (column) {
                    case 0: {
                        return this.a.m00;
                    }
                    case 1: {
                        return this.a.m01;
                    }
                    case 2: {
                        return this.a.m02;
                    }
                }
                return this.a.m03;
            }
            case 1: {
                switch (column) {
                    case 0: {
                        return this.a.m10;
                    }
                    case 1: {
                        return this.a.m11;
                    }
                    case 2: {
                        return this.a.m12;
                    }
                }
                return this.a.m13;
            }
        }
        switch (column) {
            case 0: {
                return this.a.m20;
            }
            case 1: {
                return this.a.m21;
            }
            case 2: {
                return this.a.m22;
            }
        }
        return this.a.m23;
    }

    @Override
    public double[] getRowPackedCopy() {
        return new double[]{this.a.m00, this.a.m01, this.a.m02, this.a.m03, this.a.m10, this.a.m11, this.a.m12, this.a.m13, this.a.m20, this.a.m21, this.a.m22, this.a.m23};
    }

    @Override
    public Class<AffineGet> getConcatenableClass() {
        return AffineGet.class;
    }

    @Override
    public Class<AffineGet> getPreConcatenableClass() {
        return AffineGet.class;
    }

    @Override
    public AffineTransform3D inverse() {
        return this.inverse;
    }

    @Override
    public AffineTransform3D inverseAffine() {
        return this.inverse();
    }

    @Override
    public int numSourceDimensions() {
        return 3;
    }

    @Override
    public int numTargetDimensions() {
        return 3;
    }

    public final AffineTransform3D preConcatenate(AffineGet affine) {
        assert (affine.numSourceDimensions() >= 3) : "Only >=3d affine transformations can be preconcatenated to a 3d affine transformation.";
        this.a.preConcatenate(new AffineMatrix3D(affine.getRowPackedCopy()));
        this.invert();
        this.updateDs();
        this.inverse.updateDs();
        return this;
    }

    public final AffineTransform3D preConcatenate(AffineTransform3D affine) {
        this.a.preConcatenate(affine.a);
        this.invert();
        this.updateDs();
        this.inverse.updateDs();
        return this;
    }

    public void rotate(int axis, double d) {
        double dcos = Math.cos(d);
        double dsin = Math.sin(d);
        AffineTransform3D dR = new AffineTransform3D();
        switch (axis) {
            case 0: {
                dR.set(1.0, 0.0, 0.0, 0.0, 0.0, dcos, -dsin, 0.0, 0.0, dsin, dcos, 0.0);
                break;
            }
            case 1: {
                dR.set(dcos, 0.0, dsin, 0.0, 0.0, 1.0, 0.0, 0.0, -dsin, 0.0, dcos, 0.0);
                break;
            }
            default: {
                dR.set(dcos, -dsin, 0.0, 0.0, dsin, dcos, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
            }
        }
        this.preConcatenate(dR);
    }

    public void scale(double d) {
        AffineTransform3D dR = new AffineTransform3D();
        dR.set(d, 0.0, 0.0, 0.0, 0.0, d, 0.0, 0.0, 0.0, 0.0, d, 0.0);
        this.preConcatenate(dR);
    }

    public void identity() {
        this.set(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    }

    public final void set(AffineTransform3D m) {
        this.a.m00 = m.a.m00;
        this.a.m10 = m.a.m10;
        this.a.m20 = m.a.m20;
        this.a.m01 = m.a.m01;
        this.a.m11 = m.a.m11;
        this.a.m21 = m.a.m21;
        this.a.m02 = m.a.m02;
        this.a.m12 = m.a.m12;
        this.a.m22 = m.a.m22;
        this.a.m03 = m.a.m03;
        this.a.m13 = m.a.m13;
        this.a.m23 = m.a.m23;
        this.inverse.a.m00 = m.inverse.a.m00;
        this.inverse.a.m10 = m.inverse.a.m10;
        this.inverse.a.m20 = m.inverse.a.m20;
        this.inverse.a.m01 = m.inverse.a.m01;
        this.inverse.a.m11 = m.inverse.a.m11;
        this.inverse.a.m21 = m.inverse.a.m21;
        this.inverse.a.m02 = m.inverse.a.m02;
        this.inverse.a.m12 = m.inverse.a.m12;
        this.inverse.a.m22 = m.inverse.a.m22;
        this.inverse.a.m03 = m.inverse.a.m03;
        this.inverse.a.m13 = m.inverse.a.m13;
        this.inverse.a.m23 = m.inverse.a.m23;
        this.updateDs();
        this.inverse.updateDs();
    }

    public final void set(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23) {
        this.a.m00 = m00;
        this.a.m01 = m01;
        this.a.m02 = m02;
        this.a.m03 = m03;
        this.a.m10 = m10;
        this.a.m11 = m11;
        this.a.m12 = m12;
        this.a.m13 = m13;
        this.a.m20 = m20;
        this.a.m21 = m21;
        this.a.m22 = m22;
        this.a.m23 = m23;
        this.invert();
        this.updateDs();
        this.inverse.updateDs();
    }

    public void toArray(double[] data) {
        data[0] = this.a.m00;
        data[1] = this.a.m10;
        data[2] = this.a.m20;
        data[3] = this.a.m01;
        data[4] = this.a.m11;
        data[5] = this.a.m21;
        data[6] = this.a.m02;
        data[7] = this.a.m12;
        data[8] = this.a.m22;
        data[9] = this.a.m03;
        data[10] = this.a.m13;
        data[11] = this.a.m23;
    }

    public void toMatrix(double[][] data) {
        data[0][0] = this.a.m00;
        data[0][1] = this.a.m01;
        data[0][2] = this.a.m02;
        data[0][3] = this.a.m03;
        data[1][0] = this.a.m10;
        data[1][1] = this.a.m11;
        data[1][2] = this.a.m12;
        data[1][3] = this.a.m13;
        data[2][0] = this.a.m20;
        data[2][1] = this.a.m21;
        data[2][2] = this.a.m22;
        data[2][3] = this.a.m23;
    }

    public final String toString() {
        return "3d-affine: (" + this.a.m00 + ", " + this.a.m01 + ", " + this.a.m02 + ", " + this.a.m03 + ", " + this.a.m10 + ", " + this.a.m11 + ", " + this.a.m12 + ", " + this.a.m13 + ", " + this.a.m20 + ", " + this.a.m21 + ", " + this.a.m22 + ", " + this.a.m23 + ")";
    }

    @Override
    public void set(double value, int row, int column) {
        assert (row >= 0 && row < 3 && column >= 0 && column < 4) : "Index out of bounds, a 3d affine matrix is a 3x4 matrix.";
        block0 : switch (row) {
            case 0: {
                switch (column) {
                    case 0: {
                        this.a.m00 = value;
                        break block0;
                    }
                    case 1: {
                        this.a.m01 = value;
                        break block0;
                    }
                    case 2: {
                        this.a.m02 = value;
                        break block0;
                    }
                }
                this.a.m03 = value;
                break;
            }
            case 1: {
                switch (column) {
                    case 0: {
                        this.a.m10 = value;
                        break block0;
                    }
                    case 1: {
                        this.a.m11 = value;
                        break block0;
                    }
                    case 2: {
                        this.a.m12 = value;
                        break block0;
                    }
                }
                this.a.m13 = value;
                break;
            }
            default: {
                switch (column) {
                    case 0: {
                        this.a.m20 = value;
                        break block0;
                    }
                    case 1: {
                        this.a.m21 = value;
                        break block0;
                    }
                    case 2: {
                        this.a.m22 = value;
                        break block0;
                    }
                }
                this.a.m23 = value;
            }
        }
        this.updateDs();
        this.invert();
        this.inverse.updateDs();
    }

    @Override
    public void set(double ... values) {
        assert (values.length == 12) : "Input dimensions do not match.  A 3d affine matrix is a 3x4 matrix.";
        this.a.m00 = values[0];
        this.a.m01 = values[1];
        this.a.m02 = values[2];
        this.a.m03 = values[3];
        this.a.m10 = values[4];
        this.a.m11 = values[5];
        this.a.m12 = values[6];
        this.a.m13 = values[7];
        this.a.m20 = values[8];
        this.a.m21 = values[9];
        this.a.m22 = values[10];
        this.a.m23 = values[11];
        this.updateDs();
        this.invert();
        this.inverse.updateDs();
    }

    @Override
    public void set(double[][] values) {
        assert (values.length == 3 && values[0].length == 4 && values[1].length == 4 && values[2].length == 4) : "Input dimensions do not match.  A 3d affine matrix is a 3x4 matrix.";
        this.a.m00 = values[0][0];
        this.a.m01 = values[0][1];
        this.a.m02 = values[0][2];
        this.a.m03 = values[0][3];
        this.a.m10 = values[1][0];
        this.a.m11 = values[1][1];
        this.a.m12 = values[1][2];
        this.a.m13 = values[1][3];
        this.a.m20 = values[2][0];
        this.a.m21 = values[2][1];
        this.a.m22 = values[2][2];
        this.a.m23 = values[2][3];
        this.updateDs();
        this.invert();
        this.inverse.updateDs();
    }

    protected static final class AffineMatrix3D {
        public double m00;
        public double m01;
        public double m02;
        public double m03;
        public double m10;
        public double m11;
        public double m12;
        public double m13;
        public double m20;
        public double m21;
        public double m22;
        public double m23;

        public AffineMatrix3D() {
            this.m00 = 1.0;
            this.m01 = 0.0;
            this.m02 = 0.0;
            this.m03 = 0.0;
            this.m10 = 0.0;
            this.m11 = 1.0;
            this.m12 = 0.0;
            this.m13 = 0.0;
            this.m20 = 0.0;
            this.m21 = 0.0;
            this.m22 = 1.0;
            this.m23 = 0.0;
        }

        public AffineMatrix3D(double ... m) {
            assert (m.length == 12);
            this.m00 = m[0];
            this.m01 = m[1];
            this.m02 = m[2];
            this.m03 = m[3];
            this.m10 = m[4];
            this.m11 = m[5];
            this.m12 = m[6];
            this.m13 = m[7];
            this.m20 = m[8];
            this.m21 = m[9];
            this.m22 = m[10];
            this.m23 = m[11];
        }

        public AffineMatrix3D copy() {
            return new AffineMatrix3D(this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23);
        }

        protected final double det() {
            return this.m00 * this.m11 * this.m22 + this.m10 * this.m21 * this.m02 + this.m20 * this.m01 * this.m12 - this.m02 * this.m11 * this.m20 - this.m12 * this.m21 * this.m00 - this.m22 * this.m01 * this.m10;
        }

        protected final void concatenate(AffineMatrix3D m) {
            double a00 = this.m00 * m.m00 + this.m01 * m.m10 + this.m02 * m.m20;
            double a01 = this.m00 * m.m01 + this.m01 * m.m11 + this.m02 * m.m21;
            double a02 = this.m00 * m.m02 + this.m01 * m.m12 + this.m02 * m.m22;
            double a03 = this.m00 * m.m03 + this.m01 * m.m13 + this.m02 * m.m23 + this.m03;
            double a10 = this.m10 * m.m00 + this.m11 * m.m10 + this.m12 * m.m20;
            double a11 = this.m10 * m.m01 + this.m11 * m.m11 + this.m12 * m.m21;
            double a12 = this.m10 * m.m02 + this.m11 * m.m12 + this.m12 * m.m22;
            double a13 = this.m10 * m.m03 + this.m11 * m.m13 + this.m12 * m.m23 + this.m13;
            double a20 = this.m20 * m.m00 + this.m21 * m.m10 + this.m22 * m.m20;
            double a21 = this.m20 * m.m01 + this.m21 * m.m11 + this.m22 * m.m21;
            double a22 = this.m20 * m.m02 + this.m21 * m.m12 + this.m22 * m.m22;
            double a23 = this.m20 * m.m03 + this.m21 * m.m13 + this.m22 * m.m23 + this.m23;
            this.m00 = a00;
            this.m01 = a01;
            this.m02 = a02;
            this.m03 = a03;
            this.m10 = a10;
            this.m11 = a11;
            this.m12 = a12;
            this.m13 = a13;
            this.m20 = a20;
            this.m21 = a21;
            this.m22 = a22;
            this.m23 = a23;
        }

        protected final void preConcatenate(AffineMatrix3D m) {
            double a00 = m.m00 * this.m00 + m.m01 * this.m10 + m.m02 * this.m20;
            double a01 = m.m00 * this.m01 + m.m01 * this.m11 + m.m02 * this.m21;
            double a02 = m.m00 * this.m02 + m.m01 * this.m12 + m.m02 * this.m22;
            double a03 = m.m00 * this.m03 + m.m01 * this.m13 + m.m02 * this.m23 + m.m03;
            double a10 = m.m10 * this.m00 + m.m11 * this.m10 + m.m12 * this.m20;
            double a11 = m.m10 * this.m01 + m.m11 * this.m11 + m.m12 * this.m21;
            double a12 = m.m10 * this.m02 + m.m11 * this.m12 + m.m12 * this.m22;
            double a13 = m.m10 * this.m03 + m.m11 * this.m13 + m.m12 * this.m23 + m.m13;
            double a20 = m.m20 * this.m00 + m.m21 * this.m10 + m.m22 * this.m20;
            double a21 = m.m20 * this.m01 + m.m21 * this.m11 + m.m22 * this.m21;
            double a22 = m.m20 * this.m02 + m.m21 * this.m12 + m.m22 * this.m22;
            double a23 = m.m20 * this.m03 + m.m21 * this.m13 + m.m22 * this.m23 + m.m23;
            this.m00 = a00;
            this.m01 = a01;
            this.m02 = a02;
            this.m03 = a03;
            this.m10 = a10;
            this.m11 = a11;
            this.m12 = a12;
            this.m13 = a13;
            this.m20 = a20;
            this.m21 = a21;
            this.m22 = a22;
            this.m23 = a23;
        }
    }
}

