/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.concatenate.Concatenable;
import net.imglib2.concatenate.PreConcatenable;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineSet;

public class AffineTransform2D
implements AffineGet,
AffineSet,
Concatenable<AffineGet>,
PreConcatenable<AffineGet> {
    protected final AffineMatrix2D a;
    protected final RealPoint d0;
    protected final RealPoint d1;
    protected final RealPoint[] ds;
    protected final AffineTransform2D inverse;

    public AffineTransform2D() {
        this(new AffineMatrix2D());
    }

    protected AffineTransform2D(AffineMatrix2D a) {
        this.a = a;
        this.d0 = new RealPoint(2);
        this.d1 = new RealPoint(2);
        this.ds = new RealPoint[]{this.d0, this.d1};
        this.updateDs();
        this.inverse = new AffineTransform2D(this);
        this.invert();
        this.inverse.updateDs();
    }

    protected AffineTransform2D(AffineTransform2D inverse) {
        this.inverse = inverse;
        this.a = new AffineMatrix2D();
        this.d0 = new RealPoint(2);
        this.d1 = new RealPoint(2);
        this.ds = new RealPoint[]{this.d0, this.d1};
    }

    protected void invert() {
        double det = this.a.det();
        if (det == 0.0) {
            throw new RuntimeException("Matrix is singular.");
        }
        double idet = 1.0 / det;
        this.inverse.a.m00 = this.a.m11 * idet;
        this.inverse.a.m01 = -this.a.m01 * idet;
        this.inverse.a.m02 = (this.a.m01 * this.a.m12 - this.a.m02 * this.a.m11) * idet;
        this.inverse.a.m10 = -this.a.m10 * idet;
        this.inverse.a.m11 = this.a.m00 * idet;
        this.inverse.a.m12 = (this.a.m02 * this.a.m10 - this.a.m00 * this.a.m12) * idet;
    }

    protected void updateDs() {
        this.d0.setPosition(this.a.m00, 0);
        this.d0.setPosition(this.a.m10, 1);
        this.d1.setPosition(this.a.m01, 0);
        this.d1.setPosition(this.a.m11, 1);
    }

    @Override
    public final void apply(double[] source, double[] target) {
        assert (source.length >= 2 && target.length >= 2) : "2d affine transformations can be applied to 2d coordinates only.";
        target[0] = source[0] * this.a.m00 + source[1] * this.a.m01 + this.a.m02;
        target[1] = source[0] * this.a.m10 + source[1] * this.a.m11 + this.a.m12;
    }

    @Override
    public void apply(float[] source, float[] target) {
        assert (source.length >= 2 && target.length >= 2) : "2d affine transformations can be applied to 2d coordinates only.";
        target[0] = (float)((double)source[0] * this.a.m00 + (double)source[1] * this.a.m01 + this.a.m02);
        target[1] = (float)((double)source[0] * this.a.m10 + (double)source[1] * this.a.m11 + this.a.m12);
    }

    @Override
    public void apply(RealLocalizable source, RealPositionable target) {
        assert (source.numDimensions() >= 2 && target.numDimensions() >= 2) : "2d affine transformations can be applied to 2d coordinates only.";
        target.setPosition(source.getDoublePosition(0) * this.a.m00 + source.getDoublePosition(1) * this.a.m01 + this.a.m02, 0);
        target.setPosition(source.getDoublePosition(0) * this.a.m10 + source.getDoublePosition(1) * this.a.m11 + this.a.m12, 1);
    }

    @Override
    public final void applyInverse(double[] source, double[] target) {
        assert (source.length >= 2 && target.length >= 2) : "2d affine transformations can be applied to 2d coordinates only.";
        source[0] = target[0] * this.inverse.a.m00 + target[1] * this.inverse.a.m01 + this.inverse.a.m02;
        source[1] = target[0] * this.inverse.a.m10 + target[1] * this.inverse.a.m11 + this.inverse.a.m12;
    }

    @Override
    public void applyInverse(float[] source, float[] target) {
        assert (source.length >= 2 && target.length >= 2) : "2d affine transformations can be applied to 2d coordinates only.";
        source[0] = (float)((double)target[0] * this.inverse.a.m00 + (double)target[1] * this.inverse.a.m01 + this.inverse.a.m02);
        source[1] = (float)((double)target[0] * this.inverse.a.m10 + (double)target[1] * this.inverse.a.m11 + this.inverse.a.m12);
    }

    @Override
    public void applyInverse(RealPositionable source, RealLocalizable target) {
        assert (source.numDimensions() >= 2 && target.numDimensions() >= 2) : "2d affine transformations can be applied to 2d coordinates only.";
        source.setPosition(target.getDoublePosition(0) * this.inverse.a.m00 + target.getDoublePosition(1) * this.inverse.a.m01 + this.inverse.a.m02, 0);
        source.setPosition(target.getDoublePosition(0) * this.inverse.a.m10 + target.getDoublePosition(1) * this.inverse.a.m11 + this.inverse.a.m12, 1);
    }

    public final AffineTransform2D concatenate(AffineGet affine) {
        assert (affine.numSourceDimensions() >= 2) : "Only >=2d affine transformations can be concatenated to a 2d affine transformation.";
        double am00 = affine.get(0, 0);
        double am01 = affine.get(0, 1);
        double am02 = affine.get(0, 2);
        double am10 = affine.get(1, 0);
        double am11 = affine.get(1, 1);
        double am12 = affine.get(1, 2);
        double a00 = this.a.m00 * am00 + this.a.m01 * am10;
        double a01 = this.a.m00 * am01 + this.a.m01 * am11;
        double a02 = this.a.m00 * am02 + this.a.m01 * am12 + this.a.m02;
        double a10 = this.a.m10 * am00 + this.a.m11 * am10;
        double a11 = this.a.m10 * am01 + this.a.m11 * am11;
        double a12 = this.a.m10 * am02 + this.a.m11 * am12 + this.a.m12;
        this.a.m00 = a00;
        this.a.m01 = a01;
        this.a.m02 = a02;
        this.a.m10 = a10;
        this.a.m11 = a11;
        this.a.m12 = a12;
        this.invert();
        this.updateDs();
        this.inverse.updateDs();
        return this;
    }

    public final AffineTransform2D concatenate(AffineTransform2D model) {
        double a00 = this.a.m00 * model.a.m00 + this.a.m01 * model.a.m10;
        double a01 = this.a.m00 * model.a.m01 + this.a.m01 * model.a.m11;
        double a02 = this.a.m00 * model.a.m02 + this.a.m01 * model.a.m12 + this.a.m02;
        double a10 = this.a.m10 * model.a.m00 + this.a.m11 * model.a.m10;
        double a11 = this.a.m10 * model.a.m01 + this.a.m11 * model.a.m11;
        double a12 = this.a.m10 * model.a.m02 + this.a.m11 * model.a.m12 + this.a.m12;
        this.a.m00 = a00;
        this.a.m01 = a01;
        this.a.m02 = a02;
        this.a.m10 = a10;
        this.a.m11 = a11;
        this.a.m12 = a12;
        this.invert();
        this.updateDs();
        this.inverse.updateDs();
        return this;
    }

    public AffineTransform2D copy() {
        AffineMatrix2D ma = new AffineMatrix2D();
        ma.m00 = this.a.m00;
        ma.m10 = this.a.m10;
        ma.m01 = this.a.m01;
        ma.m11 = this.a.m11;
        ma.m02 = this.a.m02;
        ma.m12 = this.a.m12;
        return new AffineTransform2D(ma);
    }

    @Override
    public RealLocalizable d(int d) {
        return this.ds[d];
    }

    @Override
    public double get(int row, int column) {
        assert (row >= 0 && row < 2 && column >= 0 && column < 3) : "Index out of bounds, a 3d affine matrix is a 2x3 matrix.";
        switch (row) {
            case 0: {
                switch (column) {
                    case 0: {
                        return this.a.m00;
                    }
                    case 1: {
                        return this.a.m01;
                    }
                }
                return this.a.m02;
            }
        }
        switch (column) {
            case 0: {
                return this.a.m10;
            }
            case 1: {
                return this.a.m11;
            }
        }
        return this.a.m12;
    }

    @Override
    public double[] getRowPackedCopy() {
        return new double[]{this.a.m00, this.a.m01, this.a.m02, this.a.m10, this.a.m11, this.a.m12};
    }

    @Override
    public Class<AffineGet> getConcatenableClass() {
        return AffineGet.class;
    }

    @Override
    public Class<AffineGet> getPreConcatenableClass() {
        return AffineGet.class;
    }

    @Override
    public AffineTransform2D inverse() {
        return this.inverse;
    }

    @Override
    public AffineTransform2D inverseAffine() {
        return this.inverse();
    }

    @Override
    public int numSourceDimensions() {
        return 2;
    }

    @Override
    public int numTargetDimensions() {
        return 2;
    }

    public final AffineTransform2D preConcatenate(AffineGet affine) {
        assert (affine.numSourceDimensions() >= 2) : "Only >=2d affine transformations can be pre-concatenated to a 2d affine transformation.";
        double am00 = affine.get(0, 0);
        double am01 = affine.get(0, 1);
        double am02 = affine.get(0, 2);
        double am10 = affine.get(1, 0);
        double am11 = affine.get(1, 1);
        double am12 = affine.get(1, 2);
        double a00 = am00 * this.a.m00 + am01 * this.a.m10;
        double a01 = am00 * this.a.m01 + am01 * this.a.m11;
        double a02 = am00 * this.a.m02 + am01 * this.a.m12 + am02;
        double a10 = am10 * this.a.m00 + am11 * this.a.m10;
        double a11 = am10 * this.a.m01 + am11 * this.a.m11;
        double a12 = am10 * this.a.m02 + am11 * this.a.m12 + am12;
        this.a.m00 = a00;
        this.a.m01 = a01;
        this.a.m02 = a02;
        this.a.m10 = a10;
        this.a.m11 = a11;
        this.a.m12 = a12;
        this.invert();
        this.updateDs();
        this.inverse.updateDs();
        return this;
    }

    public final AffineTransform2D preConcatenate(AffineTransform2D affine) {
        double a00 = affine.a.m00 * this.a.m00 + affine.a.m01 * this.a.m10;
        double a01 = affine.a.m00 * this.a.m01 + affine.a.m01 * this.a.m11;
        double a02 = affine.a.m00 * this.a.m02 + affine.a.m01 * this.a.m12 + affine.a.m02;
        double a10 = affine.a.m10 * this.a.m00 + affine.a.m11 * this.a.m10;
        double a11 = affine.a.m10 * this.a.m01 + affine.a.m11 * this.a.m11;
        double a12 = affine.a.m10 * this.a.m02 + affine.a.m11 * this.a.m12 + affine.a.m12;
        this.a.m00 = a00;
        this.a.m01 = a01;
        this.a.m02 = a02;
        this.a.m10 = a10;
        this.a.m11 = a11;
        this.a.m12 = a12;
        this.invert();
        this.updateDs();
        this.inverse.updateDs();
        return this;
    }

    public void rotate(double d) {
        double dcos = Math.cos(d);
        double dsin = Math.sin(d);
        AffineTransform2D dR = new AffineTransform2D();
        dR.set(dcos, -dsin, 0.0, dsin, dcos, 0.0);
        this.preConcatenate(dR);
    }

    public void translate(double ... t) {
        assert (t.length == 2) : "2d affine transformations can be translated by 2d vector only.";
        this.a.m02 += t[0];
        this.a.m12 += t[1];
        this.invert();
        this.updateDs();
        this.inverse.updateDs();
    }

    public void scale(double d) {
        this.a.m00 *= d;
        this.a.m01 *= d;
        this.a.m02 *= d;
        this.a.m10 *= d;
        this.a.m11 *= d;
        this.a.m12 *= d;
        this.invert();
        this.updateDs();
        this.inverse.updateDs();
    }

    public final void set(AffineTransform2D m) {
        this.a.m00 = m.a.m00;
        this.a.m10 = m.a.m10;
        this.a.m01 = m.a.m01;
        this.a.m11 = m.a.m11;
        this.a.m02 = m.a.m02;
        this.a.m12 = m.a.m12;
        this.inverse.a.m00 = m.inverse.a.m00;
        this.inverse.a.m10 = m.inverse.a.m10;
        this.inverse.a.m01 = m.inverse.a.m01;
        this.inverse.a.m11 = m.inverse.a.m11;
        this.inverse.a.m02 = m.inverse.a.m02;
        this.inverse.a.m12 = m.inverse.a.m12;
        this.updateDs();
        this.inverse.updateDs();
    }

    public void toArray(double[] data) {
        data[0] = this.a.m00;
        data[1] = this.a.m10;
        data[3] = this.a.m01;
        data[4] = this.a.m11;
        data[6] = this.a.m02;
        data[7] = this.a.m12;
    }

    public void toMatrix(double[][] data) {
        data[0][0] = this.a.m00;
        data[0][1] = this.a.m01;
        data[0][2] = this.a.m02;
        data[1][0] = this.a.m10;
        data[1][1] = this.a.m11;
        data[1][2] = this.a.m12;
    }

    public final String toString() {
        return "2d-affine: (" + this.a.m00 + ", " + this.a.m01 + ", " + this.a.m02 + ", " + this.a.m10 + ", " + this.a.m11 + ", " + this.a.m12 + ")";
    }

    @Override
    public void set(double value, int row, int column) {
        assert (row >= 0 && row < 2 && column >= 0 && column < 3) : "Index out of bounds, a 2d affine matrix is a 2x3 matrix.";
        block0 : switch (row) {
            case 0: {
                switch (column) {
                    case 0: {
                        this.a.m00 = value;
                        break block0;
                    }
                    case 1: {
                        this.a.m01 = value;
                        break block0;
                    }
                }
                this.a.m02 = value;
                break;
            }
            default: {
                switch (column) {
                    case 0: {
                        this.a.m10 = value;
                        break block0;
                    }
                    case 1: {
                        this.a.m11 = value;
                        break block0;
                    }
                }
                this.a.m12 = value;
            }
        }
        this.updateDs();
        this.invert();
        this.inverse.updateDs();
    }

    @Override
    public void set(double ... values) {
        assert (values.length == 6) : "Input dimensions do not match.  A 2d affine matrix is a 2x3 matrix.";
        this.a.m00 = values[0];
        this.a.m01 = values[1];
        this.a.m02 = values[2];
        this.a.m10 = values[3];
        this.a.m11 = values[4];
        this.a.m12 = values[5];
        this.updateDs();
        this.invert();
        this.inverse.updateDs();
    }

    @Override
    public void set(double[][] values) {
        assert (values.length == 2 && values[0].length == 3 && values[1].length == 3) : "Input dimensions do not match.  A 2d affine matrix is a 2x3 matrix.";
        this.a.m00 = values[0][0];
        this.a.m01 = values[0][1];
        this.a.m02 = values[0][2];
        this.a.m10 = values[1][0];
        this.a.m11 = values[1][1];
        this.a.m12 = values[1][2];
        this.updateDs();
        this.invert();
        this.inverse.updateDs();
    }

    protected static final class AffineMatrix2D {
        public double m00 = 1.0;
        public double m01 = 0.0;
        public double m02 = 0.0;
        public double m10 = 0.0;
        public double m11 = 1.0;
        public double m12 = 0.0;

        protected AffineMatrix2D() {
        }

        public AffineMatrix2D copy() {
            AffineMatrix2D copy = new AffineMatrix2D();
            copy.m00 = this.m00;
            copy.m01 = this.m01;
            copy.m02 = this.m02;
            copy.m10 = this.m10;
            copy.m11 = this.m11;
            copy.m12 = this.m12;
            return copy;
        }

        protected final double det() {
            return this.m00 * this.m11 - this.m01 * this.m10;
        }
    }
}

