/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import Jama.Matrix;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.concatenate.Concatenable;
import net.imglib2.concatenate.PreConcatenable;
import net.imglib2.realtransform.AbstractAffineTransform;
import net.imglib2.realtransform.AffineGet;

public class AffineTransform
extends AbstractAffineTransform
implements Concatenable<AffineGet>,
PreConcatenable<AffineGet> {
    protected final AffineTransform inverse;

    public AffineTransform(int n) {
        super(n);
        this.inverse = new AffineTransform(this);
        this.invert();
        this.inverse.updateDs();
    }

    protected AffineTransform(Matrix a, double[] t) {
        super(a, t);
        this.inverse = new AffineTransform(this);
        this.invert();
        this.inverse.updateDs();
    }

    public AffineTransform(Matrix matrix) {
        super(matrix);
        this.inverse = new AffineTransform(this);
        this.invert();
        this.inverse.updateDs();
    }

    protected AffineTransform(AffineTransform inverse) {
        super(inverse.n);
        this.inverse = inverse;
    }

    protected void invertT() {
        int r = 0;
        while (r < this.n) {
            double tir = -this.inverse.a.get(r, 0) * this.t[0];
            int c = 1;
            while (c < this.n) {
                tir -= this.inverse.a.get(r, c) * this.t[c];
                ++c;
            }
            this.inverse.t[r] = tir;
            ++r;
        }
    }

    protected void invert() {
        Matrix ii = this.a.inverse();
        this.inverse.a.setMatrix(0, this.n - 1, 0, this.n - 1, ii);
        this.invertT();
    }

    @Override
    public void apply(float[] source, float[] target) {
        assert (source.length == this.n && target.length == this.n) : "Source or target vector dimensions do not match with the transformation.";
        int r = 0;
        while (r < this.n) {
            double ar = 0.0;
            int c = 0;
            while (c < this.n) {
                ar += (double)source[c] * this.a.get(r, c);
                ++c;
            }
            target[r] = (float)(ar + this.t[r]);
            ++r;
        }
    }

    @Override
    public void applyInverse(double[] source, double[] target) {
        this.inverse.apply(target, source);
    }

    @Override
    public void applyInverse(float[] source, float[] target) {
        this.inverse.apply(target, source);
    }

    @Override
    public void applyInverse(RealPositionable source, RealLocalizable target) {
        this.inverse.apply(target, source);
    }

    @Override
    public AffineTransform inverse() {
        return this.inverse;
    }

    @Override
    public AffineTransform inverseAffine() {
        return this.inverse();
    }

    public void set(AffineGet affine) {
        assert (this.n == affine.numSourceDimensions()) : "Dimensions do not match.";
        int r = 0;
        while (r < this.n) {
            int c = 0;
            while (c < this.n) {
                this.a.set(r, c, affine.get(r, c));
                ++c;
            }
            this.t[r] = affine.get(r, this.n);
            ++r;
        }
        this.updateDs();
        this.invert();
        this.inverse.updateDs();
    }

    @Override
    public void set(double[][] affine) {
        assert (this.n == affine.length) : "Dimensions do not match.";
        int r = 0;
        while (r < this.n) {
            assert (this.n + 1 == affine[r].length) : "Dimensions do not match.";
            int c = 0;
            while (c < this.n) {
                this.a.set(r, c, affine[r][c]);
                ++c;
            }
            this.t[r] = affine[r][this.n];
            ++r;
        }
        this.updateDs();
        this.invert();
        this.inverse.updateDs();
    }

    public AffineTransform concatenate(AffineGet affine) {
        assert (affine.numSourceDimensions() == this.numSourceDimensions()) : "Dimensions do not match.";
        Matrix matrix = new Matrix(this.n, this.n);
        double[] translation = new double[this.n];
        int r = 0;
        while (r < this.n) {
            int c = 0;
            while (c < this.n) {
                double ar = this.get(r, 0) * affine.get(0, c);
                int k = 1;
                while (k < this.n) {
                    ar += this.get(r, k) * affine.get(k, c);
                    ++k;
                }
                matrix.set(r, c, ar);
                ++c;
            }
            double tr = this.get(r, this.n) + this.get(r, 0) * affine.get(0, this.n);
            int k = 1;
            while (k < this.n) {
                tr += this.get(r, k) * affine.get(k, this.n);
                ++k;
            }
            translation[r] = tr;
            ++r;
        }
        this.a.setMatrix(0, this.n - 1, 0, this.n - 1, matrix);
        System.arraycopy(translation, 0, this.t, 0, this.t.length);
        this.updateDs();
        this.invert();
        this.inverse.updateDs();
        return this;
    }

    @Override
    public Class<AffineGet> getConcatenableClass() {
        return AffineGet.class;
    }

    public AffineTransform preConcatenate(AffineGet affine) {
        assert (affine.numSourceDimensions() == this.numSourceDimensions()) : "Dimensions do not match.";
        Matrix matrix = new Matrix(this.n, this.n);
        double[] translation = new double[this.n];
        int r = 0;
        while (r < this.n) {
            int c = 0;
            while (c < this.n) {
                double ar = affine.get(r, 0) * this.get(0, c);
                int k = 1;
                while (k < this.n) {
                    ar += affine.get(r, k) * this.get(k, c);
                    ++k;
                }
                matrix.set(r, c, ar);
                ++c;
            }
            double tr = affine.get(r, this.n) + affine.get(r, 0) * this.get(0, this.n);
            int k = 1;
            while (k < this.n) {
                tr += affine.get(r, k) * this.get(k, this.n);
                ++k;
            }
            translation[r] = tr;
            ++r;
        }
        this.a.setMatrix(0, this.n - 1, 0, this.n - 1, matrix);
        System.arraycopy(translation, 0, this.t, 0, this.t.length);
        this.updateDs();
        this.invert();
        this.inverse.updateDs();
        return this;
    }

    @Override
    public Class<AffineGet> getPreConcatenableClass() {
        return AffineGet.class;
    }

    @Override
    public void set(double value, int row, int column) {
        if (column == this.n) {
            this.t[row] = value;
        } else {
            this.a.set(row, column, value);
        }
        this.updateDs();
        this.invert();
        this.inverse.updateDs();
    }

    @Override
    public void set(double ... values) {
        assert (values.length == this.n * this.n + this.n) : "Input dimensions do not match dimensions of this affine transform.";
        int i = 0;
        int r = 0;
        while (r < this.n) {
            int c = 0;
            while (c < this.n) {
                this.a.set(r, c, values[i]);
                ++c;
                ++i;
            }
            this.t[r] = values[i++];
            ++r;
        }
        this.updateDs();
        this.invert();
        this.inverse.updateDs();
    }
}

