/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RealLocalizable;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.RealTransformRandomAccessible;

public class AffineRandomAccessible<T, R extends AffineGet>
extends RealTransformRandomAccessible<T, R> {
    public AffineRandomAccessible(RealRandomAccessible<T> target, R transform) {
        super(target, transform);
    }

    @Override
    public AffineRandomAccess randomAccess() {
        return new AffineRandomAccess();
    }

    @Override
    public AffineRandomAccess randomAccess(Interval interval) {
        return this.randomAccess();
    }

    public class AffineRandomAccess
    extends RealTransformRandomAccessible.RealTransformRandomAccess {
        final double[] move;

        protected AffineRandomAccess() {
            this.move = new double[this.n];
        }

        protected AffineRandomAccess(AffineRandomAccess a) {
            super(a);
            this.move = new double[this.n];
        }

        protected void scaleMove(double distance, int d) {
            RealLocalizable dd = ((AffineGet)AffineRandomAccessible.this.transform).d(d);
            int ddd = 0;
            while (ddd < this.n) {
                this.move[ddd] = distance * dd.getDoublePosition(ddd);
                ++ddd;
            }
        }

        @Override
        public void fwd(int d) {
            super.fwd(d);
            this.targetAccess.move(((AffineGet)AffineRandomAccessible.this.transform).d(d));
        }

        @Override
        public void bck(int d) {
            super.bck(d);
            this.scaleMove(-1.0, d);
            this.targetAccess.move(this.move);
        }

        @Override
        public void move(long distance, int d) {
            super.move(distance, d);
            this.scaleMove(distance, d);
            this.targetAccess.move(this.move);
        }

        @Override
        public void move(int distance, int d) {
            this.move((long)distance, d);
        }

        @Override
        public void move(Localizable localizable) {
            super.move(localizable);
            this.apply();
        }

        @Override
        public void move(int[] distance) {
            super.move(distance);
            this.apply();
        }

        @Override
        public void move(long[] distance) {
            super.move(distance);
            this.apply();
        }

        @Override
        public void setPosition(int[] pos) {
            super.setPosition(pos);
            this.apply();
        }

        @Override
        public void setPosition(long[] pos) {
            super.setPosition(pos);
            this.apply();
        }

        @Override
        public void setPosition(int position, int d) {
            this.setPosition((long)position, d);
        }

        @Override
        public void setPosition(long pos, int d) {
            long distance = pos - this.position[d];
            this.move(distance, d);
        }

        @Override
        public void setPosition(Localizable localizable) {
            localizable.localize(this.position);
            this.apply();
        }

        @Override
        public T get() {
            return this.targetAccess.get();
        }

        @Override
        public AffineRandomAccess copy() {
            return new AffineRandomAccess(this);
        }

        @Override
        public AffineRandomAccess copyRandomAccess() {
            return this.copy();
        }
    }
}

