/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import Jama.Matrix;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineSet;

public abstract class AbstractAffineTransform
implements AffineGet,
AffineSet {
    protected final int n;
    protected final Matrix a;
    protected final double[] t;
    protected final RealPoint[] ds;

    protected AbstractAffineTransform(Matrix a, double[] t) {
        assert (a.getRowDimension() == t.length && a.getColumnDimension() == t.length) : "The passed arrays must be n*n and the t-vector n.";
        this.n = t.length;
        this.a = a;
        this.t = t;
        this.ds = new RealPoint[this.n];
        int r = 0;
        while (r < this.n) {
            this.ds[r] = new RealPoint(this.n);
            ++r;
        }
        this.updateDs();
    }

    public AbstractAffineTransform(Matrix matrix) {
        assert (matrix.getRowDimension() == matrix.getColumnDimension() - 1) : "The passed affine matrix must be of the format (n-1)*n.";
        this.n = matrix.getRowDimension();
        this.a = new Matrix(this.n, this.n);
        this.t = new double[this.n];
        this.ds = new RealPoint[this.n];
        this.a.setMatrix(0, this.n - 1, 0, this.n - 1, matrix);
        int r = 0;
        while (r < this.n) {
            this.t[r] = matrix.get(r, this.n);
            this.ds[r] = new RealPoint(this.n);
            ++r;
        }
        this.updateDs();
    }

    public AbstractAffineTransform(int n) {
        this.n = n;
        this.a = new Matrix(n, n);
        this.t = new double[n];
        this.ds = new RealPoint[n];
        int r = 0;
        while (r < n) {
            RealPoint d = new RealPoint(n);
            this.a.set(r, r, 1.0);
            d.setPosition(1.0, r);
            this.ds[r] = d;
            ++r;
        }
    }

    protected void updateDs() {
        int c = 0;
        while (c < this.n) {
            RealPoint d = this.ds[c];
            int r = 0;
            while (r < this.n) {
                d.setPosition(this.a.get(r, c), r);
                ++r;
            }
            ++c;
        }
    }

    @Override
    public int numSourceDimensions() {
        return this.n;
    }

    @Override
    public int numTargetDimensions() {
        return this.n;
    }

    @Override
    public void apply(double[] source, double[] target) {
        assert (source.length == this.n && target.length == this.n) : "Source or target vector dimensions do not match with the transformation.";
        int r = 0;
        while (r < this.n) {
            double ar = 0.0;
            int c = 0;
            while (c < this.n) {
                ar += source[c] * this.a.get(r, c);
                ++c;
            }
            target[r] = ar + this.t[r];
            ++r;
        }
    }

    @Override
    public void apply(RealLocalizable source, RealPositionable target) {
        assert (source.numDimensions() == this.n && target.numDimensions() == this.n) : "Source or target vector dimensions do not match with the transformation.";
        int r = 0;
        while (r < this.n) {
            double ar = 0.0;
            int c = 0;
            while (c < this.n) {
                ar += source.getDoublePosition(c) * this.a.get(r, c);
                ++c;
            }
            target.setPosition(ar + this.t[r], r);
            ++r;
        }
    }

    @Override
    public double get(int row, int column) {
        if (column == this.n) {
            return this.t[row];
        }
        return this.a.get(row, column);
    }

    @Override
    public double[] getRowPackedCopy() {
        double[] copy = new double[this.n * this.n + this.n];
        int r = 0;
        int i = 0;
        while (r < this.n) {
            int c = 0;
            while (c < this.n) {
                copy[i] = this.a.get(r, c);
                ++c;
                ++i;
            }
            copy[i] = this.t[r];
            ++r;
            ++i;
        }
        return copy;
    }

    @Override
    public RealLocalizable d(int d) {
        return this.ds[d];
    }
}

