/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.transformation;

import mpicbg.models.InvertibleBoundable;
import mpicbg.models.NoninvertibleModelException;
import net.imglib2.Cursor;
import net.imglib2.ExtendedRandomAccessibleInterval;
import net.imglib2.RealRandomAccess;
import net.imglib2.algorithm.OutputAlgorithm;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.type.Type;

public class ImageTransform<T extends Type<T>>
implements OutputAlgorithm<Img<T>> {
    final InvertibleBoundable transform;
    final ExtendedRandomAccessibleInterval<T, Img<T>> container;
    final int numDimensions;
    final InterpolatorFactory<T, ExtendedRandomAccessibleInterval<T, Img<T>>> interpolatorFactory;
    ImgFactory<T> outputContainerFactory;
    final long[] newDim;
    final float[] offset;
    Img<T> transformed;
    String errorMessage = "";

    public ImageTransform(ExtendedRandomAccessibleInterval<T, Img<T>> container, InvertibleBoundable transform, InterpolatorFactory<T, ExtendedRandomAccessibleInterval<T, Img<T>>> interpolatorFactory) {
        int d;
        this.container = container;
        this.interpolatorFactory = interpolatorFactory;
        this.numDimensions = container.numDimensions();
        this.transform = transform;
        float[] min = new float[this.numDimensions];
        float[] max = new float[this.numDimensions];
        Img<T> source = container.getSource();
        this.outputContainerFactory = source.factory();
        for (d = 0; d < this.numDimensions; ++d) {
            min[d] = (float)source.realMin(d);
            max[d] = (float)source.realMax(d);
        }
        transform.estimateBounds(min, max);
        this.offset = new float[this.numDimensions];
        this.newDim = new long[this.numDimensions];
        for (d = 0; d < this.numDimensions; ++d) {
            this.newDim[d] = Math.round(max[d]) - Math.round(min[d]);
            this.offset[d] = min[d];
        }
    }

    public void setOutputContainerFactory(ImgFactory<T> outputContainerFactory) {
        this.outputContainerFactory = outputContainerFactory;
    }

    public ImgFactory<T> getOutputContainerFactory() {
        return this.outputContainerFactory;
    }

    public float[] getOffset() {
        return this.offset;
    }

    public void setOffset(float[] offset) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.offset[d] = offset[d];
        }
    }

    public long[] getNewImageSize() {
        return this.newDim;
    }

    public void setNewImageSize(long[] newDim) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.newDim[d] = newDim[d];
        }
    }

    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.container == null) {
            this.errorMessage = "AffineTransform: [Container<T> container] is null.";
            return false;
        }
        if (this.interpolatorFactory == null) {
            this.errorMessage = "AffineTransform: [InterpolatorFactory<T> interpolatorFactory] is null.";
            return false;
        }
        if (this.transform == null) {
            this.errorMessage = "AffineTransform: [Transform3D transform] or [float[] transform] is null.";
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Img<T> getResult() {
        return this.transformed;
    }

    public boolean process() {
        if (!this.checkInput()) {
            return false;
        }
        this.transformed = this.outputContainerFactory.create(this.newDim, ((Type)this.container.getSource().firstElement()).createVariable());
        Cursor transformedIterator = this.transformed.localizingCursor();
        RealRandomAccess<T> interpolator = this.interpolatorFactory.create(this.container);
        try {
            float[] tmp = new float[this.numDimensions];
            while (transformedIterator.hasNext()) {
                transformedIterator.fwd();
                for (int d = 0; d < this.numDimensions; ++d) {
                    tmp[d] = (float)transformedIterator.getIntPosition(d) + this.offset[d];
                }
                this.transform.applyInverseInPlace(tmp);
                interpolator.setPosition(tmp);
                ((Type)transformedIterator.get()).set((Type)interpolator.get());
            }
        }
        catch (NoninvertibleModelException e) {
            this.errorMessage = "ImageTransform.process(): " + e.getMessage();
            return false;
        }
        return true;
    }
}

