/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.region.localneighborhood;

import java.util.Iterator;
import net.imglib2.AbstractCursor;
import net.imglib2.IterableInterval;
import net.imglib2.IterableRealInterval;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RealPositionable;

public class DomainCursor<T>
extends AbstractCursor<T>
implements IterableInterval<T> {
    private final int numDimensions;
    private final long[] position;
    private final long[] parentPosition;
    private long count = 0L;
    private long size;
    private final RandomAccess<T> parent;
    private long[] span;

    public DomainCursor(RandomAccess<T> parent, long[] span) {
        super(parent.numDimensions());
        this.numDimensions = parent.numDimensions();
        this.span = span;
        this.position = new long[parent.numDimensions()];
        this.parentPosition = new long[parent.numDimensions()];
        parent.localize(this.parentPosition);
        this.size = 1L;
        for (int i = 0; i < this.numDimensions; ++i) {
            this.size *= 2L * span[i] + 1L;
        }
        this.parent = parent.copyRandomAccess();
        this.reset();
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public T firstElement() {
        RandomAccess<T> ra = this.parent.copyRandomAccess();
        ra.setPosition(this.parentPosition);
        return ra.get();
    }

    @Override
    public Object iterationOrder() {
        return this;
    }

    @Override
    public boolean equalIterationOrder(IterableRealInterval<?> f) {
        return this.iterationOrder().equals(f.iterationOrder());
    }

    @Override
    public double realMin(int d) {
        return this.parentPosition[d] - this.span[d];
    }

    @Override
    public void realMin(double[] min) {
        for (int d = 0; d < this.numDimensions; ++d) {
            min[d] = this.parentPosition[d] - this.span[d];
        }
    }

    @Override
    public void realMin(RealPositionable min) {
        for (int d = 0; d < this.numDimensions; ++d) {
            min.setPosition(this.parentPosition[d] - this.span[d], d);
        }
    }

    @Override
    public double realMax(int d) {
        return this.parentPosition[d] + this.span[d];
    }

    @Override
    public void realMax(double[] max) {
        for (int d = 0; d < this.numDimensions; ++d) {
            max[d] = this.parentPosition[d] + this.span[d];
        }
    }

    @Override
    public void realMax(RealPositionable max) {
        for (int d = 0; d < this.numDimensions; ++d) {
            max.setPosition(this.parentPosition[d] + this.span[d], d);
        }
    }

    @Override
    public int numDimensions() {
        return this.numDimensions;
    }

    @Override
    public Iterator<T> iterator() {
        return this.cursor();
    }

    @Override
    public long min(int d) {
        return this.parentPosition[d] - this.span[d];
    }

    @Override
    public void min(long[] min) {
        for (int d = 0; d < this.numDimensions; ++d) {
            min[d] = this.parentPosition[d] - this.span[d];
        }
    }

    @Override
    public void min(Positionable min) {
        for (int d = 0; d < this.numDimensions; ++d) {
            min.setPosition(this.parentPosition[d] - this.span[d], d);
        }
    }

    @Override
    public long max(int d) {
        return this.parentPosition[d] + this.span[d];
    }

    @Override
    public void max(long[] max) {
        for (int d = 0; d < this.numDimensions; ++d) {
            max[d] = this.parentPosition[d] + this.span[d];
        }
    }

    @Override
    public void max(Positionable max) {
        for (int d = 0; d < this.numDimensions; ++d) {
            max.setPosition(this.parentPosition[d] - this.span[d], d);
        }
    }

    @Override
    public void dimensions(long[] dimensions) {
        for (int d = 0; d < this.numDimensions; ++d) {
            dimensions[d] = 2L * this.span[d] + 1L;
        }
    }

    @Override
    public long dimension(int d) {
        return 2L * this.span[d] + 1L;
    }

    @Override
    public DomainCursor<T> cursor() {
        RandomAccess<T> ra = this.parent.copyRandomAccess();
        ra.setPosition(this.parentPosition);
        return new DomainCursor<T>(ra, this.span);
    }

    @Override
    public T get() {
        return this.parent.get();
    }

    @Override
    public void fwd() {
        for (int i = 0; i < this.position.length; ++i) {
            int n = i;
            this.position[n] = this.position[n] + 1L;
            if (this.position[i] <= this.parentPosition[i] + this.span[i]) break;
            this.position[i] = this.parentPosition[i] - this.span[i];
        }
        this.parent.setPosition(this.position);
        ++this.count;
    }

    @Override
    public void reset() {
        this.parent.setPosition(this.parentPosition);
        for (int i = 0; i < this.position.length; ++i) {
            this.position[i] = this.parentPosition[i] - this.span[i];
        }
        this.count = 0L;
        this.position[0] = this.position[0] - 1L;
    }

    public void reset(long[] currentParentPosition) {
        for (int i = 0; i < this.parentPosition.length; ++i) {
            this.parentPosition[i] = currentParentPosition[i];
        }
        this.reset();
    }

    @Override
    public boolean hasNext() {
        return this.count < this.size;
    }

    @Override
    public void localize(long[] pos) {
        for (int i = 0; i < this.position.length; ++i) {
            pos[i] = this.position[i];
        }
    }

    @Override
    public long getLongPosition(int d) {
        return this.position[d];
    }

    @Override
    public DomainCursor<T> copy() {
        return new DomainCursor<T>(this.parent, this.span);
    }

    @Override
    public DomainCursor<T> copyCursor() {
        return this.copy();
    }

    @Override
    public DomainCursor<T> localizingCursor() {
        return this.cursor();
    }
}

