/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.pde;

import java.util.Vector;
import net.imglib2.Cursor;
import net.imglib2.ExtendedRandomAccessibleInterval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.MultiThreadedBenchmarkAlgorithm;
import net.imglib2.algorithm.region.localneighborhood.LocalNeighborhoodCursor;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.multithreading.Chunk;
import net.imglib2.multithreading.SimpleMultiThreading;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;

public class PeronaMalikAnisotropicDiffusion<T extends RealType<T>>
extends MultiThreadedBenchmarkAlgorithm {
    private static final String BASE_ERROR_MESSAGE = "[" + PeronaMalikAnisotropicDiffusion.class.getSimpleName() + "] ";
    private final RandomAccessibleInterval<T> image;
    private Img<FloatType> increment;
    private double deltat;
    private DiffusionFunction fun;
    private float minVal;
    private float maxVal;

    public PeronaMalikAnisotropicDiffusion(Img<T> img, double deltat, DiffusionFunction function) {
        this(img, PeronaMalikAnisotropicDiffusion.getFloatImgFactory(img), deltat, function);
    }

    private static final <T extends Type<T>> ImgFactory<FloatType> getFloatImgFactory(Img<T> img) {
        NativeImgFactory factory;
        try {
            factory = img.factory().imgFactory(new FloatType());
        }
        catch (IncompatibleTypeException e) {
            factory = img.size() >= Integer.MAX_VALUE ? new CellImgFactory<FloatType>() : new ArrayImgFactory<FloatType>();
        }
        return factory;
    }

    public PeronaMalikAnisotropicDiffusion(RandomAccessibleInterval<T> image, ImgFactory<FloatType> factory, double deltat, DiffusionFunction function) {
        this.image = image;
        this.deltat = deltat;
        this.fun = function;
        this.processingTime = 0L;
        this.increment = factory.create(image, new FloatType());
        RealType tmp = (RealType)Views.iterable(image).firstElement();
        this.minVal = (float)tmp.getMinValue();
        this.maxVal = (float)tmp.getMaxValue();
    }

    public PeronaMalikAnisotropicDiffusion(Img<T> image, double deltat, double kappa) {
        this(image, deltat, new StrongEdgeEnhancer(kappa));
    }

    public PeronaMalikAnisotropicDiffusion(RandomAccessibleInterval<T> image, ImgFactory<FloatType> factory, double deltat, double kappa) {
        this(image, factory, deltat, new StrongEdgeEnhancer(kappa));
    }

    public boolean checkInput() {
        if (this.deltat <= 0.0) {
            this.errorMessage = "Time interval must bu strictly positive, got " + this.deltat + ".";
            return false;
        }
        return true;
    }

    public boolean process() {
        Chunk chunk;
        int ithread;
        long start = System.currentTimeMillis();
        Vector<Chunk> chunks = SimpleMultiThreading.divideIntoChunks(this.increment.size(), this.numThreads);
        Thread[] threads = SimpleMultiThreading.newThreads(this.numThreads);
        for (ithread = 0; ithread < threads.length; ++ithread) {
            chunk = chunks.get(ithread);
            threads[ithread] = new Thread("" + BASE_ERROR_MESSAGE + "thread " + ithread){

                @Override
                public void run() {
                    long[] centralPosition = new long[PeronaMalikAnisotropicDiffusion.this.image.numDimensions()];
                    long[] position = new long[PeronaMalikAnisotropicDiffusion.this.image.numDimensions()];
                    Cursor incrementCursor = PeronaMalikAnisotropicDiffusion.this.increment.localizingCursor();
                    RandomAccess ra = PeronaMalikAnisotropicDiffusion.this.image.randomAccess();
                    ExtendedRandomAccessibleInterval extendedImage = Views.extendMirrorSingle(PeronaMalikAnisotropicDiffusion.this.image);
                    LocalNeighborhoodCursor neighborhoodCursor = new LocalNeighborhoodCursor(extendedImage, centralPosition);
                    incrementCursor.jumpFwd(chunk.getStartPosition());
                    for (long j = 0L; j < chunk.getLoopSize(); ++j) {
                        incrementCursor.fwd();
                        incrementCursor.localize(centralPosition);
                        ra.setPosition(incrementCursor);
                        double centralValue = ((RealType)ra.get()).getRealFloat();
                        double amount = 0.0;
                        neighborhoodCursor.updateCenter(centralPosition);
                        while (neighborhoodCursor.hasNext()) {
                            neighborhoodCursor.fwd();
                            double dx2 = 0.0;
                            for (int dim = 0; dim < PeronaMalikAnisotropicDiffusion.this.image.numDimensions(); ++dim) {
                                position[dim] = neighborhoodCursor.getLongPosition(dim) - centralPosition[dim];
                                dx2 += (double)(position[dim] * position[dim]);
                            }
                            double di = ((RealType)neighborhoodCursor.get()).getRealDouble() - centralValue;
                            double g = PeronaMalikAnisotropicDiffusion.this.fun.eval(di, position);
                            amount += 1.0 / dx2 * g * di;
                        }
                        ((FloatType)incrementCursor.get()).setReal(PeronaMalikAnisotropicDiffusion.this.deltat * amount);
                    }
                }
            };
        }
        SimpleMultiThreading.startAndJoin(threads);
        for (ithread = 0; ithread < threads.length; ++ithread) {
            chunk = chunks.get(ithread);
            threads[ithread] = new Thread("" + BASE_ERROR_MESSAGE + "thread " + ithread){

                @Override
                public void run() {
                    Cursor incrementCursor = PeronaMalikAnisotropicDiffusion.this.increment.localizingCursor();
                    RandomAccess ra = PeronaMalikAnisotropicDiffusion.this.image.randomAccess();
                    incrementCursor.reset();
                    incrementCursor.jumpFwd(chunk.getStartPosition());
                    for (long j = 0L; j < chunk.getLoopSize(); ++j) {
                        float inc = ((FloatType)incrementCursor.next()).get();
                        ra.setPosition(incrementCursor);
                        float val = ((RealType)ra.get()).getRealFloat();
                        float sum = val + inc;
                        if (sum > PeronaMalikAnisotropicDiffusion.this.maxVal) {
                            sum = PeronaMalikAnisotropicDiffusion.this.maxVal;
                        }
                        if (sum < PeronaMalikAnisotropicDiffusion.this.minVal) {
                            sum = PeronaMalikAnisotropicDiffusion.this.minVal;
                        }
                        ((RealType)ra.get()).setReal(sum);
                    }
                }
            };
        }
        SimpleMultiThreading.startAndJoin(threads);
        long end = System.currentTimeMillis();
        this.processingTime += end - start;
        return true;
    }

    public void setDeltaT(float deltat) {
        this.deltat = deltat;
    }

    public void setDiffusionFunction(DiffusionFunction function) {
        this.fun = function;
    }

    public static final <T extends RealType<T>> Img<FloatType> toFloat(Img<T> input, double deltat, DiffusionFunction function) {
        ImgFactory<FloatType> factory = PeronaMalikAnisotropicDiffusion.getFloatImgFactory(input);
        Img<FloatType> img = PeronaMalikAnisotropicDiffusion.copy(input, factory);
        PeronaMalikAnisotropicDiffusion.inFloatInPlace(img, deltat, function);
        return img;
    }

    public static final <T extends RealType<T>> Img<FloatType> toFloat(Img<T> input, double deltat, double kappa) {
        ImgFactory<FloatType> factory = PeronaMalikAnisotropicDiffusion.getFloatImgFactory(input);
        Img<FloatType> img = PeronaMalikAnisotropicDiffusion.copy(input, factory);
        PeronaMalikAnisotropicDiffusion.inFloatInPlace(img, deltat, kappa);
        return img;
    }

    public static final <T extends RealType<T>> Img<FloatType> toFloat(RandomAccessibleInterval<T> input, ImgFactory<FloatType> factory, double deltat, DiffusionFunction function) {
        Img<FloatType> img = PeronaMalikAnisotropicDiffusion.copy(input, factory);
        PeronaMalikAnisotropicDiffusion.inFloatInPlace(img, deltat, function);
        return img;
    }

    public static final <T extends RealType<T>> Img<FloatType> toFloat(RandomAccessibleInterval<T> input, ImgFactory<FloatType> factory, double deltat, double kappa) {
        Img<FloatType> img = PeronaMalikAnisotropicDiffusion.copy(input, factory);
        PeronaMalikAnisotropicDiffusion.inFloatInPlace(img, deltat, kappa);
        return img;
    }

    public static final <T extends RealType<T>> void inFloatInPlace(Img<T> input, double deltat, DiffusionFunction function) {
        PeronaMalikAnisotropicDiffusion<T> diffusion = new PeronaMalikAnisotropicDiffusion<T>(input, deltat, function);
        diffusion.process();
    }

    public static final <T extends RealType<T>> void inFloatInPlace(Img<T> input, double deltat, double kappa) {
        PeronaMalikAnisotropicDiffusion<T> diffusion = new PeronaMalikAnisotropicDiffusion<T>(input, deltat, kappa);
        diffusion.process();
    }

    public static final <T extends RealType<T>> void inFloatInPlace(RandomAccessibleInterval<T> input, ImgFactory<FloatType> factory, double deltat, DiffusionFunction function) {
        PeronaMalikAnisotropicDiffusion<T> diffusion = new PeronaMalikAnisotropicDiffusion<T>(input, factory, deltat, function);
        diffusion.process();
    }

    public static final <T extends RealType<T>> void inFloatInPlace(RandomAccessibleInterval<T> input, ImgFactory<FloatType> factory, double deltat, double kappa) {
        PeronaMalikAnisotropicDiffusion<T> diffusion = new PeronaMalikAnisotropicDiffusion<T>(input, factory, deltat, kappa);
        diffusion.process();
    }

    protected static final <T extends RealType<T>> Img<FloatType> copy(RandomAccessibleInterval<T> input, ImgFactory<FloatType> factory) {
        Img img = factory.create(input, new FloatType());
        IterableInterval<T> iterableInput = Views.iterable(input);
        if (img.iterationOrder().equals(iterableInput.iterationOrder())) {
            Cursor out = img.cursor();
            Cursor<T> in = iterableInput.cursor();
            while (out.hasNext()) {
                out.fwd();
                in.fwd();
                ((FloatType)out.get()).set(((RealType)in.get()).getRealFloat());
            }
        } else {
            Cursor out = img.localizingCursor();
            RandomAccess in = input.randomAccess();
            while (out.hasNext()) {
                out.fwd();
                in.setPosition(out);
                ((FloatType)out.get()).set(((RealType)in.get()).getRealFloat());
            }
        }
        return img;
    }

    public static class WideRegionEnhancer
    implements DiffusionFunction {
        private double kappa;

        public WideRegionEnhancer(double kappa) {
            this.kappa = kappa;
        }

        @Override
        public double eval(double gradi, long[] position) {
            return 1.0 / (1.0 + gradi * gradi / this.kappa / this.kappa);
        }
    }

    public static class StrongEdgeEnhancer
    implements DiffusionFunction {
        private double kappa;

        public StrongEdgeEnhancer(double kappa) {
            this.kappa = kappa;
        }

        @Override
        public double eval(double gradi, long[] position) {
            return Math.exp(-(gradi * gradi / this.kappa / this.kappa));
        }
    }

    public static interface DiffusionFunction {
        public double eval(double var1, long[] var3);
    }
}

