/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.pde;

import edu.mines.jtk.la.DMatrix;
import edu.mines.jtk.la.DMatrixEvd;
import java.util.Vector;
import net.imglib2.Cursor;
import net.imglib2.ExtendedRandomAccessibleInterval;
import net.imglib2.RandomAccess;
import net.imglib2.algorithm.MultiThreadedBenchmarkAlgorithm;
import net.imglib2.algorithm.OutputAlgorithm;
import net.imglib2.algorithm.region.localneighborhood.DomainCursor;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.multithreading.Chunk;
import net.imglib2.multithreading.SimpleMultiThreading;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;

public class MomentOfInertiaTensor3D<T extends RealType<T>>
extends MultiThreadedBenchmarkAlgorithm
implements OutputAlgorithm<Img<FloatType>> {
    private static final double DEFAULT_EPSILON_1 = 1.0;
    private static final double DEFAULT_EPSILON_2 = 0.001;
    private static final String BASE_ERROR_MESSAGE = "[" + MomentOfInertiaTensor3D.class.getSimpleName() + "] ";
    private final Img<T> input;
    private final double epsilon_1;
    private final double epsilon_2;
    private final int scale;
    private Img<FloatType> D;

    public MomentOfInertiaTensor3D(Img<T> input, int scale, double epsilon_1, double epsilon_2) {
        this.input = input;
        this.scale = scale;
        this.epsilon_1 = epsilon_1;
        this.epsilon_2 = epsilon_2;
    }

    public MomentOfInertiaTensor3D(Img<T> input, int scale) {
        this(input, scale, 1.0, 0.001);
    }

    public boolean checkInput() {
        return true;
    }

    public boolean process() {
        long[] tensorDims = new long[this.input.numDimensions() + 1];
        for (int i = 0; i < this.input.numDimensions(); ++i) {
            tensorDims[i] = this.input.dimension(i);
        }
        tensorDims[this.input.numDimensions()] = 6L;
        final int tensorDim = this.input.numDimensions();
        try {
            this.D = this.input.factory().imgFactory(new FloatType()).create(tensorDims, new FloatType());
        }
        catch (IncompatibleTypeException e) {
            e.printStackTrace();
        }
        Vector<Chunk> chunks = SimpleMultiThreading.divideIntoChunks(this.input.size(), this.numThreads);
        Thread[] threads = SimpleMultiThreading.newThreads(this.numThreads);
        for (int i = 0; i < threads.length; ++i) {
            final Chunk chunk = chunks.get(i);
            threads[i] = new Thread("" + BASE_ERROR_MESSAGE + "thread " + i){

                @Override
                public void run() {
                    Cursor cursor = MomentOfInertiaTensor3D.this.input.localizingCursor();
                    RandomAccess Dcursor = MomentOfInertiaTensor3D.this.D.randomAccess();
                    ExtendedRandomAccessibleInterval ra = Views.extendMirrorSingle(MomentOfInertiaTensor3D.this.input);
                    long[] position = new long[MomentOfInertiaTensor3D.this.input.numDimensions()];
                    long[] pos = new long[MomentOfInertiaTensor3D.this.input.numDimensions()];
                    long[] domain = new long[MomentOfInertiaTensor3D.this.input.numDimensions()];
                    domain[0] = (MomentOfInertiaTensor3D.this.scale - 1) / 2;
                    domain[1] = (MomentOfInertiaTensor3D.this.scale - 1) / 2;
                    domain[2] = (MomentOfInertiaTensor3D.this.scale - 1) / 2;
                    DomainCursor neighborhood = new DomainCursor(ra.randomAccess(), domain);
                    DMatrix M = new DMatrix(3, 3);
                    cursor.jumpFwd(chunk.getStartPosition());
                    for (long j = 0L; j < chunk.getLoopSize(); ++j) {
                        cursor.fwd();
                        cursor.localize(position);
                        for (int i = 0; i < position.length; ++i) {
                            Dcursor.setPosition(position[i], i);
                        }
                        double totalmass = 0.0;
                        double cmx = 0.0;
                        double cmy = 0.0;
                        double cmz = 0.0;
                        neighborhood.reset(position);
                        while (neighborhood.hasNext()) {
                            neighborhood.fwd();
                            neighborhood.localize(pos);
                            double mass = ((RealType)neighborhood.get()).getRealDouble();
                            totalmass += mass;
                            cmx += mass * (double)pos[0];
                            cmy += mass * (double)pos[1];
                            cmz += mass * (double)pos[2];
                        }
                        if (totalmass > 0.0) {
                            cmx /= totalmass;
                            cmy /= totalmass;
                            cmz /= totalmass;
                        }
                        double Ixx = 0.0;
                        double Iyy = 0.0;
                        double Izz = 0.0;
                        double Ixy = 0.0;
                        double Ixz = 0.0;
                        double Iyz = 0.0;
                        neighborhood.reset();
                        while (neighborhood.hasNext()) {
                            neighborhood.fwd();
                            neighborhood.localize(pos);
                            double x = (double)pos[0] - cmx;
                            double y = (double)pos[1] - cmy;
                            double z = (double)pos[2] - cmz;
                            double x2 = x * x;
                            double y2 = y * y;
                            double z2 = z * z;
                            double mass = ((RealType)neighborhood.get()).getRealDouble();
                            Ixx += mass * (y2 + z2);
                            Iyy += mass * (x2 + z2);
                            Izz += mass * (x2 + y2);
                            Ixy -= mass * x * y;
                            Ixz -= mass * x * z;
                            Iyz -= mass * y * z;
                        }
                        M.set(0, 0, Ixx);
                        M.set(1, 1, Iyy);
                        M.set(2, 2, Izz);
                        M.set(0, 1, Ixy);
                        M.set(1, 0, Ixy);
                        M.set(2, 0, Ixz);
                        M.set(0, 2, Ixz);
                        M.set(2, 1, Iyz);
                        M.set(1, 2, Iyz);
                        DMatrixEvd VD = new DMatrixEvd(M);
                        DMatrix DD = VD.getD();
                        DD.set(0, 0, MomentOfInertiaTensor3D.this.epsilon_1);
                        DD.set(1, 1, MomentOfInertiaTensor3D.this.epsilon_2);
                        DD.set(2, 2, MomentOfInertiaTensor3D.this.epsilon_2);
                        DMatrix VV = VD.getV();
                        VV = VV.times(DD.times(VV.transpose()));
                        double A = VV.get(0, 0);
                        double B = VV.get(1, 1);
                        double C = VV.get(2, 2);
                        double D = VV.get(0, 1);
                        double E = VV.get(0, 2);
                        double F = VV.get(1, 2);
                        Dcursor.setPosition(0, tensorDim);
                        ((FloatType)Dcursor.get()).setReal(A);
                        Dcursor.fwd(tensorDim);
                        ((FloatType)Dcursor.get()).setReal(B);
                        Dcursor.fwd(tensorDim);
                        ((FloatType)Dcursor.get()).setReal(C);
                        Dcursor.fwd(tensorDim);
                        ((FloatType)Dcursor.get()).setReal(D);
                        Dcursor.fwd(tensorDim);
                        ((FloatType)Dcursor.get()).setReal(E);
                        Dcursor.fwd(tensorDim);
                        ((FloatType)Dcursor.get()).setReal(F);
                    }
                }
            };
        }
        SimpleMultiThreading.startAndJoin(threads);
        return true;
    }

    public Img<FloatType> getResult() {
        return this.D;
    }
}

