/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.pde;

import java.util.Vector;
import net.imglib2.Cursor;
import net.imglib2.ExtendedRandomAccessibleInterval;
import net.imglib2.RandomAccess;
import net.imglib2.algorithm.MultiThreadedBenchmarkAlgorithm;
import net.imglib2.algorithm.OutputAlgorithm;
import net.imglib2.algorithm.pde.PdeUtil;
import net.imglib2.algorithm.region.localneighborhood.DomainCursor;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.multithreading.Chunk;
import net.imglib2.multithreading.SimpleMultiThreading;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;

public class MomentOfInertiaTensor2D<T extends RealType<T>>
extends MultiThreadedBenchmarkAlgorithm
implements OutputAlgorithm<Img<FloatType>> {
    private static final double DEFAULT_EPSILON_1 = 1.0;
    private static final double DEFAULT_EPSILON_2 = 0.001;
    private static final String BASE_ERROR_MESSAGE = "[" + MomentOfInertiaTensor2D.class.getSimpleName() + "] ";
    private final Img<T> input;
    private final double epsilon_1;
    private final double epsilon_2;
    private final int scale;
    private Img<FloatType> D;

    public MomentOfInertiaTensor2D(Img<T> input, int scale, double epsilon_1, double epsilon_2) {
        this.input = input;
        this.scale = scale;
        this.epsilon_1 = epsilon_1;
        this.epsilon_2 = epsilon_2;
    }

    public MomentOfInertiaTensor2D(Img<T> input, int scale) {
        this(input, scale, 1.0, 0.001);
    }

    public boolean checkInput() {
        return true;
    }

    public boolean process() {
        long[] tensorDims = new long[this.input.numDimensions() + 1];
        for (int i = 0; i < this.input.numDimensions(); ++i) {
            tensorDims[i] = this.input.dimension(i);
        }
        tensorDims[this.input.numDimensions()] = 3L;
        final int tensorDim = this.input.numDimensions();
        try {
            this.D = this.input.factory().imgFactory(new FloatType()).create(tensorDims, new FloatType());
        }
        catch (IncompatibleTypeException e) {
            e.printStackTrace();
        }
        Vector<Chunk> chunks = SimpleMultiThreading.divideIntoChunks(this.input.size(), this.numThreads);
        Thread[] threads = SimpleMultiThreading.newThreads(this.numThreads);
        for (int i = 0; i < threads.length; ++i) {
            final Chunk chunk = chunks.get(i);
            threads[i] = new Thread("" + BASE_ERROR_MESSAGE + "thread " + i){

                @Override
                public void run() {
                    Cursor cursor = MomentOfInertiaTensor2D.this.input.localizingCursor();
                    RandomAccess Dcursor = MomentOfInertiaTensor2D.this.D.randomAccess();
                    ExtendedRandomAccessibleInterval ra = Views.extendMirrorSingle(MomentOfInertiaTensor2D.this.input);
                    long[] position = new long[MomentOfInertiaTensor2D.this.input.numDimensions()];
                    long[] pos = new long[MomentOfInertiaTensor2D.this.input.numDimensions()];
                    long[] domain = new long[MomentOfInertiaTensor2D.this.input.numDimensions()];
                    domain[0] = (MomentOfInertiaTensor2D.this.scale - 1) / 2;
                    domain[1] = (MomentOfInertiaTensor2D.this.scale - 1) / 2;
                    DomainCursor neighborhood = new DomainCursor(ra.randomAccess(), domain);
                    cursor.jumpFwd(chunk.getStartPosition());
                    for (long j = 0L; j < chunk.getLoopSize(); ++j) {
                        double lambda_2;
                        double lambda_1;
                        cursor.fwd();
                        cursor.localize(position);
                        for (int i = 0; i < position.length; ++i) {
                            Dcursor.setPosition(position[i], i);
                        }
                        double totalmass = 0.0;
                        double cmx = 0.0;
                        double cmy = 0.0;
                        neighborhood.reset(position);
                        while (neighborhood.hasNext()) {
                            neighborhood.fwd();
                            neighborhood.localize(pos);
                            double mass = ((RealType)neighborhood.get()).getRealDouble();
                            totalmass += mass;
                            cmx += mass * (double)pos[0];
                            cmy += mass * (double)pos[1];
                        }
                        if (totalmass > 0.0) {
                            cmx /= totalmass;
                            cmy /= totalmass;
                        }
                        double Ixx = 0.0;
                        double Ixy = 0.0;
                        double Iyy = 0.0;
                        neighborhood.reset();
                        while (neighborhood.hasNext()) {
                            neighborhood.fwd();
                            neighborhood.localize(pos);
                            double x = (double)pos[0] - cmx;
                            double y = (double)pos[1] - cmy;
                            double x2 = x * x;
                            double y2 = y * y;
                            double mass = ((RealType)neighborhood.get()).getRealDouble();
                            Ixx += mass * x2;
                            Iyy += mass * y2;
                            Ixy -= mass * x * y;
                        }
                        double[] arr = PdeUtil.realSymetricMatrix2x2(Ixx, Iyy, Ixy);
                        double mu_1 = arr[0];
                        double mu_2 = arr[1];
                        double cosalpha = arr[2];
                        double sinalpha = arr[3];
                        if (mu_1 == mu_2) {
                            lambda_1 = MomentOfInertiaTensor2D.this.epsilon_1;
                            lambda_2 = MomentOfInertiaTensor2D.this.epsilon_1;
                        } else {
                            lambda_1 = MomentOfInertiaTensor2D.this.epsilon_1;
                            lambda_2 = MomentOfInertiaTensor2D.this.epsilon_2;
                        }
                        double a = lambda_1 * cosalpha * cosalpha + lambda_2 * sinalpha * sinalpha;
                        double b = -(lambda_1 - lambda_2) * cosalpha * sinalpha;
                        double c = lambda_1 * sinalpha * sinalpha + lambda_2 * cosalpha * cosalpha;
                        Dcursor.setPosition(0, tensorDim);
                        ((FloatType)Dcursor.get()).setReal(a);
                        Dcursor.fwd(tensorDim);
                        ((FloatType)Dcursor.get()).setReal(b);
                        Dcursor.fwd(tensorDim);
                        ((FloatType)Dcursor.get()).setReal(c);
                    }
                }
            };
        }
        SimpleMultiThreading.startAndJoin(threads);
        return true;
    }

    public Img<FloatType> getResult() {
        return this.D;
    }
}

