/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.pde;

import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.algorithm.MultiThreadedBenchmarkAlgorithm;
import net.imglib2.algorithm.OutputAlgorithm;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.outofbounds.OutOfBoundsRandomAccess;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;

public class Gradient<T extends RealType<T>>
extends MultiThreadedBenchmarkAlgorithm
implements OutputAlgorithm<Img<FloatType>> {
    private final Img<T> input;
    private Img<FloatType> output;
    private final boolean[] doDimension;

    public Gradient(Img<T> input, boolean[] doDimension) {
        this.input = input;
        this.doDimension = doDimension;
        long[] dimensions = new long[input.numDimensions() + 1];
        for (int i = 0; i < dimensions.length - 1; ++i) {
            dimensions[i] = input.dimension(i);
        }
        dimensions[dimensions.length - 1] = input.numDimensions();
        try {
            this.output = input.factory().imgFactory(new FloatType()).create(dimensions, new FloatType());
        }
        catch (IncompatibleTypeException e) {
            e.printStackTrace();
        }
    }

    public boolean checkInput() {
        return true;
    }

    public boolean process() {
        long start = System.currentTimeMillis();
        Cursor in = this.input.localizingCursor();
        RandomAccess oc = this.output.randomAccess();
        RealType zero = (RealType)((RealType)this.input.firstElement()).createVariable();
        OutOfBoundsRandomAccess ra = Views.extendValue(this.input, zero).randomAccess();
        int newdim = this.input.numDimensions();
        while (in.hasNext()) {
            int i;
            in.fwd();
            ra.setPosition(in);
            for (i = 0; i < this.input.numDimensions(); ++i) {
                oc.setPosition(in.getLongPosition(i), i);
            }
            oc.setPosition(0, newdim);
            float central = ((RealType)in.get()).getRealFloat();
            for (i = 0; i < this.input.numDimensions(); ++i) {
                if (!this.doDimension[i]) continue;
                ra.fwd(i);
                float diff = central - ((RealType)ra.get()).getRealFloat();
                ra.bck(i);
                ((FloatType)oc.get()).set(diff);
                oc.fwd(newdim);
            }
        }
        this.processingTime = System.currentTimeMillis() - start;
        return true;
    }

    public Img<FloatType> getResult() {
        return this.output;
    }
}

