/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.fft;

import net.imglib2.util.Util;

public class PhaseCorrelationPeak
implements Comparable<PhaseCorrelationPeak> {
    long[] position = null;
    long[] originalInvPCMPosition = null;
    float phaseCorrelationPeak = 0.0f;
    float crossCorrelationPeak = 0.0f;
    long numPixels = 0L;
    boolean sortPhaseCorrelation = true;

    public PhaseCorrelationPeak(long[] position, float phaseCorrelationPeak, float crossCorrelationPeak) {
        this.position = (long[])position.clone();
        this.phaseCorrelationPeak = phaseCorrelationPeak;
        this.crossCorrelationPeak = crossCorrelationPeak;
    }

    public PhaseCorrelationPeak(long[] position, float phaseCorrelationPeak) {
        this(position, phaseCorrelationPeak, 0.0f);
    }

    public PhaseCorrelationPeak(long[] position) {
        this(position, 0.0f, 0.0f);
    }

    public PhaseCorrelationPeak() {
        this(null, 0.0f, 0.0f);
    }

    public void setPosition(long[] position) {
        this.position = (long[])position.clone();
    }

    public void setOriginalInvPCMPosition(long[] originalInvPCMPosition) {
        this.originalInvPCMPosition = originalInvPCMPosition;
    }

    public void setPhaseCorrelationPeak(float phaseCorrelationPeak) {
        this.phaseCorrelationPeak = phaseCorrelationPeak;
    }

    public void setCrossCorrelationPeak(float crossCorrelationPeak) {
        this.crossCorrelationPeak = crossCorrelationPeak;
    }

    public void setSortPhaseCorrelation(boolean sortPhaseCorrelation) {
        this.sortPhaseCorrelation = sortPhaseCorrelation;
    }

    public void setNumPixels(long numPixels) {
        this.numPixels = numPixels;
    }

    public long[] getPosition() {
        return (long[])this.position.clone();
    }

    public long[] getOriginalInvPCMPosition() {
        return this.originalInvPCMPosition;
    }

    public float getPhaseCorrelationPeak() {
        return this.phaseCorrelationPeak;
    }

    public float getCrossCorrelationPeak() {
        return this.crossCorrelationPeak;
    }

    public boolean getSortPhaseCorrelation() {
        return this.sortPhaseCorrelation;
    }

    public long getNumPixels() {
        return this.numPixels;
    }

    @Override
    public int compareTo(PhaseCorrelationPeak o) {
        if (this.sortPhaseCorrelation) {
            if (this.phaseCorrelationPeak > o.phaseCorrelationPeak) {
                return 1;
            }
            if (this.phaseCorrelationPeak == o.phaseCorrelationPeak) {
                return 0;
            }
            return -1;
        }
        if (this.crossCorrelationPeak > o.crossCorrelationPeak) {
            return 1;
        }
        if (this.crossCorrelationPeak == o.crossCorrelationPeak) {
            if (this.numPixels >= o.numPixels) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public String toString() {
        if (this.originalInvPCMPosition == null) {
            return Util.printCoordinates(this.position) + ", phaseCorrelationPeak = " + this.phaseCorrelationPeak + ", crossCorrelationPeak = " + this.crossCorrelationPeak;
        }
        return Util.printCoordinates(this.position) + " [" + Util.printCoordinates(this.originalInvPCMPosition) + "], phaseCorrelationPeak = " + this.phaseCorrelationPeak + ", crossCorrelationPeak = " + this.crossCorrelationPeak;
    }
}

