/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.fft;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import net.imglib2.Cursor;
import net.imglib2.ExtendedRandomAccessibleInterval;
import net.imglib2.algorithm.Algorithm;
import net.imglib2.algorithm.Benchmark;
import net.imglib2.algorithm.MultiThreaded;
import net.imglib2.algorithm.fft.FourierTransform;
import net.imglib2.algorithm.fft.InverseFourierTransform;
import net.imglib2.algorithm.fft.LocalNeighborhoodCursor;
import net.imglib2.algorithm.fft.PhaseCorrelationPeak;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.multithreading.SimpleMultiThreading;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.complex.ComplexFloatType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import net.imglib2.view.RandomAccessibleIntervalCursor;
import net.imglib2.view.Views;

public class PhaseCorrelation<T extends RealType<T>, S extends RealType<S>>
implements MultiThreaded,
Algorithm,
Benchmark {
    final int numDimensions;
    boolean computeFFTinParalell = true;
    boolean keepInvFFT = false;
    Img<T> image1;
    Img<S> image2;
    Img<FloatType> invPCM;
    int numPeaks;
    int[] minOverlapPx;
    float normalizationThreshold;
    boolean verifyWithCrossCorrelation;
    ArrayList<PhaseCorrelationPeak> phaseCorrelationPeaks;
    String errorMessage = "";
    int numThreads;
    long processingTime;

    public PhaseCorrelation(Img<T> image1, Img<S> image2, int numPeaks, boolean verifyWithCrossCorrelation) {
        this.image1 = image1;
        this.image2 = image2;
        this.numPeaks = numPeaks;
        this.verifyWithCrossCorrelation = verifyWithCrossCorrelation;
        this.numDimensions = image1.numDimensions();
        this.normalizationThreshold = 1.0E-5f;
        this.minOverlapPx = new int[this.numDimensions];
        this.setMinimalPixelOverlap(3);
        this.setNumThreads();
        this.processingTime = -1L;
    }

    public PhaseCorrelation(Img<T> image1, Img<S> image2) {
        this(image1, image2, 5, true);
    }

    public void setKeepPCM(boolean keep) {
        this.keepInvFFT = keep;
    }

    public void setComputeFFTinParalell(boolean computeFFTinParalell) {
        this.computeFFTinParalell = computeFFTinParalell;
    }

    public void setInvestigateNumPeaks(int numPeaks) {
        this.numPeaks = numPeaks;
    }

    public void setNormalizationThreshold(int normalizationThreshold) {
        this.normalizationThreshold = normalizationThreshold;
    }

    public void setVerifyWithCrossCorrelation(boolean verifyWithCrossCorrelation) {
        this.verifyWithCrossCorrelation = verifyWithCrossCorrelation;
    }

    public void setMinimalPixelOverlap(int[] minOverlapPx) {
        this.minOverlapPx = (int[])minOverlapPx.clone();
    }

    public void setMinimalPixelOverlap(int minOverlapPx) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.minOverlapPx[d] = minOverlapPx;
        }
    }

    public Img<FloatType> getPCM() {
        return this.invPCM;
    }

    public boolean getKeepPCM() {
        return this.keepInvFFT;
    }

    public boolean getComputeFFTinParalell() {
        return this.computeFFTinParalell;
    }

    public int getInvestigateNumPeaks() {
        return this.numPeaks;
    }

    public float getNormalizationThreshold() {
        return this.normalizationThreshold;
    }

    public boolean getVerifyWithCrossCorrelation() {
        return this.verifyWithCrossCorrelation;
    }

    public int[] getMinimalPixelOverlap() {
        return (int[])this.minOverlapPx.clone();
    }

    public PhaseCorrelationPeak getShift() {
        return this.phaseCorrelationPeaks.get(this.phaseCorrelationPeaks.size() - 1);
    }

    public ArrayList<PhaseCorrelationPeak> getAllShifts() {
        return this.phaseCorrelationPeaks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process() {
        long startTime = System.currentTimeMillis();
        try {
            InverseFourierTransform invFFT;
            int d;
            FourierTransform<S, ComplexFloatType> fft2;
            FourierTransform<T, ComplexFloatType> fft1;
            int[] maxDim = PhaseCorrelation.getMaxDim(this.image1, this.image2);
            try {
                fft1 = new FourierTransform<T, ComplexFloatType>(this.image1, new ComplexFloatType());
                fft2 = new FourierTransform<S, ComplexFloatType>(this.image2, new ComplexFloatType());
            }
            catch (IncompatibleTypeException e) {
                e.printStackTrace();
                boolean bl = false;
                this.processingTime = System.currentTimeMillis() - startTime;
                return bl;
            }
            fft1.setRelativeImageExtension(0.1f);
            fft2.setRelativeImageExtension(0.1f);
            fft1.setRelativeFadeOutDistance(0.1f);
            fft2.setRelativeFadeOutDistance(0.1f);
            fft1.setRearrangement(FourierTransform.Rearrangement.UNCHANGED);
            fft2.setRearrangement(FourierTransform.Rearrangement.UNCHANGED);
            boolean sizeFound = false;
            do {
                sizeFound = true;
                fft1.setExtendedOriginalImageSize(maxDim);
                fft2.setExtendedOriginalImageSize(maxDim);
                for (d = 0; d < this.numDimensions; d += 1) {
                    int diff = Math.abs(fft1.getExtendedSize()[d] - fft2.getExtendedSize()[d]);
                    if (diff <= 0) continue;
                    int n = d;
                    maxDim[n] = maxDim[n] + diff;
                    sizeFound = false;
                }
            } while (!sizeFound);
            if (!fft1.checkInput()) {
                this.errorMessage = "Fourier Transform of first image failed: " + fft1.getErrorMessage();
                d = 0;
                return d != 0;
            }
            if (!fft2.checkInput()) {
                this.errorMessage = "Fourier Transform of second image failed: " + fft2.getErrorMessage();
                d = 0;
                return d != 0;
            }
            if (!this.computeFFT(fft1, fft2)) {
                this.errorMessage = "Fourier Transform of failed: fft1=" + fft1.getErrorMessage() + " fft2=" + fft2.getErrorMessage();
                d = 0;
                return d != 0;
            }
            Object fftImage1 = fft1.getResult();
            Object fftImage2 = fft2.getResult();
            this.normalizeAndConjugate((Img<ComplexFloatType>)fftImage1, (Img<ComplexFloatType>)fftImage2);
            this.multiplyInPlace((Img<ComplexFloatType>)fftImage1, (Img<ComplexFloatType>)fftImage2);
            try {
                invFFT = new InverseFourierTransform(fftImage1, fft1, new FloatType());
            }
            catch (Exception e) {
                e.printStackTrace();
                boolean bl = false;
                this.processingTime = System.currentTimeMillis() - startTime;
                return bl;
            }
            invFFT.setCropBackToOriginalSize(false);
            if (!invFFT.checkInput() || !invFFT.process()) {
                this.errorMessage = "Inverse Fourier Transform of failed: " + invFFT.getErrorMessage();
                boolean bl = false;
                return bl;
            }
            this.invPCM = invFFT.getResult();
            this.phaseCorrelationPeaks = this.extractPhaseCorrelationPeaks(this.invPCM, this.numPeaks, fft1, fft2);
            if (!this.verifyWithCrossCorrelation) {
                boolean bl = true;
                return bl;
            }
            this.verifyWithCrossCorrelation(this.phaseCorrelationPeaks, Util.intervalDimensions(this.invPCM), this.image1, this.image2);
            if (!this.keepInvFFT) {
                this.invPCM = null;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.processingTime = System.currentTimeMillis() - startTime;
        }
    }

    protected void verifyWithCrossCorrelation(ArrayList<PhaseCorrelationPeak> peakList, long[] dimInvPCM, Img<T> img1, Img<S> img2) {
        boolean[][] coordinates = Util.getRecursiveCoordinates(this.numDimensions);
        final ArrayList<PhaseCorrelationPeak> newPeakList = new ArrayList<PhaseCorrelationPeak>();
        for (PhaseCorrelationPeak peak : peakList) {
            for (int i = 0; i < coordinates.length; ++i) {
                boolean[] currentPossiblity = coordinates[i];
                long[] peakPosition = peak.getPosition();
                for (int d = 0; d < currentPossiblity.length; ++d) {
                    if (!currentPossiblity[d]) continue;
                    if (peakPosition[d] < 0L) {
                        int n = d;
                        peakPosition[n] = peakPosition[n] + dimInvPCM[d];
                        continue;
                    }
                    int n = d;
                    peakPosition[n] = peakPosition[n] - dimInvPCM[d];
                }
                newPeakList.add(new PhaseCorrelationPeak(peakPosition, peak.getPhaseCorrelationPeak()));
            }
        }
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads(this.getNumThreads());
        final int numThreads = threads.length;
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    for (int i = 0; i < newPeakList.size(); ++i) {
                        if (i % numThreads != myNumber) continue;
                        PhaseCorrelationPeak peak = (PhaseCorrelationPeak)newPeakList.get(i);
                        long[] numPixels = new long[1];
                        peak.setCrossCorrelationPeak((float)PhaseCorrelation.testCrossCorrelation(peak.getPosition(), PhaseCorrelation.this.image1, PhaseCorrelation.this.image2, PhaseCorrelation.this.minOverlapPx, numPixels));
                        peak.setNumPixels(numPixels[0]);
                        peak.setSortPhaseCorrelation(false);
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin(threads);
        peakList.clear();
        peakList.addAll(newPeakList);
        Collections.sort(peakList);
    }

    public static <T extends RealType<T>, S extends RealType<S>> double testCrossCorrelation(long[] shift, Img<T> image1, Img<S> image2) {
        return PhaseCorrelation.testCrossCorrelation(shift, image1, image2, 5);
    }

    public static <T extends RealType<T>, S extends RealType<S>> double testCrossCorrelation(long[] shift, Img<T> image1, Img<S> image2, int minOverlapPx) {
        return PhaseCorrelation.testCrossCorrelation(shift, image1, image2, minOverlapPx, null);
    }

    public static <T extends RealType<T>, S extends RealType<S>> double testCrossCorrelation(long[] shift, Img<T> image1, Img<S> image2, int minOverlapPx, long[] numPixels) {
        return PhaseCorrelation.testCrossCorrelation(shift, image1, image2, Util.getArrayFromValue(minOverlapPx, image1.numDimensions()), numPixels);
    }

    public static <T extends RealType<T>, S extends RealType<S>> double testCrossCorrelation(long[] shift, Img<T> image1, Img<S> image2, int[] minOverlapPx) {
        return PhaseCorrelation.testCrossCorrelation(shift, image1, image2, minOverlapPx, null);
    }

    public static <T extends RealType<T>, S extends RealType<S>> double testCrossCorrelation(long[] shift, Img<T> image1, Img<S> image2, int[] minOverlapPx, long[] numPixels) {
        int numDimensions = image1.numDimensions();
        double correlationCoefficient = 0.0;
        long[] overlapSize = new long[numDimensions];
        long[] offsetImage1 = new long[numDimensions];
        long[] offsetImage2 = new long[numDimensions];
        long numPx = 1L;
        for (int d = 0; d < numDimensions; ++d) {
            if (shift[d] >= 0L) {
                if (shift[d] >= image1.dimension(d)) {
                    if (numPixels != null && numPixels.length > 0) {
                        numPixels[0] = 0L;
                    }
                    return 0.0;
                }
                offsetImage1[d] = shift[d];
                offsetImage2[d] = 0L;
                overlapSize[d] = Math.min(image1.dimension(d) - shift[d], image2.dimension(d));
            } else {
                if (shift[d] >= image2.dimension(d)) {
                    if (numPixels != null && numPixels.length > 0) {
                        numPixels[0] = 0L;
                    }
                    return 0.0;
                }
                offsetImage1[d] = 0L;
                offsetImage2[d] = -shift[d];
                overlapSize[d] = Math.min(image2.dimension(d) + shift[d], image1.dimension(d));
            }
            numPx *= overlapSize[d];
            if (overlapSize[d] >= (long)minOverlapPx[d]) continue;
            if (numPixels != null && numPixels.length > 0) {
                numPixels[0] = 0L;
            }
            return 0.0;
        }
        if (numPixels != null && numPixels.length > 0) {
            numPixels[0] = numPx;
        }
        long[] endImage1 = new long[offsetImage1.length];
        for (int i = 0; i < endImage1.length; ++i) {
            endImage1[i] = offsetImage1[i] + overlapSize[i] - 1L;
        }
        long[] endImage2 = new long[offsetImage2.length];
        for (int i = 0; i < endImage2.length; ++i) {
            endImage2[i] = offsetImage2[i] + overlapSize[i] - 1L;
        }
        RandomAccessibleIntervalCursor roiCursor1 = new RandomAccessibleIntervalCursor(Views.interval(image1, offsetImage1, endImage1));
        RandomAccessibleIntervalCursor roiCursor2 = new RandomAccessibleIntervalCursor(Views.interval(image2, offsetImage2, endImage2));
        double avg1 = 0.0;
        double avg2 = 0.0;
        while (roiCursor1.hasNext()) {
            roiCursor1.fwd();
            roiCursor2.fwd();
            avg1 += (double)((RealType)roiCursor1.get()).getRealFloat();
            avg2 += (double)((RealType)roiCursor2.get()).getRealFloat();
        }
        avg1 /= (double)numPx;
        avg2 /= (double)numPx;
        roiCursor1.reset();
        roiCursor2.reset();
        double var1 = 0.0;
        double var2 = 0.0;
        double coVar = 0.0;
        while (roiCursor1.hasNext()) {
            roiCursor1.fwd();
            roiCursor2.fwd();
            float pixel1 = ((RealType)roiCursor1.get()).getRealFloat();
            float pixel2 = ((RealType)roiCursor2.get()).getRealFloat();
            double dist1 = (double)pixel1 - avg1;
            double dist2 = (double)pixel2 - avg2;
            coVar += dist1 * dist2;
            var1 += dist1 * dist1;
            var2 += dist2 * dist2;
        }
        coVar /= (double)numPx;
        double stDev1 = Math.sqrt(var1 /= (double)numPx);
        double stDev2 = Math.sqrt(var2 /= (double)numPx);
        if (stDev1 == 0.0 || stDev2 == 0.0) {
            if (stDev1 == stDev2 && avg1 == avg2) {
                return 1.0;
            }
            return 0.0;
        }
        correlationCoefficient = coVar / (stDev1 * stDev2);
        return correlationCoefficient;
    }

    protected ArrayList<PhaseCorrelationPeak> extractPhaseCorrelationPeaks(Img<FloatType> invPCM, int numPeaks, FourierTransform<?, ?> fft1, FourierTransform<?, ?> fft2) {
        ArrayList<PhaseCorrelationPeak> peakList = new ArrayList<PhaseCorrelationPeak>();
        for (int i = 0; i < numPeaks; ++i) {
            peakList.add(new PhaseCorrelationPeak(new long[this.numDimensions], -3.4028235E38f));
        }
        Cursor cursor = invPCM.cursor();
        ExtendedRandomAccessibleInterval extendedInvPCM = Views.extendPeriodic(invPCM);
        LocalNeighborhoodCursor localCursor = new LocalNeighborhoodCursor(extendedInvPCM.randomAccess(), 1L);
        int[] originalOffset1 = fft1.getOriginalOffset();
        int[] originalOffset2 = fft2.getOriginalOffset();
        int[] offset = new int[this.numDimensions];
        for (int d = 0; d < this.numDimensions; ++d) {
            offset[d] = originalOffset2[d] - originalOffset1[d];
        }
        long[] imgSize = Util.intervalDimensions(invPCM);
        long[] position = new long[invPCM.numDimensions()];
        while (cursor.hasNext()) {
            cursor.fwd();
            cursor.localize(position);
            localCursor.reset(position);
            float value = ((FloatType)cursor.get()).get();
            boolean isMax = true;
            while (localCursor.hasNext() && isMax) {
                localCursor.fwd();
                isMax = ((FloatType)cursor.get()).get() <= value;
            }
            if (!isMax) continue;
            float lowestValue = Float.MAX_VALUE;
            int lowestValueIndex = -1;
            for (int i = 0; i < numPeaks; ++i) {
                float v = peakList.get(i).getPhaseCorrelationPeak();
                if (!(v < lowestValue)) continue;
                lowestValue = v;
                lowestValueIndex = i;
            }
            if (!(value > lowestValue)) continue;
            peakList.remove(lowestValueIndex);
            cursor.localize(position);
            for (int d = 0; d < this.numDimensions; ++d) {
                position[d] = (position[d] + (long)offset[d]) % imgSize[d];
                if (position[d] <= imgSize[d] / 2L) continue;
                position[d] = position[d] - imgSize[d];
            }
            PhaseCorrelationPeak pcp = new PhaseCorrelationPeak(position, value);
            pcp.setOriginalInvPCMPosition(position);
            peakList.add(pcp);
        }
        Collections.sort(peakList);
        return peakList;
    }

    protected static int[] getMaxDim(Img<?> image1, Img<?> image2) {
        int[] maxDim = new int[image1.numDimensions()];
        for (int d = 0; d < image1.numDimensions(); ++d) {
            maxDim[d] = (int)Math.max(image1.dimension(d), image2.dimension(d));
        }
        return maxDim;
    }

    protected void multiplyInPlace(Img<ComplexFloatType> fftImage1, Img<ComplexFloatType> fftImage2) {
        Cursor cursor1 = fftImage1.cursor();
        Cursor cursor2 = fftImage2.cursor();
        while (cursor1.hasNext()) {
            cursor1.fwd();
            cursor2.fwd();
            ((ComplexFloatType)cursor1.get()).mul((ComplexFloatType)cursor2.get());
        }
    }

    protected void normalizeAndConjugate(final Img<ComplexFloatType> fftImage1, final Img<ComplexFloatType> fftImage2) {
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads(Math.min(2, this.numThreads));
        final int numThreads = threads.length;
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    if (numThreads == 1) {
                        PhaseCorrelation.normalizeComplexImage(fftImage1, PhaseCorrelation.this.normalizationThreshold);
                        PhaseCorrelation.normalizeAndConjugateComplexImage(fftImage2, PhaseCorrelation.this.normalizationThreshold);
                    } else if (myNumber == 0) {
                        PhaseCorrelation.normalizeComplexImage(fftImage1, PhaseCorrelation.this.normalizationThreshold);
                    } else {
                        PhaseCorrelation.normalizeAndConjugateComplexImage(fftImage2, PhaseCorrelation.this.normalizationThreshold);
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin(threads);
    }

    private static final void normalizeComplexImage(Img<ComplexFloatType> fftImage, float normalizationThreshold) {
        Cursor cursor = fftImage.cursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            PhaseCorrelation.normalizeLength((ComplexFloatType)cursor.get(), normalizationThreshold);
        }
    }

    private static final void normalizeAndConjugateComplexImage(Img<ComplexFloatType> fftImage, float normalizationThreshold) {
        Cursor cursor = fftImage.cursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            PhaseCorrelation.normalizeLength((ComplexFloatType)cursor.get(), normalizationThreshold);
            ((ComplexFloatType)cursor.get()).complexConjugate();
        }
    }

    private static void normalizeLength(ComplexFloatType type, float threshold) {
        float complex;
        float real = type.getRealFloat();
        float length = (float)Math.sqrt(real * real + (complex = type.getImaginaryFloat()) * complex);
        if (length < threshold) {
            type.setReal(0.0f);
            type.setImaginary(0.0f);
        } else {
            type.setReal(real / length);
            type.setImaginary(complex / length);
        }
    }

    protected boolean computeFFT(final FourierTransform<T, ComplexFloatType> fft1, final FourierTransform<S, ComplexFloatType> fft2) {
        int minThreads = this.computeFFTinParalell ? 2 : 1;
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads(Math.min(minThreads, this.numThreads));
        final int numThreads = threads.length;
        final boolean[] sucess = new boolean[2];
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    if (numThreads == 1) {
                        fft1.setNumThreads(PhaseCorrelation.this.getNumThreads());
                        fft2.setNumThreads(PhaseCorrelation.this.getNumThreads());
                        sucess[0] = fft1.process();
                        sucess[1] = fft2.process();
                    } else if (myNumber == 0) {
                        fft1.setNumThreads(PhaseCorrelation.this.getNumThreads() / 2);
                        sucess[0] = fft1.process();
                    } else {
                        fft2.setNumThreads(PhaseCorrelation.this.getNumThreads() / 2);
                        sucess[1] = fft2.process();
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin(threads);
        return sucess[0] && sucess[1];
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.image1 == null || this.image2 == null) {
            this.errorMessage = "One of the input images is null";
            return false;
        }
        if (this.image1.numDimensions() != this.image2.numDimensions()) {
            this.errorMessage = "Dimensionality of images is not the same";
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

