/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.fft;

import edu.mines.jtk.dsp.FftComplex;
import edu.mines.jtk.dsp.FftReal;
import java.util.concurrent.atomic.AtomicInteger;
import net.imglib2.ExtendedRandomAccessibleInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.iterator.LocalizingZeroMinIntervalIterator;
import net.imglib2.multithreading.SimpleMultiThreading;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;

public final class FFTFunctions {
    public static final <T extends RealType<T>, S extends ComplexType<S>> Img<T> computeInverseFFT(final RandomAccessibleInterval<S> complex, ImgFactory<T> imgFactory, T type, final int numThreads, final boolean scale, final boolean cropBack, final int[] originalSize, final int[] originalOffset, final float additionalNormalization) {
        if (complex == null) {
            return null;
        }
        final int numDimensions = complex.numDimensions();
        int nfft = ((int)complex.dimension(0) - 1) * 2;
        final int[] dimensionsReal = new int[numDimensions];
        for (int d = 0; d < numDimensions; ++d) {
            dimensionsReal[d] = (int)complex.dimension(d);
        }
        dimensionsReal[0] = nfft;
        final Img<T> realImage = cropBack ? imgFactory.create(originalSize, type) : imgFactory.create(dimensionsReal, type);
        if (realImage == null) {
            return null;
        }
        for (int d = numDimensions - 1; d > 0; --d) {
            final int dim = d;
            final AtomicInteger ai = new AtomicInteger();
            Thread[] threads = SimpleMultiThreading.newThreads(numThreads);
            for (int ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int myNumber = ai.getAndIncrement();
                        int size = (int)complex.dimension(dim);
                        float[] tempIn = new float[size * 2];
                        FftComplex fftc = new FftComplex(size);
                        RandomAccess cursor = complex.randomAccess();
                        int[] fakeSize = new int[numDimensions - 1];
                        int[] tmp = new int[numDimensions];
                        int countDim = 0;
                        for (int d = 0; d < numDimensions; ++d) {
                            if (d == dim) continue;
                            fakeSize[countDim++] = (int)complex.dimension(d);
                        }
                        LocalizingZeroMinIntervalIterator cursorDim = new LocalizingZeroMinIntervalIterator(fakeSize);
                        float[] tempOut = new float[size * 2];
                        while (cursorDim.hasNext()) {
                            int i;
                            cursorDim.fwd();
                            if (cursorDim.getIntPosition(0) % numThreads != myNumber) continue;
                            cursorDim.localize(fakeSize);
                            tmp[dim] = (int)complex.min(dim);
                            countDim = 0;
                            for (int d = 0; d < numDimensions; ++d) {
                                if (d == dim) continue;
                                tmp[d] = fakeSize[countDim++] + (int)complex.min(d);
                            }
                            cursor.setPosition(tmp);
                            for (i = 0; i < size - 1; ++i) {
                                tempIn[i * 2] = ((ComplexType)cursor.get()).getRealFloat();
                                tempIn[i * 2 + 1] = ((ComplexType)cursor.get()).getImaginaryFloat();
                                cursor.fwd(dim);
                            }
                            tempIn[(size - 1) * 2] = ((ComplexType)cursor.get()).getRealFloat();
                            tempIn[(size - 1) * 2 + 1] = ((ComplexType)cursor.get()).getImaginaryFloat();
                            fftc.complexToComplex(1, tempIn, tempOut);
                            cursor.setPosition(tmp);
                            if (scale) {
                                for (i = 0; i < size - 1; ++i) {
                                    ((ComplexType)cursor.get()).setComplexNumber(tempOut[i * 2] / (float)size, tempOut[i * 2 + 1] / (float)size);
                                    cursor.fwd(dim);
                                }
                                ((ComplexType)cursor.get()).setComplexNumber(tempOut[(size - 1) * 2] / (float)size, tempOut[(size - 1) * 2 + 1] / (float)size);
                                continue;
                            }
                            for (i = 0; i < size - 1; ++i) {
                                ((ComplexType)cursor.get()).setComplexNumber(tempOut[i * 2], tempOut[i * 2 + 1]);
                                cursor.fwd(dim);
                            }
                            ((ComplexType)cursor.get()).setComplexNumber(tempOut[(size - 1) * 2], tempOut[(size - 1) * 2 + 1]);
                        }
                    }
                });
            }
            SimpleMultiThreading.startAndJoin(threads);
        }
        final AtomicInteger ai = new AtomicInteger();
        Thread[] threads = SimpleMultiThreading.newThreads(numThreads);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int cropX2;
                    int cropX1;
                    int myNumber = ai.getAndIncrement();
                    int realSize = dimensionsReal[0];
                    int complexSize = (int)complex.dimension(0);
                    float[] tempIn = new float[complexSize * 2];
                    FftReal fft = new FftReal(realSize);
                    if (cropBack) {
                        cropX1 = originalOffset[0];
                        cropX2 = originalOffset[0] + originalSize[0];
                    } else {
                        cropX1 = 0;
                        cropX2 = realSize;
                    }
                    RandomAccess cursor = complex.randomAccess();
                    RandomAccess cursorOut = realImage.randomAccess();
                    if (numDimensions > 1) {
                        int[] fakeSize = new int[numDimensions - 1];
                        int[] tmp = new int[numDimensions];
                        for (int d = 1; d < numDimensions; ++d) {
                            fakeSize[d - 1] = (int)complex.dimension(d);
                        }
                        LocalizingZeroMinIntervalIterator cursorDim = new LocalizingZeroMinIntervalIterator(fakeSize);
                        float[] tempOut = new float[realSize];
                        block1: while (cursorDim.hasNext()) {
                            int x;
                            int d;
                            cursorDim.fwd();
                            if (cursorDim.getIntPosition(0) % numThreads != myNumber) continue;
                            cursorDim.localize(fakeSize);
                            tmp[0] = (int)complex.min(0);
                            if (cropBack) {
                                for (d = 1; d < numDimensions; ++d) {
                                    tmp[d] = fakeSize[d - 1];
                                    if (tmp[d] < originalOffset[d] || tmp[d] >= originalOffset[d] + originalSize[d]) continue block1;
                                    int n = d;
                                    tmp[n] = tmp[n] + (int)complex.min(d);
                                }
                            } else {
                                for (d = 1; d < numDimensions; ++d) {
                                    tmp[d] = fakeSize[d - 1] + (int)complex.min(d);
                                }
                            }
                            cursor.setPosition(tmp);
                            for (int i = 0; i < complexSize - 1; ++i) {
                                tempIn[i * 2] = ((ComplexType)cursor.get()).getRealFloat();
                                tempIn[i * 2 + 1] = ((ComplexType)cursor.get()).getImaginaryFloat();
                                cursor.fwd(0);
                            }
                            tempIn[(complexSize - 1) * 2] = ((ComplexType)cursor.get()).getImaginaryFloat();
                            tempIn[(complexSize - 1) * 2 + 1] = ((ComplexType)cursor.get()).getImaginaryFloat();
                            fft.complexToReal(1, tempIn, tempOut);
                            tmp[0] = tmp[0] - (int)complex.min(0);
                            if (cropBack) {
                                for (d = 1; d < numDimensions; ++d) {
                                    int n = d;
                                    tmp[n] = tmp[n] - (originalOffset[d] + (int)complex.min(d));
                                }
                            }
                            cursorOut.setPosition(tmp);
                            if (scale) {
                                for (x = cropX1; x < cropX2 - 1; ++x) {
                                    ((RealType)cursorOut.get()).setReal(tempOut[x] / (float)realSize * additionalNormalization);
                                    cursorOut.fwd(0);
                                }
                                ((RealType)cursorOut.get()).setReal(tempOut[cropX2 - 1] / (float)realSize * additionalNormalization);
                                continue;
                            }
                            for (x = cropX1; x < cropX2 - 1; ++x) {
                                ((RealType)cursorOut.get()).setReal(tempOut[x] * additionalNormalization);
                                cursorOut.fwd(0);
                            }
                            ((RealType)cursorOut.get()).setReal(tempOut[cropX2 - 1] * additionalNormalization);
                        }
                    } else if (myNumber == 0) {
                        cursor.setPosition((int)complex.min(0), 0);
                        for (int i = 0; i < complexSize - 1; ++i) {
                            tempIn[i * 2] = ((ComplexType)cursor.get()).getRealFloat();
                            tempIn[i * 2 + 1] = ((ComplexType)cursor.get()).getImaginaryFloat();
                            cursor.fwd(0);
                        }
                        tempIn[(complexSize - 1) * 2] = ((ComplexType)cursor.get()).getRealFloat();
                        tempIn[(complexSize - 1) * 2 + 1] = ((ComplexType)cursor.get()).getImaginaryFloat();
                        float[] tempOut = new float[realSize];
                        fft.complexToReal(1, tempIn, tempOut);
                        cursorOut.setPosition(0, 0);
                        if (scale) {
                            for (int x = cropX1; x < cropX2 - 1; ++x) {
                                ((RealType)cursorOut.get()).setReal(tempOut[x] / (float)realSize * additionalNormalization);
                                cursorOut.fwd(0);
                            }
                            ((RealType)cursorOut.get()).setReal(tempOut[cropX2 - 1] / (float)realSize * additionalNormalization);
                        } else {
                            for (int x = cropX1; x < cropX2 - 1; ++x) {
                                ((RealType)cursorOut.get()).setReal(tempOut[x] * additionalNormalization);
                                cursorOut.fwd(0);
                            }
                            ((RealType)cursorOut.get()).setReal(tempOut[cropX2 - 1] * additionalNormalization);
                        }
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin(threads);
        return realImage;
    }

    public static final <T extends RealType<T>, S extends ComplexType<S>> Img<S> computeFFT(final RandomAccessibleInterval<T> input, ImgFactory<S> imgFactory, S complexType, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory, final int[] imageOffset, final int[] imageSize, final int numThreads, final boolean scale) {
        final int numDimensions = input.numDimensions();
        final ExtendedRandomAccessibleInterval<T, RandomAccessibleInterval<T>> extendedInput = Views.extend(input, outOfBoundsFactory);
        int[] complexSize = new int[numDimensions];
        complexSize[0] = imageSize[0] / 2 + 1;
        for (int d = 1; d < numDimensions; ++d) {
            complexSize[d] = imageSize[d];
        }
        final Img<S> fftImage = imgFactory.create(complexSize, complexType);
        if (fftImage == null) {
            return null;
        }
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads(numThreads);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    int realSize = imageSize[0];
                    int complexSize = (int)fftImage.dimension(0);
                    float[] tempIn = new float[realSize];
                    FftReal fft = new FftReal(realSize);
                    RandomAccess cursor = extendedInput.randomAccess();
                    RandomAccess cursorOut = fftImage.randomAccess();
                    if (numDimensions > 1) {
                        int[] fakeSize = new int[numDimensions - 1];
                        int[] tmp = new int[numDimensions];
                        int[] tmp2 = new int[numDimensions];
                        for (int d = 1; d < numDimensions; ++d) {
                            fakeSize[d - 1] = imageSize[d];
                        }
                        LocalizingZeroMinIntervalIterator cursorDim = new LocalizingZeroMinIntervalIterator(fakeSize);
                        float[] tempOut = new float[complexSize * 2];
                        while (cursorDim.hasNext()) {
                            int x;
                            cursorDim.fwd();
                            if (cursorDim.getIntPosition(0) % numThreads != myNumber) continue;
                            cursorDim.localize(fakeSize);
                            tmp[0] = 0;
                            tmp2[0] = -imageOffset[0] + (int)input.min(0);
                            for (int d = 1; d < numDimensions; ++d) {
                                tmp[d] = fakeSize[d - 1];
                                tmp2[d] = fakeSize[d - 1] - imageOffset[d] + (int)input.min(d);
                            }
                            cursor.setPosition(tmp2);
                            for (x = 0; x < realSize - 1; ++x) {
                                tempIn[x] = ((RealType)cursor.get()).getRealFloat();
                                cursor.fwd(0);
                            }
                            tempIn[realSize - 1] = ((RealType)cursor.get()).getRealFloat();
                            fft.realToComplex(-1, tempIn, tempOut);
                            cursorOut.setPosition(tmp);
                            if (scale) {
                                for (x = 0; x < complexSize - 1; ++x) {
                                    ((ComplexType)cursorOut.get()).setComplexNumber(tempOut[x * 2] / (float)realSize, tempOut[x * 2 + 1] / (float)realSize);
                                    cursorOut.fwd(0);
                                }
                                ((ComplexType)cursorOut.get()).setComplexNumber(tempOut[(complexSize - 1) * 2] / (float)realSize, tempOut[(complexSize - 1) * 2 + 1] / (float)realSize);
                                continue;
                            }
                            for (x = 0; x < complexSize - 1; ++x) {
                                ((ComplexType)cursorOut.get()).setComplexNumber(tempOut[x * 2], tempOut[x * 2 + 1]);
                                cursorOut.fwd(0);
                            }
                            ((ComplexType)cursorOut.get()).setComplexNumber(tempOut[(complexSize - 1) * 2], tempOut[(complexSize - 1) * 2 + 1]);
                        }
                    } else if (myNumber == 0) {
                        cursor.setPosition(-imageOffset[0] + (int)input.min(0), 0);
                        for (int x = 0; x < realSize - 1; ++x) {
                            tempIn[x] = ((RealType)cursor.get()).getRealFloat();
                            cursor.fwd(0);
                        }
                        tempIn[realSize - 1] = ((RealType)cursor.get()).getRealFloat();
                        float[] tempOut = new float[complexSize * 2];
                        fft.realToComplex(-1, tempIn, tempOut);
                        cursorOut.setPosition(0, 0);
                        if (scale) {
                            for (int x = 0; x < complexSize - 1; ++x) {
                                ((ComplexType)cursorOut.get()).setComplexNumber(tempOut[x * 2] / (float)realSize, tempOut[x * 2 + 1] / (float)realSize);
                                cursorOut.fwd(0);
                            }
                            ((ComplexType)cursorOut.get()).setComplexNumber(tempOut[(complexSize - 1) * 2] / (float)realSize, tempOut[(complexSize - 1) * 2 + 1] / (float)realSize);
                        } else {
                            for (int x = 0; x < complexSize - 1; ++x) {
                                ((ComplexType)cursorOut.get()).setComplexNumber(tempOut[x * 2], tempOut[x * 2 + 1]);
                                cursorOut.fwd(0);
                            }
                            ((ComplexType)cursorOut.get()).setComplexNumber(tempOut[(complexSize - 1) * 2], tempOut[(complexSize - 1) * 2 + 1]);
                        }
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin(threads);
        for (int d = 1; d < numDimensions; ++d) {
            final int dim = d;
            ai.set(0);
            threads = SimpleMultiThreading.newThreads(numThreads);
            for (int ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int myNumber = ai.getAndIncrement();
                        int size = (int)fftImage.dimension(dim);
                        float[] tempIn = new float[size * 2];
                        FftComplex fftc = new FftComplex(size);
                        RandomAccess cursor = fftImage.randomAccess();
                        int[] fakeSize = new int[numDimensions - 1];
                        int[] tmp = new int[numDimensions];
                        int countDim = 0;
                        for (int d = 0; d < numDimensions; ++d) {
                            if (d == dim) continue;
                            fakeSize[countDim++] = (int)fftImage.dimension(d);
                        }
                        LocalizingZeroMinIntervalIterator cursorDim = new LocalizingZeroMinIntervalIterator(fakeSize);
                        float[] tempOut = new float[size * 2];
                        while (cursorDim.hasNext()) {
                            int i;
                            cursorDim.fwd();
                            if (cursorDim.getIntPosition(0) % numThreads != myNumber) continue;
                            cursorDim.localize(fakeSize);
                            tmp[dim] = 0;
                            countDim = 0;
                            for (int d = 0; d < numDimensions; ++d) {
                                if (d == dim) continue;
                                tmp[d] = fakeSize[countDim++];
                            }
                            cursor.setPosition(tmp);
                            for (i = 0; i < size - 1; ++i) {
                                tempIn[i * 2] = ((ComplexType)cursor.get()).getRealFloat();
                                tempIn[i * 2 + 1] = ((ComplexType)cursor.get()).getImaginaryFloat();
                                cursor.fwd(dim);
                            }
                            tempIn[(size - 1) * 2] = ((ComplexType)cursor.get()).getRealFloat();
                            tempIn[(size - 1) * 2 + 1] = ((ComplexType)cursor.get()).getImaginaryFloat();
                            fftc.complexToComplex(-1, tempIn, tempOut);
                            cursor.setPosition(tmp);
                            if (scale) {
                                for (i = 0; i < size - 1; ++i) {
                                    ((ComplexType)cursor.get()).setComplexNumber(tempOut[i * 2] / (float)size, tempOut[i * 2 + 1] / (float)size);
                                    cursor.fwd(dim);
                                }
                                ((ComplexType)cursor.get()).setComplexNumber(tempOut[(size - 1) * 2] / (float)size, tempOut[(size - 1) * 2 + 1] / (float)size);
                                continue;
                            }
                            for (i = 0; i < size - 1; ++i) {
                                ((ComplexType)cursor.get()).setComplexNumber(tempOut[i * 2], tempOut[i * 2 + 1]);
                                cursor.fwd(dim);
                            }
                            ((ComplexType)cursor.get()).setComplexNumber(tempOut[(size - 1) * 2], tempOut[(size - 1) * 2 + 1]);
                        }
                    }
                });
            }
            SimpleMultiThreading.startAndJoin(threads);
        }
        return fftImage;
    }

    private static final <T extends Type<T>> void rearrangeQuadrantFFTDimZeroSingleDim(RandomAccessibleInterval<T> fftImage) {
        int sizeDim = (int)fftImage.dimension(0);
        int halfSizeDim = sizeDim / 2;
        int sizeDimMinus1 = sizeDim - 1;
        Type fftImageType = (Type)Util.getTypeFromInterval(fftImage);
        Type buffer = fftImageType.createVariable();
        RandomAccess cursor1 = fftImage.randomAccess();
        RandomAccess cursor2 = fftImage.randomAccess();
        cursor1.setPosition(0, 0);
        cursor2.setPosition(0, sizeDimMinus1);
        for (int i = 0; i < halfSizeDim - 1; ++i) {
            buffer.set((Type)((Type)cursor1.get()));
            ((Type)cursor1.get()).set((Type)cursor2.get());
            ((Type)cursor2.get()).set(buffer);
            cursor1.fwd(0);
            cursor2.bck(0);
        }
        buffer.set((Type)((Type)cursor1.get()));
        ((Type)cursor1.get()).set((Type)cursor2.get());
        ((Type)cursor2.get()).set(buffer);
    }

    private static final <T extends Type<T>> void rearrangeQuadrantFFTDimZero(final RandomAccessibleInterval<T> fftImage, final int numThreads) {
        final int numDimensions = fftImage.numDimensions();
        if (numDimensions == 1) {
            FFTFunctions.rearrangeQuadrantFFTDimZeroSingleDim(fftImage);
            return;
        }
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads(numThreads);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    int sizeDim = (int)fftImage.dimension(0);
                    int halfSizeDim = sizeDim / 2;
                    int sizeDimMinus1 = sizeDim - 1;
                    Type fftImageType = (Type)Util.getTypeFromInterval(fftImage);
                    Type buffer = fftImageType.createVariable();
                    RandomAccess cursor1 = fftImage.randomAccess();
                    RandomAccess cursor2 = fftImage.randomAccess();
                    int[] fakeSize = new int[numDimensions - 1];
                    int[] tmp = new int[numDimensions];
                    for (int d = 1; d < numDimensions; ++d) {
                        fakeSize[d - 1] = (int)fftImage.dimension(d);
                    }
                    LocalizingZeroMinIntervalIterator cursorDim = new LocalizingZeroMinIntervalIterator(fakeSize);
                    while (cursorDim.hasNext()) {
                        cursorDim.fwd();
                        if (cursorDim.getLongPosition(0) % (long)numThreads != (long)myNumber) continue;
                        cursorDim.localize(fakeSize);
                        tmp[0] = 0;
                        for (int d = 1; d < numDimensions; ++d) {
                            tmp[d] = fakeSize[d - 1];
                        }
                        cursor1.setPosition(tmp);
                        tmp[0] = sizeDimMinus1;
                        cursor2.setPosition(tmp);
                        for (int i = 0; i < halfSizeDim - 1; ++i) {
                            buffer.set((Type)((Type)cursor1.get()));
                            ((Type)cursor1.get()).set((Type)cursor2.get());
                            ((Type)cursor2.get()).set(buffer);
                            cursor1.fwd(0);
                            cursor2.bck(0);
                        }
                        buffer.set((Type)((Type)cursor1.get()));
                        ((Type)cursor1.get()).set((Type)cursor2.get());
                        ((Type)cursor2.get()).set(buffer);
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin(threads);
    }

    private static final <T extends Type<T>> void rearrangeQuadrantDim(final RandomAccessibleInterval<T> fftImage, final int dim, boolean forward, final int numThreads) {
        final int numDimensions = fftImage.numDimensions();
        if (fftImage.dimension(dim) % 2L == 1L) {
            FFTFunctions.rearrangeQuadrantDimOdd(fftImage, dim, forward, numThreads);
            return;
        }
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads(numThreads);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    int sizeDim = (int)fftImage.dimension(dim);
                    int halfSizeDim = sizeDim / 2;
                    Type fftImageType = (Type)Util.getTypeFromInterval(fftImage);
                    Type buffer = fftImageType.createVariable();
                    RandomAccess cursor1 = fftImage.randomAccess();
                    RandomAccess cursor2 = fftImage.randomAccess();
                    int[] fakeSize = new int[numDimensions - 1];
                    int[] tmp = new int[numDimensions];
                    int countDim = 0;
                    for (int d = 0; d < numDimensions; ++d) {
                        if (d == dim) continue;
                        fakeSize[countDim++] = (int)fftImage.dimension(d);
                    }
                    LocalizingZeroMinIntervalIterator cursorDim = new LocalizingZeroMinIntervalIterator(fakeSize);
                    while (cursorDim.hasNext()) {
                        cursorDim.fwd();
                        if (cursorDim.getIntPosition(0) % numThreads != myNumber) continue;
                        cursorDim.localize(fakeSize);
                        tmp[dim] = 0;
                        countDim = 0;
                        for (int d = 0; d < numDimensions; ++d) {
                            if (d == dim) continue;
                            tmp[d] = fakeSize[countDim++];
                        }
                        cursor1.setPosition(tmp);
                        tmp[dim] = halfSizeDim;
                        cursor2.setPosition(tmp);
                        for (int i = 0; i < halfSizeDim - 1; ++i) {
                            buffer.set((Type)((Type)cursor1.get()));
                            ((Type)cursor1.get()).set((Type)cursor2.get());
                            ((Type)cursor2.get()).set(buffer);
                            cursor1.fwd(dim);
                            cursor2.fwd(dim);
                        }
                        buffer.set((Type)((Type)cursor1.get()));
                        ((Type)cursor1.get()).set((Type)cursor2.get());
                        ((Type)cursor2.get()).set(buffer);
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin(threads);
    }

    private static final <T extends Type<T>> void rearrangeQuadrantDimOdd(final RandomAccessibleInterval<T> fftImage, final int dim, final boolean forward, final int numThreads) {
        final int numDimensions = fftImage.numDimensions();
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads(numThreads);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    int sizeDim = (int)fftImage.dimension(dim);
                    int sizeDimMinus1 = sizeDim - 1;
                    int halfSizeDim = sizeDim / 2;
                    Type fftImageType = (Type)Util.getTypeFromInterval(fftImage);
                    Type buffer1 = fftImageType.createVariable();
                    Type buffer2 = fftImageType.createVariable();
                    RandomAccess cursor1 = fftImage.randomAccess();
                    RandomAccess cursor2 = fftImage.randomAccess();
                    int[] fakeSize = new int[numDimensions - 1];
                    int[] tmp = new int[numDimensions];
                    int countDim = 0;
                    for (int d = 0; d < numDimensions; ++d) {
                        if (d == dim) continue;
                        fakeSize[countDim++] = (int)fftImage.dimension(d);
                    }
                    LocalizingZeroMinIntervalIterator cursorDim = new LocalizingZeroMinIntervalIterator(fakeSize);
                    while (cursorDim.hasNext()) {
                        cursorDim.fwd();
                        if (cursorDim.getIntPosition(0) % numThreads != myNumber) continue;
                        cursorDim.localize(fakeSize);
                        tmp[dim] = 0;
                        countDim = 0;
                        for (int d = 0; d < numDimensions; ++d) {
                            if (d == dim) continue;
                            tmp[d] = fakeSize[countDim++];
                        }
                        tmp[dim] = halfSizeDim;
                        cursor1.setPosition(tmp);
                        tmp[dim] = forward ? sizeDimMinus1 : 0;
                        cursor2.setPosition(tmp);
                        buffer1.set((Type)((Type)cursor1.get()));
                        for (int i = 0; i < halfSizeDim; ++i) {
                            buffer2.set((Type)((Type)cursor2.get()));
                            ((Type)cursor2.get()).set(buffer1);
                            if (forward) {
                                cursor1.bck(dim);
                            } else {
                                cursor1.fwd(dim);
                            }
                            buffer1.set((Type)((Type)cursor1.get()));
                            ((Type)cursor1.get()).set(buffer2);
                            if (forward) {
                                cursor2.bck(dim);
                                continue;
                            }
                            cursor2.fwd(dim);
                        }
                        cursor2.setPosition(halfSizeDim, dim);
                        ((Type)cursor2.get()).set(buffer1);
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin(threads);
    }

    public static final <T extends Type<T>> void rearrangeFFTQuadrants(RandomAccessibleInterval<T> fftImage, boolean forward, int numThreads) {
        FFTFunctions.rearrangeQuadrantFFTDimZero(fftImage, numThreads);
        for (int d = 1; d < fftImage.numDimensions(); ++d) {
            FFTFunctions.rearrangeQuadrantDim(fftImage, d, forward, numThreads);
        }
    }
}

