/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.fft;

import net.imglib2.Cursor;
import net.imglib2.algorithm.Benchmark;
import net.imglib2.algorithm.OutputAlgorithm;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.util.Util;

public class Bandpass<T extends NumericType<T>>
implements OutputAlgorithm<Img<T>>,
Benchmark {
    String errorMessage = "";
    boolean inPlace;
    boolean bandPass;
    Img<T> img;
    Img<T> output;
    int beginRadius;
    int endRadius;
    long processingTime;
    long[] origin;

    public Bandpass(Img<T> img, int beginRadius, int endRadius) {
        this.img = img;
        this.inPlace = false;
        this.bandPass = true;
        this.beginRadius = beginRadius;
        this.endRadius = endRadius;
        this.origin = new long[img.numDimensions()];
        this.origin[0] = img.dimension(0) - 1L;
        for (int d = 1; d < this.origin.length; ++d) {
            this.origin[d] = img.dimension(d) / 2L;
        }
    }

    public void setImage(Img<T> img) {
        this.img = img;
    }

    public void setInPlace(boolean inPlace) {
        this.inPlace = inPlace;
    }

    public void setBandPass(boolean bandPass) {
        this.bandPass = bandPass;
    }

    public void setOrigin(long[] position) {
        this.origin = (long[])position.clone();
    }

    public void setBandPassRadius(int beginRadius, int endRadius) {
        this.beginRadius = beginRadius;
        this.endRadius = endRadius;
    }

    public Img<T> getImage() {
        return this.img;
    }

    public boolean getInPlace() {
        return this.inPlace;
    }

    public int getBeginBandPassRadius() {
        return this.beginRadius;
    }

    public int getEndBandPassRadius() {
        return this.endRadius;
    }

    public long[] getOrigin() {
        return this.origin;
    }

    public boolean process() {
        Img<T> img;
        long startTime = System.currentTimeMillis();
        if (this.inPlace) {
            img = this.img;
        } else {
            this.output = this.img.copy();
            img = this.output;
        }
        Cursor cursor = img.cursor();
        long[] pos = new long[img.numDimensions()];
        boolean actAsBandPass = this.bandPass;
        while (cursor.hasNext()) {
            cursor.fwd();
            cursor.localize(pos);
            float dist = Util.computeDistance(this.origin, pos);
            if (actAsBandPass) {
                if (!(dist < (float)this.beginRadius) && !(dist > (float)this.endRadius)) continue;
                ((NumericType)cursor.get()).setZero();
                continue;
            }
            if (!(dist >= (float)this.beginRadius) || !(dist <= (float)this.endRadius)) continue;
            ((NumericType)cursor.get()).setZero();
        }
        this.processingTime = System.currentTimeMillis() - startTime;
        return true;
    }

    public Img<T> getResult() {
        if (this.inPlace) {
            return this.img;
        }
        return this.output;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public boolean checkInput() {
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

