/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.rmi.MarshalException;
import java.util.Map;
import javax.net.SocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.serialization.ClassLoaderUtility;
import org.jboss.remoting.transport.socket.MicroSocketClientInvoker;
import org.jboss.remoting.transport.socket.OpenConnectionChecker;
import org.jboss.remoting.transport.socket.ServerAddress;
import org.jboss.remoting.transport.socket.SocketWrapper;

public class SocketClientInvoker
extends MicroSocketClientInvoker {
    private static final Logger log = Logger.getLogger(class$org$jboss$remoting$transport$socket$SocketClientInvoker == null ? (class$org$jboss$remoting$transport$socket$SocketClientInvoker = SocketClientInvoker.class$("org.jboss.remoting.transport.socket.SocketClientInvoker")) : class$org$jboss$remoting$transport$socket$SocketClientInvoker);
    private static final boolean isTraceEnabled = log.isTraceEnabled();
    public static final String SO_TIMEOUT_FLAG = "timeout";
    public static final int SO_TIMEOUT_DEFAULT = 1800000;
    protected int timeout = 1800000;
    private Constructor clientSocketConstructor = null;
    static /* synthetic */ Class class$org$jboss$remoting$transport$socket$SocketClientInvoker;
    static /* synthetic */ Class class$java$net$Socket;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$Integer;

    public SocketClientInvoker(InvokerLocator locator) {
        this(locator, null);
    }

    public SocketClientInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
        this.configureParameters();
    }

    protected ServerAddress createServerAddress() {
        return new ServerAddress(this.addr.getHostAddress(), this.port, this.enableTcpNoDelay, this.timeout);
    }

    protected void configureParameters() {
        Object val;
        super.configureParameters();
        Map params = this.configuration;
        if (params != null && (val = params.get(SO_TIMEOUT_FLAG)) != null) {
            try {
                this.timeout = Integer.valueOf((String)val);
                log.debug(this + " setting timeout to " + this.timeout);
            }
            catch (Exception e) {
                log.warn(this + " could not convert " + SO_TIMEOUT_FLAG + " value of " + val + " to a int value.");
            }
        }
    }

    protected Object handleException(Exception ex, SocketWrapper socketWrapper) throws ClassNotFoundException, MarshalException {
        log.error("Got marshalling exception, exiting", ex);
        if (ex instanceof ClassNotFoundException) {
            log.error("Error loading classes from remote call result.", ex);
            throw (ClassNotFoundException)ex;
        }
        if (ex instanceof SocketTimeoutException) {
            throw new MarshalException("Socket timed out.  Waited " + socketWrapper.getTimeout() + " milliseconds for response while calling on " + this.getLocator(), ex);
        }
        throw new MarshalException("Failed to communicate.  Problem during marshalling/unmarshalling", ex);
    }

    protected SocketWrapper createClientSocket(Socket socket, int timeout, Map metadata) throws Exception {
        if (this.clientSocketConstructor == null) {
            if (this.clientSocketClass == null) {
                this.clientSocketClass = ClassLoaderUtility.loadClass(this.getClass(), this.clientSocketClassName);
            }
            try {
                this.clientSocketConstructor = this.clientSocketClass.getConstructor(class$java$net$Socket == null ? (class$java$net$Socket = SocketClientInvoker.class$("java.net.Socket")) : class$java$net$Socket, class$java$util$Map == null ? (class$java$util$Map = SocketClientInvoker.class$("java.util.Map")) : class$java$util$Map, class$java$lang$Integer == null ? (class$java$lang$Integer = SocketClientInvoker.class$("java.lang.Integer")) : class$java$lang$Integer);
            }
            catch (NoSuchMethodException e) {
                this.clientSocketConstructor = this.clientSocketClass.getConstructor(class$java$net$Socket == null ? (class$java$net$Socket = SocketClientInvoker.class$("java.net.Socket")) : class$java$net$Socket);
            }
        }
        SocketWrapper clientSocketWrapper = null;
        if (this.clientSocketConstructor.getParameterTypes().length == 3) {
            clientSocketWrapper = (SocketWrapper)this.clientSocketConstructor.newInstance(socket, metadata, new Integer(timeout));
        } else {
            clientSocketWrapper = (SocketWrapper)this.clientSocketConstructor.newInstance(socket);
            clientSocketWrapper.setTimeout(timeout);
        }
        return clientSocketWrapper;
    }

    protected Socket createSocket(String address, int port, int timeout) throws IOException {
        Socket s = null;
        SocketFactory socketFactory = this.getSocketFactory();
        s = socketFactory != null ? socketFactory.createSocket() : new Socket();
        s.setReuseAddress(this.getReuseAddress());
        InetSocketAddress inetAddr = new InetSocketAddress(address, port);
        if (timeout < 0 && (timeout = this.getTimeout()) < 0) {
            timeout = 0;
        }
        s.connect(inetAddr, timeout);
        return s;
    }

    protected SocketWrapper getPooledConnection() {
        SocketWrapper socketWrapper = null;
        while (this.pool.size() > 0) {
            socketWrapper = (SocketWrapper)this.pool.removeFirst();
            try {
                if (socketWrapper == null) continue;
                if (socketWrapper instanceof OpenConnectionChecker) {
                    ((OpenConnectionChecker)((Object)socketWrapper)).checkOpenConnection();
                }
                if (this.shouldCheckConnection) {
                    socketWrapper.checkConnection();
                    return socketWrapper;
                }
                if (socketWrapper.getSocket().isConnected()) {
                    return socketWrapper;
                }
                try {
                    socketWrapper.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                return null;
            }
            catch (Exception ex) {
                if (isTraceEnabled) {
                    log.trace("Couldn't reuse connection from pool");
                }
                try {
                    socketWrapper.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String toString() {
        return "SocketClientInvoker[" + Integer.toHexString(System.identityHashCode(this)) + ", " + this.locator.getProtocol() + "://" + this.locator.getHost() + ":" + this.locator.getPort() + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

