/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.security;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.security.RunAs;
import org.jboss.aspects.security.SecurityActions;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.RunAsIdentity;

public class RunAsSecurityInterceptor
implements Interceptor {
    private static final Logger log = Logger.getLogger((Class)RunAsSecurityInterceptor.class);
    protected AuthenticationManager securityManager;
    protected RealmMapping realmMapping;

    public RunAsSecurityInterceptor(AuthenticationManager manager, RealmMapping realmMapping) {
        this.securityManager = manager;
        this.realmMapping = realmMapping;
    }

    public String getName() {
        return "RunAsSecurityInterceptor";
    }

    protected RunAsIdentity getRunAsIdentity(Invocation invocation) {
        RunAsIdentity identity = (RunAsIdentity)invocation.getMetaData((Object)"security", (Object)"run-as");
        if (identity == null) {
            identity = this.getAnnotationRunAsIdentity(invocation);
        }
        return identity;
    }

    protected RunAsIdentity getAnnotationRunAsIdentity(Invocation invocation) {
        RunAs runAs = (RunAs)invocation.resolveAnnotation(RunAs.class);
        if (runAs == null) {
            return null;
        }
        RunAsIdentity runAsRole = new RunAsIdentity(runAs.value(), null);
        return runAsRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        RunAsIdentity runAsRole = this.getRunAsIdentity(invocation);
        if (runAsRole != null) {
            SecurityActions.pushRunAsIdentity(runAsRole);
        }
        try {
            Object object = invocation.invokeNext();
            return object;
        }
        finally {
            if (runAsRole != null) {
                SecurityActions.popRunAsIdentity();
            }
        }
    }
}

