/*
 * Decompiled with CFR 0.152.
 */
package endrov.bindingMac;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import quicktime.QTException;
import quicktime.QTSession;
import quicktime.io.OpenMovieFile;
import quicktime.io.QTFile;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.std.StdQTConstants;
import quicktime.std.image.CSequence;
import quicktime.std.image.CodecComponent;
import quicktime.std.image.CompressedFrameInfo;
import quicktime.std.image.ImageDescription;
import quicktime.std.image.QTImage;
import quicktime.std.movies.Movie;
import quicktime.std.movies.Track;
import quicktime.std.movies.media.SampleDescription;
import quicktime.std.movies.media.VideoMedia;
import quicktime.util.EndianOrder;
import quicktime.util.QTHandle;
import quicktime.util.QTHandleRef;
import quicktime.util.RawEncodedImage;

public class QuickTime_Writer
implements StdQTConstants {
    static final int KEY_FRAME_RATE = 30;
    static final int TIME_SCALE = 600;
    static String[] codecs = new String[]{"Cinepak", "Animation", "H.263", "Sorenson", "Sorenson 3", "MPEG-4"};
    static int[] codecTypes = new int[]{1668704612, 1919706400, 1748121139, 1398165809, 1398165811, 1836070006};
    static String codec = "Sorenson";
    static String[] qualityStrings = new String[]{"Low", "Normal", "High", "Maximum"};
    static int[] qualityConstants = new int[]{256, 512, 768, 1023};
    static String quality = "Normal";

    public static void foo() {
        int codecType = 1398165809;
        int i = 0;
        while (i < codecs.length) {
            if (codec.equals(codecs[i])) {
                codecType = codecTypes[i];
            }
            ++i;
        }
        int codecQuality = 512;
        int i2 = 0;
        while (i2 < qualityStrings.length) {
            if (quality.equals(qualityStrings[i2])) {
                codecQuality = qualityConstants[i2];
            }
            ++i2;
        }
        double fps = 7.0;
        int rate = (int)(600.0 / fps);
        try {
            QTSession.open();
            QuickTime_Writer.writeMovie("/foo.mov", codecType, codecQuality, rate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        QTSession.close();
    }

    public static void writeMovie(String path, int codecType, int codecQuality, int rate) throws QTException, IOException {
        int finalWidth = 0;
        int finalHeight = 0;
        int timeScale = 600;
        QTFile movFile = new QTFile(new File(path));
        Movie movie = Movie.createMovieFile((QTFile)movFile, (int)1414942532, (int)-1879048192);
        Track videoTrack = movie.addTrack((float)finalWidth, (float)finalHeight, 0.0f);
        VideoMedia videoMedia = new VideoMedia(videoTrack, timeScale);
        videoMedia.beginEdits();
        ImageDescription imgDesc2 = new ImageDescription(32);
        imgDesc2.setWidth(finalWidth);
        imgDesc2.setHeight(finalHeight);
        QDGraphics gw = new QDGraphics(imgDesc2, 0);
        QDRect bounds = new QDRect(0, 0, finalWidth, finalHeight);
        int rawImageSize = QTImage.getMaxCompressionSize((QDGraphics)gw, (QDRect)bounds, (int)gw.getPixMap().getPixelSize(), (int)codecQuality, (int)codecType, (CodecComponent)CodecComponent.anyCodec);
        QTHandle imageHandle = new QTHandle(rawImageSize, true);
        imageHandle.lock();
        RawEncodedImage compressedImage = RawEncodedImage.fromQTHandle((QTHandleRef)imageHandle);
        CSequence seq = new CSequence(gw, bounds, gw.getPixMap().getPixelSize(), codecType, CodecComponent.bestFidelityCodec, codecQuality, codecQuality, 30, null, 0);
        ImageDescription imgDesc = seq.getDescription();
        int[] pixelsNativeOrder = null;
        BufferedImage im = new BufferedImage(0, 0, 0);
        int[] pixels = new int[im.getWidth() * im.getHeight()];
        im.getRaster().getSamples(0, 0, im.getWidth(), im.getHeight(), 0, pixels);
        RawEncodedImage pixelData = gw.getPixMap().getPixelData();
        int intsPerRow = pixelData.getRowBytes() / 4;
        if (pixelsNativeOrder == null) {
            pixelsNativeOrder = new int[intsPerRow * finalHeight];
        }
        if (EndianOrder.isNativeLittleEndian()) {
            int y = 0;
            while (y < finalHeight) {
                int offset1 = y * finalWidth;
                int offset2 = y * intsPerRow;
                int x = 0;
                while (x < finalWidth) {
                    pixelsNativeOrder[offset2++] = EndianOrder.flipBigEndianToNative32((int)pixels[offset1++]);
                    ++x;
                }
                ++y;
            }
            pixelData.copyFromArray(0, pixelsNativeOrder, 0, intsPerRow * finalHeight);
        } else {
            int i = 0;
            while (i < finalHeight) {
                System.arraycopy(pixels, i * finalWidth, pixelsNativeOrder, i * intsPerRow, finalWidth);
                ++i;
            }
            pixelData.copyFromArray(0, pixels, 0, intsPerRow * finalHeight);
        }
        CompressedFrameInfo cfInfo = seq.compressFrame(gw, bounds, 4, compressedImage);
        boolean syncSample = cfInfo.getSimilarity() == 0;
        videoMedia.addSample((QTHandleRef)imageHandle, 0, cfInfo.getDataSize(), rate, (SampleDescription)imgDesc, 1, syncSample ? 0 : 1);
        videoMedia.endEdits();
        videoTrack.insertMedia(0, 0, videoMedia.getDuration(), 1.0f);
        OpenMovieFile omf = OpenMovieFile.asWrite((QTFile)movFile);
        movie.addResource(omf, -1, movFile.getName());
    }
}

