/*
 * Decompiled with CFR 0.152.
 */
package endrov.bindingMac;

import endrov.movieEncoder.EvMovieEncoder;
import java.awt.image.BufferedImage;
import java.io.File;
import quicktime.QTSession;
import quicktime.io.OpenMovieFile;
import quicktime.io.QTFile;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.std.StdQTConstants;
import quicktime.std.image.CSequence;
import quicktime.std.image.CodecComponent;
import quicktime.std.image.CompressedFrameInfo;
import quicktime.std.image.ImageDescription;
import quicktime.std.image.QTImage;
import quicktime.std.movies.Movie;
import quicktime.std.movies.Track;
import quicktime.std.movies.media.SampleDescription;
import quicktime.std.movies.media.VideoMedia;
import quicktime.util.EndianOrder;
import quicktime.util.QTHandle;
import quicktime.util.QTHandleRef;
import quicktime.util.RawEncodedImage;

public class QTMovieMaker
implements StdQTConstants,
EvMovieEncoder {
    public static final String[] codecs = new String[]{"Cinepak", "Animation", "H.263", "Sorenson", "Sorenson 3", "h.264 (MPEG-4)"};
    private static final int[] codecTypes = new int[]{1668704612, 1919706400, 1748121139, 1398165809, 1398165811, 1836070006};
    public static final String[] qualityStrings = new String[]{"Low", "Normal", "High", "Maximum"};
    private static final int[] qualityConstants = new int[]{256, 512, 768, 1023};
    private final RawEncodedImage compressedImage;
    private final ImageDescription imgDesc;
    private final Movie movie;
    private final VideoMedia videoMedia;
    private final Track videoTrack;
    private final QTFile movFile;
    private final QDGraphics gw;
    private final CSequence seq;
    private final QDRect bounds;
    private final QTHandle imageHandle;
    private int[] pixelsNativeOrder = null;
    private final int movieWidth;
    private final int movieHeight;
    private final int rate;
    private int timeScale = 600;
    private final int keyFrameRate = 30;
    private File tempFile;
    private File finalFile;

    private int qualityToInt(String quality) throws Exception {
        int i = 0;
        while (i < qualityStrings.length) {
            if (quality.equals(qualityStrings[i])) {
                return qualityConstants[i];
            }
            ++i;
        }
        throw new Exception("Quality not found");
    }

    private int codecToInt(String codec) throws Exception {
        int i = 0;
        while (i < codecs.length) {
            if (codec.equals(codecs[i])) {
                return codecTypes[i];
            }
            ++i;
        }
        throw new Exception("Codec not found");
    }

    public QTMovieMaker(File path, int finalWidth, int finalHeight, String codec, String quality) throws Exception {
        if (!path.getName().endsWith(".mov")) {
            path = new File(path.getParentFile(), String.valueOf(path.getName()) + ".mov");
        }
        int codecType = this.codecToInt(codec);
        int codecQuality = this.qualityToInt(quality);
        this.movieWidth = finalWidth;
        this.movieHeight = finalHeight;
        double fps = 7.0;
        this.rate = (int)((double)this.timeScale / fps);
        CodecComponent cc = CodecComponent.bestFidelityCodec;
        QTSession.open();
        System.out.println("Target movie file: " + path);
        this.finalFile = path;
        this.tempFile = new File(this.finalFile.getParentFile(), "_temp.mov");
        this.movFile = new QTFile(this.tempFile);
        this.movie = Movie.createMovieFile((QTFile)this.movFile, (int)1414942532, (int)-1879048192);
        this.videoTrack = this.movie.addTrack((float)finalWidth, (float)finalHeight, 0.0f);
        this.videoMedia = new VideoMedia(this.videoTrack, this.timeScale);
        this.videoMedia.beginEdits();
        ImageDescription imgDesc2 = new ImageDescription(32);
        imgDesc2.setWidth(finalWidth);
        imgDesc2.setHeight(finalHeight);
        this.gw = new QDGraphics(imgDesc2, 0);
        this.bounds = new QDRect(0, 0, finalWidth, finalHeight);
        int rawImageSize = QTImage.getMaxCompressionSize((QDGraphics)this.gw, (QDRect)this.bounds, (int)this.gw.getPixMap().getPixelSize(), (int)codecQuality, (int)codecType, (CodecComponent)cc);
        this.imageHandle = new QTHandle(rawImageSize, true);
        this.imageHandle.lock();
        this.compressedImage = RawEncodedImage.fromQTHandle((QTHandleRef)this.imageHandle);
        this.seq = new CSequence(this.gw, this.bounds, this.gw.getPixMap().getPixelSize(), codecType, cc, codecQuality, codecQuality, 30, null, 0);
        this.imgDesc = this.seq.getDescription();
    }

    public void done() throws Exception {
        this.videoMedia.endEdits();
        this.videoTrack.insertMedia(0, 0, this.videoMedia.getDuration(), 1.0f);
        OpenMovieFile omf = OpenMovieFile.asWrite((QTFile)this.movFile);
        this.movie.addResource(omf, -1, this.movFile.getName());
        omf.close();
        this.tempFile.renameTo(this.finalFile);
        System.out.println("done movie");
    }

    public void addFrame(BufferedImage im) throws Exception {
        int[] pixels = new int[im.getWidth() * im.getHeight()];
        im.getRaster().getSamples(0, 0, im.getWidth(), im.getHeight(), 0, pixels);
        int i = 0;
        while (i < pixels.length) {
            pixels[i] = pixels[i] | pixels[i] << 8 | pixels[i] << 16;
            ++i;
        }
        RawEncodedImage pixelData = this.gw.getPixMap().getPixelData();
        int intsPerRow = pixelData.getRowBytes() / 4;
        if (this.pixelsNativeOrder == null) {
            this.pixelsNativeOrder = new int[intsPerRow * this.movieHeight];
        }
        if (EndianOrder.isNativeLittleEndian()) {
            int y = 0;
            while (y < this.movieHeight) {
                int offset1 = y * this.movieWidth;
                int offset2 = y * intsPerRow;
                int x = 0;
                while (x < this.movieWidth) {
                    this.pixelsNativeOrder[offset2++] = EndianOrder.flipBigEndianToNative32((int)pixels[offset1++]);
                    ++x;
                }
                ++y;
            }
        } else {
            int i2 = 0;
            while (i2 < this.movieHeight) {
                System.arraycopy(pixels, i2 * this.movieWidth, this.pixelsNativeOrder, i2 * intsPerRow, this.movieWidth);
                ++i2;
            }
        }
        pixelData.copyFromArray(0, this.pixelsNativeOrder, 0, intsPerRow * this.movieHeight);
        CompressedFrameInfo cfInfo = this.seq.compressFrame(this.gw, this.bounds, 4, this.compressedImage);
        boolean syncSample = cfInfo.getSimilarity() == 0;
        this.videoMedia.addSample((QTHandleRef)this.imageHandle, 0, cfInfo.getDataSize(), this.rate, (SampleDescription)this.imgDesc, 1, syncSample ? 0 : 1);
    }
}

