/*
 * Decompiled with CFR 0.152.
 */
package ome.metakit;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import ome.metakit.Column;
import ome.metakit.ColumnMap;
import ome.metakit.MetakitException;
import ome.metakit.MetakitTools;

public class MetakitReader {
    private RandomAccessInputStream stream;
    private String[] tableNames;
    private Column[][] columns;
    private int[] rowCount;
    private Object[][][] data;
    private boolean littleEndian = false;

    public MetakitReader(String file) throws IOException, MetakitException {
        this(new RandomAccessInputStream(file));
    }

    public MetakitReader(RandomAccessInputStream stream) throws MetakitException {
        this.stream = stream;
        try {
            this.initialize();
        }
        catch (IOException e) {
            throw new MetakitException(e);
        }
    }

    public int getTableCount() {
        return this.tableNames.length;
    }

    public String[] getTableNames() {
        return this.tableNames;
    }

    public String[] getColumnNames(int tableIndex) {
        String[] columnNames = new String[this.columns[tableIndex].length];
        for (int i = 0; i < columnNames.length; ++i) {
            columnNames[i] = this.columns[tableIndex][i].getName();
        }
        return columnNames;
    }

    public String[] getColumnNames(String tableName) {
        return this.getColumnNames(DataTools.indexOf(this.tableNames, tableName));
    }

    public Class[] getColumnTypes(int tableIndex) {
        Class[] types = new Class[this.columns[tableIndex].length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.columns[tableIndex][i].getType();
        }
        return types;
    }

    public Class[] getColumnTypes(String tableName) {
        return this.getColumnTypes(DataTools.indexOf(this.tableNames, tableName));
    }

    public int getRowCount(int tableIndex) {
        return this.rowCount[tableIndex];
    }

    public int getRowCount(String tableName) {
        return this.getRowCount(DataTools.indexOf(this.tableNames, tableName));
    }

    public Object[][] getTableData(int tableIndex) {
        Object[][] table = this.data[tableIndex];
        if (table == null) {
            return null;
        }
        int rowCount = table[0] == null ? 0 : table[0].length;
        Object[][] newTable = new Object[rowCount][table.length];
        for (int row = 0; row < newTable.length; ++row) {
            for (int col = 0; col < newTable[row].length; ++col) {
                if (col >= table.length || row >= table[col].length) continue;
                newTable[row][col] = table[col][row];
            }
        }
        return newTable;
    }

    public Object[][] getTableData(String tableName) {
        return this.getTableData(DataTools.indexOf(this.tableNames, tableName));
    }

    public Object[] getRowData(int rowIndex, int tableIndex) {
        Object[] row = new Object[this.data[tableIndex].length];
        for (int col = 0; col < this.data[tableIndex].length; ++col) {
            row[col] = this.data[tableIndex][col][rowIndex];
        }
        return row;
    }

    public Object[] getRowData(int rowIndex, String tableName) {
        return this.getRowData(rowIndex, DataTools.indexOf(this.tableNames, tableName));
    }

    private void initialize() throws IOException, MetakitException {
        boolean valid;
        String magic = this.stream.readString(2);
        if (magic.equals("JL")) {
            this.littleEndian = true;
        } else if (!magic.equals("LJ")) {
            throw new MetakitException("Invalid magic string; got " + magic);
        }
        boolean bl = valid = this.stream.read() == 26;
        if (!valid) {
            throw new MetakitException("'valid' flag was set to 'false'");
        }
        int headerType = this.stream.read();
        if (headerType != 0) {
            throw new MetakitException("Header type " + headerType + " is not valid.");
        }
        long footerPointer = this.stream.readInt() - 16;
        this.stream.seek(footerPointer);
        this.readFooter();
    }

    private void readFooter() throws IOException, MetakitException {
        this.stream.skipBytes(4);
        long headerLocation = this.stream.readInt();
        this.stream.skipBytes(4);
        long tocLocation = this.stream.readInt();
        this.stream.seek(tocLocation);
        this.readTOC();
    }

    private void readTOC() throws IOException, MetakitException {
        int tocMarker = MetakitTools.readBpInt(this.stream);
        String structureDefinition = MetakitTools.readPString(this.stream);
        String[] tables = structureDefinition.split("],");
        this.tableNames = new String[tables.length];
        this.columns = new Column[tables.length][];
        boolean[] hasSubviews = new boolean[tables.length];
        for (int i = 0; i < tables.length; ++i) {
            String table = tables[i];
            int openBracket = table.indexOf("[");
            this.tableNames[i] = table.substring(0, openBracket);
            String columnList = table.substring(openBracket + 1);
            hasSubviews[i] = (openBracket = columnList.indexOf("[")) >= 0;
            columnList = columnList.substring(openBracket + 1);
            String[] cols = columnList.split(",");
            this.columns[i] = new Column[cols.length];
            for (int col = 0; col < cols.length; ++col) {
                this.columns[i][col] = new Column(cols[col]);
            }
        }
        this.rowCount = new int[tables.length];
        MetakitTools.readBpInt(this.stream);
        this.data = new Object[tables.length][][];
        for (int table = 0; table < tables.length; ++table) {
            MetakitTools.readBpInt(this.stream);
            int pointer = MetakitTools.readBpInt(this.stream);
            long fp = this.stream.getFilePointer();
            this.stream.seek(pointer + 1);
            this.rowCount[table] = MetakitTools.readBpInt(this.stream);
            if (hasSubviews[table]) {
                int subviewCount = this.rowCount[table];
                long base = this.stream.getFilePointer();
                this.rowCount[table] = 0;
                Object[][][] subviewTable = new Object[subviewCount][this.columns[table].length][];
                for (int subview = 0; subview < subviewCount; ++subview) {
                    if (subview == 0) {
                        int size = MetakitTools.readBpInt(this.stream);
                        long subviewPointer = MetakitTools.readBpInt(this.stream);
                        base = this.stream.getFilePointer();
                        this.stream.seek(subviewPointer);
                    }
                    MetakitTools.readBpInt(this.stream);
                    int count = MetakitTools.readBpInt(this.stream);
                    if (count <= 1) continue;
                    int n = table;
                    this.rowCount[n] = this.rowCount[n] + count;
                    for (int col = 0; col < this.columns[table].length; ++col) {
                        this.stream.order(this.littleEndian);
                        ColumnMap map = new ColumnMap(this.columns[table][col], this.stream, count);
                        subviewTable[subview][col] = map.getValues();
                    }
                }
                this.data[table] = new Object[this.columns[table].length][this.rowCount[table]];
                int index = 0;
                for (int subview = 0; subview < subviewCount; ++subview) {
                    if (subviewTable[subview][0] == null) continue;
                    for (int col = 0; col < this.columns[table].length; ++col) {
                        System.arraycopy(subviewTable[subview][col], 0, this.data[table][col], index, subviewTable[subview][col].length);
                    }
                    index += subviewTable[subview][0].length;
                }
            } else {
                this.data[table] = new Object[this.columns[table].length][];
                if (this.rowCount[table] > 0) {
                    for (int col = 0; col < this.columns[table].length; ++col) {
                        this.stream.order(this.littleEndian);
                        ColumnMap map = new ColumnMap(this.columns[table][col], this.stream, this.rowCount[table]);
                        this.data[table][col] = map.getValues();
                    }
                }
            }
            this.stream.seek(fp);
        }
    }
}

